/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.wsrp.exception.NoSuchConsumerException;
import com.liferay.wsrp.exception.WSRPConsumerNameException;
import com.liferay.wsrp.exception.WSRPConsumerWSDLException;
import com.liferay.wsrp.model.WSRPConsumer;
import com.liferay.wsrp.model.WSRPConsumerPortlet;
import com.liferay.wsrp.service.base.WSRPConsumerLocalServiceBaseImpl;
import com.liferay.wsrp.util.WSRPConsumerManager;
import com.liferay.wsrp.util.WSRPConsumerManagerFactory;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import oasis.names.tc.wsrp.v2.intf.WSRP_v2_Registration_PortType;
import oasis.names.tc.wsrp.v2.types.Lifetime;
import oasis.names.tc.wsrp.v2.types.ModifyRegistration;
import oasis.names.tc.wsrp.v2.types.Property;
import oasis.names.tc.wsrp.v2.types.PropertyDescription;
import oasis.names.tc.wsrp.v2.types.Register;
import oasis.names.tc.wsrp.v2.types.RegistrationContext;
import oasis.names.tc.wsrp.v2.types.RegistrationData;
import oasis.names.tc.wsrp.v2.types.RegistrationState;

public class WSRPConsumerLocalServiceImpl
extends WSRPConsumerLocalServiceBaseImpl {
    @ServiceReference(type=WSRPConsumerManagerFactory.class)
    private WSRPConsumerManagerFactory _wsrpConsumerManagerFactory;

    public WSRPConsumer addWSRPConsumer(long companyId, String adminPortletId, String name, String url, String forwardCookies, String forwardHeaders, String markupCharacterSets, ServiceContext serviceContext) throws PortalException {
        Date now = new Date();
        this.validate(name);
        long wsrpConsumerId = this.counterLocalService.increment();
        WSRPConsumer wsrpConsumer = this.wsrpConsumerPersistence.create(wsrpConsumerId);
        wsrpConsumer.setUuid(serviceContext.getUuid());
        wsrpConsumer.setCompanyId(companyId);
        wsrpConsumer.setCreateDate(now);
        wsrpConsumer.setModifiedDate(now);
        wsrpConsumer.setName(name);
        wsrpConsumer.setUrl(url);
        wsrpConsumer.setWsdl(this.getWSDL(wsrpConsumer, forwardCookies, forwardHeaders));
        wsrpConsumer.setMarkupCharacterSets(markupCharacterSets);
        return (WSRPConsumer)this.wsrpConsumerPersistence.update((BaseModel)wsrpConsumer);
    }

    @Override
    public WSRPConsumer deleteWSRPConsumer(long wsrpConsumerId) throws PortalException {
        WSRPConsumer wsrpConsumer = this.wsrpConsumerPersistence.findByPrimaryKey(wsrpConsumerId);
        return this.wsrpConsumerLocalService.deleteWSRPConsumer(wsrpConsumer);
    }

    @Override
    @SystemEvent(action=1, type=1)
    public WSRPConsumer deleteWSRPConsumer(WSRPConsumer wsrpConsumer) throws PortalException {
        this.wsrpConsumerPortletLocalService.deleteWSRPConsumerPortlets(wsrpConsumer.getWsrpConsumerId());
        return (WSRPConsumer)this.wsrpConsumerPersistence.remove((BaseModel)wsrpConsumer);
    }

    public void deleteWSRPConsumers(long companyId) throws PortalException {
        List wsrpConsumers = this.wsrpConsumerPersistence.findByCompanyId(companyId);
        for (WSRPConsumer wsrpConsumer : wsrpConsumers) {
            this.wsrpConsumerLocalService.deleteWSRPConsumer(wsrpConsumer);
        }
    }

    public WSRPConsumer getWSRPConsumer(String wsrpConsumerUuid) throws PortalException {
        List wsrpConsumers = this.wsrpConsumerPersistence.findByUuid(wsrpConsumerUuid);
        if (wsrpConsumers.isEmpty()) {
            throw new NoSuchConsumerException("No WSRP consumer exists with uuid " + wsrpConsumerUuid);
        }
        return (WSRPConsumer)wsrpConsumers.get(0);
    }

    public List<WSRPConsumer> getWSRPConsumers(long companyId, int start, int end) {
        return this.wsrpConsumerPersistence.findByCompanyId(companyId, start, end);
    }

    public int getWSRPConsumersCount(long companyId) {
        return this.wsrpConsumerPersistence.countByCompanyId(companyId);
    }

    public WSRPConsumer registerWSRPConsumer(long wsrpConsumerId, String adminPortletId, UnicodeProperties registrationProperties, String registrationHandle) throws PortalException {
        WSRPConsumer wsrpConsumer = this.wsrpConsumerPersistence.findByPrimaryKey(wsrpConsumerId);
        RegistrationContext registrationContext = null;
        if (registrationProperties != null) {
            try {
                registrationContext = this.register(wsrpConsumer, adminPortletId, registrationProperties);
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (SystemException se) {
                throw se;
            }
            catch (Exception e) {
                throw new WSRPConsumerWSDLException((Throwable)e);
            }
        } else if (Validator.isNotNull((String)registrationHandle)) {
            registrationContext = new RegistrationContext();
            registrationContext.setRegistrationHandle(registrationHandle);
        }
        wsrpConsumer.setModifiedDate(new Date());
        wsrpConsumer.setRegistrationContext(registrationContext);
        wsrpConsumer.setRegistrationProperties(registrationProperties);
        return (WSRPConsumer)this.wsrpConsumerPersistence.update((BaseModel)wsrpConsumer);
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public void restartConsumer(long wsrpConsumerId) throws PortalException {
        WSRPConsumer wsrpConsumer = this.wsrpConsumerPersistence.findByPrimaryKey(wsrpConsumerId);
        try {
            this._wsrpConsumerManagerFactory.destroyWSRPConsumerManager(wsrpConsumer.getUrl());
            WSRPConsumerManager wsrpConsumerManager = this._wsrpConsumerManagerFactory.getWSRPConsumerManager(wsrpConsumer);
            RegistrationContext registrationContext = wsrpConsumer.getRegistrationContext();
            wsrpConsumerManager.updateServiceDescription(registrationContext);
            List wsrpConsumerPortlets = this.wsrpConsumerPortletLocalService.getWSRPConsumerPortlets(wsrpConsumerId, -1, -1);
            for (WSRPConsumerPortlet wsrpConsumerPortlet : wsrpConsumerPortlets) {
                long companyId = wsrpConsumerPortlet.getCompanyId();
                long wsrpConsumerPortletId = wsrpConsumerPortlet.getWsrpConsumerPortletId();
                String wsrpConsumerPortletUuid = wsrpConsumerPortlet.getUuid();
                String name = wsrpConsumerPortlet.getName();
                String portletHandle = wsrpConsumerPortlet.getPortletHandle();
                this.wsrpConsumerPortletLocalService.initWSRPConsumerPortlet(companyId, wsrpConsumerId, wsrpConsumerPortletId, wsrpConsumerPortletUuid, name, portletHandle);
            }
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    public void updateServiceDescription(long wsrpConsumerId) throws PortalException {
        WSRPConsumer wsrpConsumer = this.wsrpConsumerPersistence.findByPrimaryKey(wsrpConsumerId);
        try {
            this._wsrpConsumerManagerFactory.destroyWSRPConsumerManager(wsrpConsumer.getUrl());
            WSRPConsumerManager wsrpConsumerManager = this._wsrpConsumerManagerFactory.getWSRPConsumerManager(wsrpConsumer);
            RegistrationContext registrationContext = wsrpConsumer.getRegistrationContext();
            wsrpConsumerManager.updateServiceDescription(registrationContext);
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    public WSRPConsumer updateWSRPConsumer(long wsrpConsumerId, String adminPortletId, String name, String url, String forwardCookies, String forwardHeaders, String markupCharacterSets) throws PortalException {
        this.validate(name);
        this._wsrpConsumerManagerFactory.destroyWSRPConsumerManager(url);
        WSRPConsumer wsrpConsumer = this.wsrpConsumerPersistence.findByPrimaryKey(wsrpConsumerId);
        wsrpConsumer.setModifiedDate(new Date());
        wsrpConsumer.setName(name);
        wsrpConsumer.setUrl(url);
        wsrpConsumer.setWsdl(this.getWSDL(wsrpConsumer, forwardCookies, forwardHeaders));
        wsrpConsumer.setMarkupCharacterSets(markupCharacterSets);
        return (WSRPConsumer)this.wsrpConsumerPersistence.update((BaseModel)wsrpConsumer);
    }

    protected String getWSDL(WSRPConsumer wsrpConsumer, String forwardCookies, String forwardHeaders) throws PortalException {
        try {
            wsrpConsumer.setForwardCookies(forwardCookies);
            wsrpConsumer.setForwardHeaders(forwardHeaders);
            WSRPConsumerManager wsrpConsumerManager = this._wsrpConsumerManagerFactory.getWSRPConsumerManager(wsrpConsumer);
            return wsrpConsumerManager.getWsdl();
        }
        catch (Exception e) {
            throw new WSRPConsumerWSDLException((Throwable)e);
        }
    }

    protected RegistrationContext register(WSRPConsumer wsrpConsumer, String adminPortletId, UnicodeProperties registrationProperties) throws Exception {
        WSRPConsumerManager wsrpConsumerManager = this._wsrpConsumerManagerFactory.getWSRPConsumerManager(wsrpConsumer);
        WSRP_v2_Registration_PortType registrationService = wsrpConsumerManager.getRegistrationService();
        RegistrationContext registrationContext = wsrpConsumer.getRegistrationContext();
        Property[] properties = new Property[registrationProperties.size()];
        List registrationPropertiesList = ListUtil.fromCollection((Collection)registrationProperties.entrySet());
        for (int i = 0; i < properties.length; ++i) {
            Map.Entry entry = (Map.Entry)registrationPropertiesList.get(i);
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            PropertyDescription propertyDescription = wsrpConsumerManager.getPropertyDescription(name);
            QName qName = propertyDescription.getName();
            Property property = new Property();
            property.setName(qName);
            property.setStringValue(value);
            properties[i] = property;
        }
        Company company = this.companyLocalService.getCompany(wsrpConsumer.getCompanyId());
        RegistrationData registrationData = new RegistrationData();
        registrationData.setConsumerAgent(ReleaseInfo.getServerInfo());
        registrationData.setConsumerName(company.getVirtualHostname());
        registrationData.setMethodGetSupported(true);
        registrationData.setRegistrationProperties(properties);
        if (registrationContext == null) {
            Register register = new Register();
            register.setRegistrationData(registrationData);
            registrationContext = registrationService.register(register);
        } else {
            Lifetime scheduledDestruction;
            ModifyRegistration modifyRegistration = new ModifyRegistration();
            modifyRegistration.setRegistrationContext(registrationContext);
            modifyRegistration.setRegistrationData(registrationData);
            RegistrationState registrationState = registrationService.modifyRegistration(modifyRegistration);
            byte[] registrationStateValue = registrationState.getRegistrationState();
            if (registrationStateValue != null) {
                registrationContext.setRegistrationState(registrationState.getRegistrationState());
            }
            if ((scheduledDestruction = registrationState.getScheduledDestruction()) != null) {
                registrationContext.setScheduledDestruction(scheduledDestruction);
            }
        }
        wsrpConsumerManager.updateServiceDescription(registrationContext);
        return registrationContext;
    }

    protected void validate(String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new WSRPConsumerNameException();
        }
    }
}

