/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.upgrade.v1_2_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpgradeWSRP
extends UpgradeProcess {
    private static final String[][] _RENAME_PORTLET_IDS_ARRAY = new String[][]{{"1_WAR_mysubscriptionsportlet", "com_liferay_mysubscriptions_web_portlet_MySubscriptionsPortlet"}, {"1_WAR_privatemessagingportlet", "com_liferay_social_privatemessaging_web_portlet_PrivateMessagingPortlet"}, {"1_WAR_twitterportlet", "com_liferay_twitter_web_portlet_TwitterPortlet"}, {"16", "com_liferay_currency_converter_web_portlet_CurrencyConverterPortlet"}, {"23", "com_liferay_dictionary_web_portlet_DictionaryPortlet"}, {"26", "com_liferay_translator_web_portlet_TranslatorPortlet"}, {"27", "com_liferay_unit_converter_web_portlet_UnitConverterPortlet"}, {"30", "com_liferay_network_utilities_web_portlet_NetworkUtilitiesPortlet"}, {"47", "com_liferay_hello_world_web_portlet_HelloWorldPortlet"}, {"50", "com_liferay_hello_velocity_web_portlet_HelloVelocityPortlet"}, {"61", "com_liferay_loan_calculator_portlet_LoanCalculatorPortlet"}, {"67", "com_liferay_amazon_rankings_web_portlet_AmazonRankingsPortlet"}, {"70", "com_liferay_password_generator_web_portlet_PasswordGeneratorPortlet"}, {"97", "com_liferay_quick_note_web_portlet_QuickNotePortlet"}};
    private final List<String> _uuids = new ArrayList<String>();

    protected void doUpgrade() throws Exception {
        this.updateWSRPProducers();
        this.updateWSRPConsumerPortlets();
        this.updateWSRPConsumers();
    }

    protected void updateWSRPConsumer(long wsrpConsumerId, String url, String wsdl) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("update WSRP_WSRPConsumer set url = ?, wsdl = ? where wsrpConsumerId = ?");){
            ps.setString(1, url);
            ps.setString(2, wsdl);
            ps.setLong(3, wsrpConsumerId);
            ps.executeUpdate();
        }
    }

    protected void updateWSRPConsumerPortlets() throws Exception {
        for (String[] portletIds : _RENAME_PORTLET_IDS_ARRAY) {
            String oldPortletId = portletIds[0];
            String newPortletId = portletIds[1];
            this.runSQL(StringBundler.concat((String[])new String[]{"update WSRP_WSRPConsumerPortlet set portletHandle = '", newPortletId, "' where portletHandle = '", oldPortletId, "'"}));
        }
    }

    protected void updateWSRPConsumers() throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select wsrpConsumerId, url, wsdl from WSRP_WSRPConsumer");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                long wsrpConsumerId = rs.getLong(1);
                String url = rs.getString(2);
                String wsdl = rs.getString(3);
                String uuid = url.substring(url.lastIndexOf("/") + 1);
                if (!this._uuids.contains(uuid)) continue;
                url = url.replace("/wsrp-portlet/", "/o/wsrp-service/");
                wsdl = wsdl.replace("/wsrp-portlet/", "/o/wsrp-service/");
                this.updateWSRPConsumer(wsrpConsumerId, url, wsdl);
            }
        }
    }

    protected void updateWSRPProducer(Map<String, String> renamePortletIdsMap, long wsrpProducerId, String portletIds) throws Exception {
        Object[] portletIdsArray = StringUtil.split((String)portletIds);
        for (int i = 0; i < portletIdsArray.length; ++i) {
            Object oldPortletId = portletIdsArray[i];
            String newPortletId = renamePortletIdsMap.get(oldPortletId);
            if (newPortletId == null) continue;
            portletIdsArray[i] = newPortletId;
        }
        portletIds = StringUtil.merge((Object[])portletIdsArray);
        this.runSQL(StringBundler.concat((String[])new String[]{"update WSRP_WSRPProducer set portletIds = '", portletIds, "' where wsrpProducerId = '", String.valueOf(wsrpProducerId), "'"}));
    }

    protected void updateWSRPProducers() throws Exception {
        HashMap<String, String> renamePortletIdsMap = new HashMap<String, String>();
        for (String[] renamePortletIds : _RENAME_PORTLET_IDS_ARRAY) {
            renamePortletIdsMap.put(renamePortletIds[0], renamePortletIds[1]);
        }
        try (PreparedStatement ps = this.connection.prepareStatement("select uuid_, wsrpProducerId, portletIds from WSRP_WSRPProducer");
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String uuid = rs.getString(1);
                long wsrpProducerId = rs.getLong(2);
                String portletIds = rs.getString(3);
                this._uuids.add(uuid);
                this.updateWSRPProducer(renamePortletIdsMap, wsrpProducerId, portletIds);
            }
        }
    }
}

