/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.consumer.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.BaseFriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.URLCodec;
import java.util.Map;
import javax.portlet.PortletMode;
import javax.portlet.WindowState;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_wsrp_portlet_WSRPConsumerPortlet"}, service={FriendlyURLMapper.class})
public class ConsumerFriendlyURLMapper
extends BaseFriendlyURLMapper {
    private static final String _MAPPING = "consumer";
    private static final Log _log = LogFactoryUtil.getLog(ConsumerFriendlyURLMapper.class);
    @Reference
    private Portal _portal;

    public String buildPath(LiferayPortletURL liferayPortletURL) {
        StringBuilder sb = new StringBuilder();
        sb.append("/consumer");
        this.addPathElement(sb, liferayPortletURL.getPortletId());
        liferayPortletURL.addParameterIncludedInPath("p_p_id");
        WindowState windowState = liferayPortletURL.getWindowState();
        if (windowState != null) {
            this.addPathElement(sb, windowState.toString());
        } else {
            this.addPathElement(sb, null);
        }
        liferayPortletURL.addParameterIncludedInPath("p_p_state");
        PortletMode portletMode = liferayPortletURL.getPortletMode();
        if (portletMode != null) {
            this.addPathElement(sb, portletMode.toString());
        } else {
            this.addPathElement(sb, null);
        }
        liferayPortletURL.addParameterIncludedInPath("p_p_mode");
        this.addPathElement(sb, liferayPortletURL.getCacheability());
        liferayPortletURL.addParameterIncludedInPath("p_p_cacheability");
        Map parameterMap = liferayPortletURL.getParameterMap();
        String[] navigationalState = (String[])parameterMap.get("wsrp-navigationalState");
        if (navigationalState == null || navigationalState.length <= 0) {
            navigationalState = new String[]{null};
        }
        this.addPathElement(sb, navigationalState[0]);
        liferayPortletURL.addParameterIncludedInPath("wsrp-navigationalState");
        return sb.toString();
    }

    public String getMapping() {
        return _MAPPING;
    }

    public String getPortletId() {
        return null;
    }

    public void populateParams(String friendlyURLPath, Map<String, String[]> parameterMap, Map<String, Object> requestContext) {
        int pos1 = friendlyURLPath.indexOf("/", 1);
        int pos2 = friendlyURLPath.indexOf("/", pos1 + 1);
        int pos3 = friendlyURLPath.indexOf("/", pos2 + 1);
        int pos4 = friendlyURLPath.indexOf("/", pos3 + 1);
        int pos5 = friendlyURLPath.indexOf("/", pos4 + 1);
        String portletId = friendlyURLPath.substring(pos1 + 1, pos2);
        this.addParameter(parameterMap, "p_p_id", portletId);
        this.addParameter(parameterMap, "p_p_state", friendlyURLPath.substring(pos2 + 1, pos3));
        this.addParameter(parameterMap, "p_p_mode", friendlyURLPath.substring(pos3 + 1, pos4));
        this.addParameter(parameterMap, "p_p_cacheability", friendlyURLPath.substring(pos4 + 1, pos5));
        String name = this._portal.getPortletNamespace(portletId) + "wsrp-navigationalState";
        this.addParameter(parameterMap, name, friendlyURLPath.substring(pos5 + 1));
    }

    protected void addParameter(Map<String, String[]> parameterMap, String name, String value) {
        if (value.equals("-")) {
            return;
        }
        try {
            parameterMap.put(name, new String[]{value});
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    protected void addPathElement(StringBuilder sb, String value) {
        sb.append("/");
        sb.append(GetterUtil.get((String)URLCodec.encodeURL((String)value), (String)"-"));
    }
}

