/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.util;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.TransientValue;
import com.liferay.wsrp.internal.util.WSRPConsumerManagerImpl;
import com.liferay.wsrp.model.WSRPConsumer;
import com.liferay.wsrp.util.WSRPConsumerManager;
import com.liferay.wsrp.util.WSRPConsumerManagerFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import oasis.names.tc.wsrp.v2.types.RegistrationContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class WSRPConsumerManagerFactoryImpl
implements WSRPConsumerManagerFactory {
    private final CentralizedThreadLocal<HttpSession> _session = new CentralizedThreadLocal(HttpSession.class + "._session");
    @Reference
    private UserLocalService _userLocalService;
    private final Map<String, WSRPConsumerManager> _wsrpConsumerManagers = new ConcurrentHashMap<String, WSRPConsumerManager>();

    public void destroyWSRPConsumerManager(String url) {
        this._wsrpConsumerManagers.remove(url);
        HttpSession session = this.getSession();
        if (session != null) {
            session.removeAttribute("WSRP_CONSUMER_MANAGERS");
        }
    }

    public HttpSession getSession() {
        return (HttpSession)this._session.get();
    }

    public WSRPConsumerManager getWSRPConsumerManager(WSRPConsumer wsrpConsumer) throws Exception {
        return this._getWSRPConsumerManager(wsrpConsumer.getUrl(), wsrpConsumer.getRegistrationContext(), wsrpConsumer.getForwardCookies(), wsrpConsumer.getForwardHeaders());
    }

    public void setSession(HttpSession session) {
        this._session.set((Object)session);
    }

    public boolean testWSRPConsumerManager(WSRPConsumer wsrpConsumer) {
        try {
            String userToken = this._getUserToken();
            new WSRPConsumerManagerImpl(wsrpConsumer.getUrl(), wsrpConsumer.getRegistrationContext(), wsrpConsumer.getForwardCookies(), wsrpConsumer.getForwardHeaders(), userToken);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String _getUserToken() throws Exception {
        String userToken = null;
        HttpSession session = this.getSession();
        if (session != null) {
            Long userId = (Long)session.getAttribute("USER_ID");
            User user = null;
            if (userId != null) {
                user = this._userLocalService.fetchUser(userId.longValue());
            }
            if (user != null) {
                userToken = user.getLogin();
            }
        }
        return userToken;
    }

    private WSRPConsumerManager _getWSRPConsumerManager(String url, RegistrationContext registrationContext, String forwardCookies, String forwardHeaders) throws Exception {
        WSRPConsumerManager wsrpConsumerManager;
        HttpSession session = this.getSession();
        Map wsrpConsumerManagers = null;
        if (session != null) {
            TransientValue transientValue = (TransientValue)session.getAttribute("WSRP_CONSUMER_MANAGERS");
            if (transientValue == null) {
                transientValue = new TransientValue(new ConcurrentHashMap());
                session.setAttribute("WSRP_CONSUMER_MANAGERS", (Object)transientValue);
            }
            wsrpConsumerManagers = (Map)transientValue.getValue();
        }
        if (wsrpConsumerManagers == null) {
            wsrpConsumerManagers = this._wsrpConsumerManagers;
        }
        if ((wsrpConsumerManager = wsrpConsumerManagers.get(url)) == null) {
            String userToken = this._getUserToken();
            wsrpConsumerManager = new WSRPConsumerManagerImpl(url, registrationContext, forwardCookies, forwardHeaders, userToken);
            wsrpConsumerManagers.put(url, wsrpConsumerManager);
        }
        return wsrpConsumerManager;
    }
}

