/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.upgrade.v1_1_0;

import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.wsrp.model.WSRPConsumerPortlet;
import com.liferay.wsrp.service.WSRPConsumerPortletLocalServiceUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.List;

public class UpgradeUuid
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        List wsrpConsumerPortlets = WSRPConsumerPortletLocalServiceUtil.getWSRPConsumerPortlets((int)-1, (int)-1);
        for (WSRPConsumerPortlet wsrpConsumerPortlet : wsrpConsumerPortlets) {
            StringBuilder sb = new StringBuilder(4);
            sb.append("WSRP_");
            sb.append(wsrpConsumerPortlet.getCompanyId());
            sb.append("_");
            sb.append(wsrpConsumerPortlet.getWsrpConsumerPortletId());
            String oldPortletId = PortalUtil.getJsSafePortletId((String)sb.toString());
            String newPortletId = "WSRP_".concat(wsrpConsumerPortlet.getUuid());
            newPortletId = PortalUtil.getJsSafePortletId((String)PortalUUIDUtil.toJsSafeUuid((String)newPortletId));
            this.updateLayout(oldPortletId, newPortletId);
            this.updateResourceAction(oldPortletId, newPortletId);
            this.updateResourcePermission(oldPortletId, newPortletId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLayout(long plid, String typeSettings) throws Exception {
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement("update Layout set typeSettings = ? where plid = " + plid);
            ps.setString(1, typeSettings);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps);
            throw throwable;
        }
        DataAccess.cleanUp((Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateLayout(String oldPortletId, String newPortletId) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.connection.prepareStatement("select plid, typeSettings from Layout where typeSettings like ?");
            ps.setString(1, "%" + oldPortletId + "%");
            rs = ps.executeQuery();
            while (rs.next()) {
                long plid = rs.getLong("plid");
                String typeSettings = rs.getString("typeSettings");
                typeSettings = StringUtil.replace((String)typeSettings, (String)oldPortletId, (String)newPortletId);
                this.updateLayout(plid, typeSettings);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Statement)ps, (ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResourceAction(String oldPortletId, String newPortletId) throws Exception {
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement("update ResourceAction set name = ? where name = ? ");
            ps.setString(1, newPortletId);
            ps.setString(2, oldPortletId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps);
            throw throwable;
        }
        DataAccess.cleanUp((Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResourcePermission(long resourcePermissionId, String name, String primKey) throws Exception {
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement("update ResourcePermission set name = ?, primKey = ? where resourcePermissionId = ?");
            ps.setString(1, name);
            ps.setString(2, primKey);
            ps.setLong(3, resourcePermissionId);
            ps.executeUpdate();
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(ps);
            throw throwable;
        }
        DataAccess.cleanUp((Statement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateResourcePermission(String oldPortletId, String newPortletId) throws Exception {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.connection.prepareStatement("select resourcePermissionId, primKey from ResourcePermission where name = ?");
            ps.setString(1, oldPortletId);
            rs = ps.executeQuery();
            while (rs.next()) {
                long resourcePermissionId = rs.getLong("resourcePermissionId");
                String primKey = rs.getString("primKey");
                primKey = StringUtil.replace((String)primKey, (String)oldPortletId, (String)newPortletId);
                this.updateResourcePermission(resourcePermissionId, newPortletId, primKey);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Statement)ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Statement)ps, (ResultSet)rs);
    }
}

