/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wsrp.model.WSRPProducer;
import com.liferay.wsrp.service.WSRPProducerLocalService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=wsrp-service)", "osgi.http.whiteboard.servlet.name=com.liferay.wsrp.servlet.WSDLServlet", "osgi.http.whiteboard.servlet.pattern=/wsdl/*"}, service={Servlet.class})
public class WSDLServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(WSDLServlet.class);
    private static final Set<String> _paths = SetUtil.fromArray((Object[])new String[]{"/wsrp-1.0-bindings.wsdl", "/wsrp-1.0-interfaces.wsdl", "/wsrp-1.0-service.wsdl", "/wsrp-1.0-types.xsd", "/wsrp-2.0-bindings.wsdl", "/wsrp-2.0-extra.xsd", "/wsrp-2.0-interfaces.wsdl", "/wsrp-2.0-service.wsdl", "/wsrp-2.0-types.xsd"});
    @Reference
    private Portal _portal;
    @Reference
    private WSRPProducerLocalService _wsrpProducerLocalService;

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String content = this.getContent(request);
            response.setContentType("text/xml");
            ServletResponseUtil.write((HttpServletResponse)response, (String)content);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e.getMessage());
            }
            response.sendError(500, e.getMessage());
        }
    }

    protected String getContent(HttpServletRequest request) throws Exception {
        String path = GetterUtil.getString((String)request.getPathInfo());
        ServletContext servletContext = this.getServletContext();
        if (_paths.contains(path)) {
            String content = StringUtil.read((InputStream)servletContext.getResourceAsStream("/WEB-INF/wsdl" + path));
            return this.replaceLocations(request, content);
        }
        StringBuffer sb = request.getRequestURL();
        String url = sb.toString();
        int pos = url.lastIndexOf("/");
        String wsrpProducerUuid = url.substring(pos + 1);
        WSRPProducer wsrpProducer = null;
        if (Validator.isNumber((String)wsrpProducerUuid)) {
            long wsrpProducerId = GetterUtil.getLong((String)wsrpProducerUuid);
            wsrpProducer = this._wsrpProducerLocalService.getWSRPProducer(wsrpProducerId);
            wsrpProducerUuid = wsrpProducer.getUuid();
        } else {
            wsrpProducer = this._wsrpProducerLocalService.getWSRPProducer(wsrpProducerUuid);
        }
        String version = GetterUtil.getString((String)wsrpProducer.getVersion(), (String)"2.0");
        String content = StringUtil.read((InputStream)servletContext.getResourceAsStream("/META-INF/wsdl/wsrp-" + version + "-service.wsdl"));
        content = this.replaceLocations(request, content);
        return StringUtil.replace((String)content, (String[])new String[]{"http://my.service:8080", "${wsrpProducerUuid}"}, (String[])new String[]{this.getURL(request), wsrpProducerUuid});
    }

    protected String getURL(HttpServletRequest request) {
        String hostname = ParamUtil.getString((HttpServletRequest)request, (String)"hostname", (String)request.getServerName());
        String port = ParamUtil.getString((HttpServletRequest)request, (String)"port", (String)String.valueOf(request.getServerPort()));
        String protocol = ParamUtil.getString((HttpServletRequest)request, (String)"protocol", (String)request.getScheme());
        StringBundler sb = new StringBundler(6);
        sb.append(protocol);
        sb.append("://");
        sb.append(hostname);
        sb.append(":");
        sb.append(port);
        sb.append(this._portal.getPathContext(request));
        return sb.toString();
    }

    protected String replaceLocations(HttpServletRequest request, String content) {
        String url = this.getURL(request) + "/wsdl";
        return StringUtil.replace((String)content, (String[])new String[]{"location=\"wsrp-", "schemaLocation=\"wsrp-"}, (String[])new String[]{"location=\"" + url + "/wsrp-", "schemaLocation=\"" + url + "/wsrp-"});
    }
}

