/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.axis;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.axis.SimpleHTTPSender;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPSender;

public class WSRPHTTPSender
extends HTTPSender {
    private static final Log _log = LogFactoryUtil.getLog(WSRPHTTPSender.class);
    private static final ThreadLocal<String> _currentCookie = new CentralizedThreadLocal(SimpleHTTPSender.class + "._currentCookie", () -> "", false);
    private static final ThreadLocal<HttpServletRequest> _currentRequest = new CentralizedThreadLocal(SimpleHTTPSender.class + "._currentRequest", () -> null, false);
    private final String[] _forwardCookies;
    private final String[] _forwardHeaders;

    public static String getCurrentCookie() {
        return _currentCookie.get();
    }

    public static HttpServletRequest getCurrentRequest() {
        return _currentRequest.get();
    }

    public static void setCurrentRequest(HttpServletRequest request) {
        _currentRequest.set(request);
    }

    public WSRPHTTPSender(String forwardCookies, String forwardHeaders) {
        this._forwardCookies = Validator.isNotNull((String)forwardCookies) ? StringUtil.split((String)StringUtil.toLowerCase((String)forwardCookies)) : new String[0];
        this._forwardHeaders = Validator.isNotNull((String)forwardHeaders) ? StringUtil.split((String)forwardHeaders) : new String[0];
    }

    public void invoke(MessageContext messageContext) throws AxisFault {
        HttpServletRequest request = WSRPHTTPSender.getCurrentRequest();
        if (request == null) {
            super.invoke(messageContext);
            return;
        }
        this.addForwardCookies(messageContext, request);
        this.addForwardHeaders(messageContext, request);
        super.invoke(messageContext);
        this.registerCurrentCookie(messageContext);
    }

    protected void addForwardCookies(MessageContext messageContext, HttpServletRequest request) {
        if (this._forwardCookies.length == 0) {
            return;
        }
        HashMap<String, String> cookiesMap = new HashMap<String, String>();
        String[] cookiesObject = messageContext.getProperty("Cookie");
        String[] cookies = new String[]{};
        if (cookiesObject instanceof String[]) {
            cookies = cookiesObject;
        } else if (cookiesObject instanceof String) {
            cookies = new String[]{(String)cookiesObject};
        }
        for (String cookie : cookies) {
            String name = cookie.substring(0, cookie.indexOf("="));
            cookiesMap.put(StringUtil.toLowerCase((String)name), cookie);
        }
        for (String forwardCookie : this._forwardCookies) {
            String value = CookieKeys.getCookie((HttpServletRequest)request, (String)forwardCookie);
            if (Validator.isNull((String)value)) continue;
            cookiesMap.put(forwardCookie, forwardCookie.concat("=").concat(value));
        }
        Collection cookiesCollection = cookiesMap.values();
        cookiesObject = cookiesCollection.toArray(new String[0]);
        messageContext.setProperty("Cookie", (Object)cookiesObject);
    }

    protected void addForwardHeaders(MessageContext messageContext, HttpServletRequest request) {
        if (this._forwardHeaders.length == 0) {
            return;
        }
        Hashtable<String, String> requestHeaders = (Hashtable<String, String>)messageContext.getProperty("HTTP-Request-Headers");
        if (requestHeaders == null) {
            requestHeaders = new Hashtable<String, String>();
            messageContext.setProperty("HTTP-Request-Headers", requestHeaders);
        }
        for (String headerName : this._forwardHeaders) {
            String header = request.getHeader(headerName);
            if (header == null) continue;
            requestHeaders.put(headerName, header);
        }
    }

    protected void registerCurrentCookie(MessageContext messageContext) {
        String cookie;
        block2: {
            cookie = "";
            try {
                cookie = GetterUtil.getString((String)messageContext.getStrProp("Cookie"));
            }
            catch (Throwable t) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)t, t);
            }
        }
        _currentCookie.set(cookie);
    }
}

