/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.util;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.Base64;
import java.security.Key;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WSRPURLUtil.class})
public class WSRPURLUtil {
    private static final String _ALGORITHM = "HmacSHA1";
    @Reference
    private CompanyLocalService _companyLocalService;

    public String encodeWSRPAuth(long companyId, String wsrpAuth) throws Exception {
        Company company = this._companyLocalService.getCompany(companyId);
        Key key = company.getKeyObj();
        byte[] hmacSHA = this.getHMACSha(key.getEncoded(), wsrpAuth.getBytes("UTF-8"));
        return Base64.encodeToURL((byte[])hmacSHA);
    }

    protected byte[] getHMACSha(byte[] key, byte[] data) throws Exception {
        Mac mac = Mac.getInstance(_ALGORITHM);
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, _ALGORITHM);
        mac.init(secretKeySpec);
        return mac.doFinal(data);
    }
}

