/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.util;

import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.TransientValue;
import com.liferay.wsrp.model.WSRPConsumer;
import com.liferay.wsrp.util.WSRPConsumerManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import oasis.names.tc.wsrp.v2.types.RegistrationContext;

public class WSRPConsumerManagerFactory {
    private static final CentralizedThreadLocal<HttpSession> _session = new CentralizedThreadLocal(HttpSession.class + "._session");
    private static final Map<String, WSRPConsumerManager> _wsrpConsumerManagers = new ConcurrentHashMap<String, WSRPConsumerManager>();

    public static void destroyWSRPConsumerManager(String url) {
        _wsrpConsumerManagers.remove(url);
        HttpSession session = WSRPConsumerManagerFactory.getSession();
        if (session != null) {
            session.removeAttribute("WSRP_CONSUMER_MANAGERS");
        }
    }

    public static HttpSession getSession() {
        return (HttpSession)_session.get();
    }

    public static WSRPConsumerManager getWSRPConsumerManager(WSRPConsumer wsrpConsumer) throws Exception {
        return WSRPConsumerManagerFactory._getWSRPConsumerManager(wsrpConsumer.getUrl(), wsrpConsumer.getRegistrationContext(), wsrpConsumer.getForwardCookies(), wsrpConsumer.getForwardHeaders());
    }

    public static void setSession(HttpSession session) {
        _session.set((Object)session);
    }

    public static boolean testWSRPConsumerManager(WSRPConsumer wsrpConsumer) {
        try {
            String userToken = WSRPConsumerManagerFactory._getUserToken();
            new WSRPConsumerManager(wsrpConsumer.getUrl(), wsrpConsumer.getRegistrationContext(), wsrpConsumer.getForwardCookies(), wsrpConsumer.getForwardHeaders(), userToken);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String _getUserToken() throws Exception {
        String userToken = null;
        HttpSession session = WSRPConsumerManagerFactory.getSession();
        if (session != null) {
            Long userId = (Long)session.getAttribute("USER_ID");
            User user = null;
            if (userId != null) {
                user = UserLocalServiceUtil.fetchUser((long)userId);
            }
            if (user != null) {
                userToken = user.getLogin();
            }
        }
        return userToken;
    }

    private static WSRPConsumerManager _getWSRPConsumerManager(String url, RegistrationContext registrationContext, String forwardCookies, String forwardHeaders) throws Exception {
        WSRPConsumerManager wsrpConsumerManager;
        HttpSession session = WSRPConsumerManagerFactory.getSession();
        Map wsrpConsumerManagers = null;
        if (session != null) {
            TransientValue transientValue = (TransientValue)session.getAttribute("WSRP_CONSUMER_MANAGERS");
            if (transientValue == null) {
                transientValue = new TransientValue(new ConcurrentHashMap());
                session.setAttribute("WSRP_CONSUMER_MANAGERS", (Object)transientValue);
            }
            wsrpConsumerManagers = (Map)transientValue.getValue();
        }
        if (wsrpConsumerManagers == null) {
            wsrpConsumerManagers = _wsrpConsumerManagers;
        }
        if ((wsrpConsumerManager = wsrpConsumerManagers.get(url)) == null) {
            String userToken = WSRPConsumerManagerFactory._getUserToken();
            wsrpConsumerManager = new WSRPConsumerManager(url, registrationContext, forwardCookies, forwardHeaders, userToken);
            wsrpConsumerManagers.put(url, wsrpConsumerManager);
        }
        return wsrpConsumerManager;
    }
}

