/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.servlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.TransientValue;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wsrp.internal.servlet.ServiceHolder;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import oasis.names.tc.wsrp.v2.intf.WSRP_v2_Markup_PortType;
import oasis.names.tc.wsrp.v2.types.ReleaseSessions;
import oasis.names.tc.wsrp.v2.types.SessionContext;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={HttpSessionListener.class})
public class WSRPSessionListener
implements HttpSessionListener {
    private static final Log _log = LogFactoryUtil.getLog(WSRPSessionListener.class);

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession session = httpSessionEvent.getSession();
        Enumeration enu = session.getAttributeNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            Object value = session.getAttribute(name);
            if (!(value instanceof TransientValue)) continue;
            TransientValue transientValue = (TransientValue)value;
            this.releaseSessions(transientValue.getValue());
        }
    }

    protected void releaseSessions(Object value) {
        block4: {
            if (value == null || !(value instanceof ServiceHolder)) {
                return;
            }
            ServiceHolder serviceHolder = (ServiceHolder)value;
            SessionContext sessionContext = serviceHolder.getSessionContext();
            if (sessionContext == null || Validator.isNull((String)sessionContext.getSessionID())) {
                return;
            }
            WSRP_v2_Markup_PortType markupService = serviceHolder.getMarkupService();
            ReleaseSessions releaseSessions = new ReleaseSessions();
            releaseSessions.setRegistrationContext(serviceHolder.getRegistrationContext());
            String[] sessionIDs = new String[]{sessionContext.getSessionID()};
            releaseSessions.setSessionIDs(sessionIDs);
            try {
                markupService.releaseSessions(releaseSessions);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)e.getMessage());
            }
        }
    }
}

