/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.proxy;

import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wsrp.configuration.WSRPGroupServiceConfiguration;
import com.liferay.wsrp.constants.WSRPPortletKeys;
import com.liferay.wsrp.internal.axis.WSRPHTTPSender;
import com.liferay.wsrp.internal.client.PasswordCallback;
import com.liferay.wsrp.internal.proxy.Stub;
import com.liferay.wsrp.internal.proxy.WSRP_v2_Markup_Binding_SOAPStub;
import com.liferay.wsrp.util.WSRPConfigurationUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.rpc.Service;
import oasis.names.tc.wsrp.v1.wsdl.WSRPServiceLocator;
import oasis.names.tc.wsrp.v2.wsdl.WSRP_v2_ServiceLocator;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.handlers.LogHandler;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.ws.axis.security.WSDoAllSender;

public class ServiceHandler
implements InvocationHandler {
    private static final String _OASIS_PACKAGE = "oasis.names.tc.wsrp.";
    private static final String _WSRP_PROXY_PACKAGE = "com.liferay.wsrp.proxy.";
    private final EngineConfiguration _engineConfiguration;
    private final org.apache.axis.client.Service _serviceLocator;
    private final boolean _v2;
    private final String _version;
    private final WSRPGroupServiceConfiguration _wsrpGroupServiceConfiguration = WSRPConfigurationUtil.getWSRPConfiguration();

    public ServiceHandler(String forwardCookies, String forwardHeaders, String userToken, boolean v2) {
        this._engineConfiguration = this.getEngineConfiguration(forwardCookies, forwardHeaders, userToken);
        this._v2 = v2;
        if (this._v2) {
            this._serviceLocator = new WSRP_v2_ServiceLocator(this._engineConfiguration);
            this._version = "v2";
        } else {
            this._serviceLocator = new WSRPServiceLocator(this._engineConfiguration);
            this._version = "v1";
        }
        this._serviceLocator.setMaintainSession(true);
    }

    public Object doInvoke(Object proxy, Method method, Object[] args) throws Exception {
        String methodName = method.getName();
        if (this._v2 && methodName.equals("getWSRP_v2_Markup_Service")) {
            WSRP_v2_Markup_Binding_SOAPStub markupService = new WSRP_v2_Markup_Binding_SOAPStub((URL)args[0], (Service)this._serviceLocator);
            WSRP_v2_ServiceLocator wsrpV2ServiceLocator = (WSRP_v2_ServiceLocator)this._serviceLocator;
            String markupServiceName = wsrpV2ServiceLocator.getWSRP_v2_Markup_ServiceWSDDServiceName();
            markupService.setPortName(markupServiceName);
            return markupService;
        }
        ClassLoader contextClassLoader = WSRPPortletKeys.class.getClassLoader();
        URL bindingURL = (URL)args[0];
        int x = methodName.indexOf("_v2_") + 4;
        int y = methodName.lastIndexOf("_Service");
        String serviceName = methodName.substring(x, y);
        StringBundler sb = new StringBundler(7);
        sb.append(_OASIS_PACKAGE);
        sb.append(this._version);
        sb.append(".bind.WSRP_");
        sb.append(this._version);
        sb.append("_");
        sb.append(serviceName);
        sb.append("_Binding_SOAPStub");
        Class<?> clazz = contextClassLoader.loadClass(sb.toString());
        args = new Object[]{bindingURL, this.getService()};
        Object stub = ConstructorUtils.invokeConstructor(clazz, (Object[])args);
        sb = new StringBundler(5);
        sb.append("getWSRP_");
        sb.append(this._version);
        sb.append("_");
        sb.append(serviceName);
        sb.append("_ServiceWSDDServiceName");
        Object serviceWSDDServiceName = MethodUtils.invokeMethod((Object)this._serviceLocator, (String)sb.toString(), null);
        MethodUtils.invokeMethod((Object)stub, (String)"setPortName", (Object)serviceWSDDServiceName);
        if (this._v2) {
            return stub;
        }
        sb.setIndex(0);
        sb.append(_OASIS_PACKAGE);
        sb.append("v2.intf.WSRP_v2_");
        sb.append(serviceName);
        sb.append("_PortType");
        Class<?> proxyInterface = contextClassLoader.loadClass(sb.toString());
        sb.setIndex(0);
        sb.append(_WSRP_PROXY_PACKAGE);
        sb.append(serviceName);
        sb.append("ServiceHandler");
        clazz = contextClassLoader.loadClass(sb.toString());
        InvocationHandler invocationHandler = (InvocationHandler)ConstructorUtils.invokeConstructor(clazz, (Object)stub);
        return ProxyUtil.newProxyInstance((ClassLoader)ServiceHandler.class.getClassLoader(), (Class[])new Class[]{proxyInterface, Stub.class}, (InvocationHandler)invocationHandler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return this.doInvoke(proxy, method, args);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected EngineConfiguration getEngineConfiguration(String forwardCookies, String forwardHeaders, String userToken) {
        SimpleChain requestSimpleChain = new SimpleChain();
        LogHandler logHandler = new LogHandler();
        if (this._wsrpGroupServiceConfiguration.soapDebug()) {
            requestSimpleChain.addHandler((Handler)logHandler);
        }
        if (Validator.isNotNull((String)userToken)) {
            WSDoAllSender wsDoAllSenderHandler = new WSDoAllSender();
            wsDoAllSenderHandler.setOption("action", (Object)"UsernameToken");
            wsDoAllSenderHandler.setOption("mustUnderstand", (Object)"false");
            wsDoAllSenderHandler.setOption("passwordType", (Object)"PasswordNone");
            wsDoAllSenderHandler.setOption("passwordCallbackClass", (Object)PasswordCallback.class.getName());
            wsDoAllSenderHandler.setOption("user", (Object)userToken);
            requestSimpleChain.addHandler((Handler)wsDoAllSenderHandler);
        }
        SimpleChain responseSimpleChain = new SimpleChain();
        if (this._wsrpGroupServiceConfiguration.soapDebug()) {
            responseSimpleChain.addHandler((Handler)logHandler);
        }
        SimpleProvider simpleProvider = new SimpleProvider();
        WSRPHTTPSender httpSender = new WSRPHTTPSender(forwardCookies, forwardHeaders);
        simpleProvider.deployTransport("http", (Handler)new SimpleTargetedChain((Handler)requestSimpleChain, (Handler)httpSender, (Handler)responseSimpleChain));
        return simpleProvider;
    }

    protected org.apache.axis.client.Service getService() {
        org.apache.axis.client.Service service = new org.apache.axis.client.Service(this._engineConfiguration);
        service.setMaintainSession(true);
        return service;
    }
}

