/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.consumer.portlet;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Address;
import com.liferay.portal.kernel.model.EmailAddress;
import com.liferay.portal.kernel.model.ListType;
import com.liferay.portal.kernel.model.Phone;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.Website;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletResponseUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCPortlet;
import com.liferay.portal.kernel.security.auth.AuthTokenUtil;
import com.liferay.portal.kernel.service.AddressLocalService;
import com.liferay.portal.kernel.service.EmailAddressLocalService;
import com.liferay.portal.kernel.service.ListTypeService;
import com.liferay.portal.kernel.service.PhoneLocalService;
import com.liferay.portal.kernel.service.WebsiteLocalService;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TransientValue;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.spring.extender.service.ServiceReference;
import com.liferay.wsrp.configuration.WSRPGroupServiceConfiguration;
import com.liferay.wsrp.internal.axis.WSRPHTTPSender;
import com.liferay.wsrp.internal.proxy.Stub;
import com.liferay.wsrp.internal.servlet.ServiceHolder;
import com.liferay.wsrp.model.WSRPConsumer;
import com.liferay.wsrp.model.WSRPConsumerPortlet;
import com.liferay.wsrp.service.WSRPConsumerLocalService;
import com.liferay.wsrp.service.WSRPConsumerPortletLocalService;
import com.liferay.wsrp.util.ConsumerRequestExtensionsHelper;
import com.liferay.wsrp.util.ExtensionHelperUtil;
import com.liferay.wsrp.util.MarkupCharacterSetsUtil;
import com.liferay.wsrp.util.WSRPConfigurationUtil;
import com.liferay.wsrp.util.WSRPConsumerManager;
import com.liferay.wsrp.util.WSRPConsumerManagerFactory;
import com.liferay.wsrp.util.WSRPURLUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import oasis.names.tc.wsrp.v2.intf.WSRP_v2_Markup_PortType;
import oasis.names.tc.wsrp.v2.types.BlockingInteractionResponse;
import oasis.names.tc.wsrp.v2.types.CacheControl;
import oasis.names.tc.wsrp.v2.types.ClientData;
import oasis.names.tc.wsrp.v2.types.Contact;
import oasis.names.tc.wsrp.v2.types.CookieProtocol;
import oasis.names.tc.wsrp.v2.types.EventParams;
import oasis.names.tc.wsrp.v2.types.GetMarkup;
import oasis.names.tc.wsrp.v2.types.GetResource;
import oasis.names.tc.wsrp.v2.types.HandleEvents;
import oasis.names.tc.wsrp.v2.types.HandleEventsResponse;
import oasis.names.tc.wsrp.v2.types.InitCookie;
import oasis.names.tc.wsrp.v2.types.InteractionParams;
import oasis.names.tc.wsrp.v2.types.InvalidCookieFault;
import oasis.names.tc.wsrp.v2.types.MarkupContext;
import oasis.names.tc.wsrp.v2.types.MarkupParams;
import oasis.names.tc.wsrp.v2.types.MarkupResponse;
import oasis.names.tc.wsrp.v2.types.MimeRequest;
import oasis.names.tc.wsrp.v2.types.MimeResponse;
import oasis.names.tc.wsrp.v2.types.NamedString;
import oasis.names.tc.wsrp.v2.types.NavigationalContext;
import oasis.names.tc.wsrp.v2.types.Online;
import oasis.names.tc.wsrp.v2.types.PerformBlockingInteraction;
import oasis.names.tc.wsrp.v2.types.PersonName;
import oasis.names.tc.wsrp.v2.types.PortletContext;
import oasis.names.tc.wsrp.v2.types.PortletDescription;
import oasis.names.tc.wsrp.v2.types.Postal;
import oasis.names.tc.wsrp.v2.types.RegistrationContext;
import oasis.names.tc.wsrp.v2.types.ResourceContext;
import oasis.names.tc.wsrp.v2.types.ResourceParams;
import oasis.names.tc.wsrp.v2.types.RuntimeContext;
import oasis.names.tc.wsrp.v2.types.ServiceDescription;
import oasis.names.tc.wsrp.v2.types.SessionContext;
import oasis.names.tc.wsrp.v2.types.SessionParams;
import oasis.names.tc.wsrp.v2.types.StateChange;
import oasis.names.tc.wsrp.v2.types.Telecom;
import oasis.names.tc.wsrp.v2.types.TelephoneNum;
import oasis.names.tc.wsrp.v2.types.Templates;
import oasis.names.tc.wsrp.v2.types.UpdateResponse;
import oasis.names.tc.wsrp.v2.types.UploadContext;
import oasis.names.tc.wsrp.v2.types.UserContext;
import oasis.names.tc.wsrp.v2.types.UserProfile;
import org.apache.axis.message.MessageElement;

@OSGiBeanProperties(property={"com.liferay.portlet.add-default-resource=true", "com.liferay.portlet.display-category=category.hidden", "com.liferay.portlet.private-request-attributes=false", "com.liferay.portlet.private-session-attributes=false", "com.liferay.portlet.render-weight=50", "com.liferay.portlet.requires-namespaced-parameters=false", "com.liferay.portlet.use-default-template=true", "javax.portlet.display-name=WSRP Consumer", "javax.portlet.expiration-cache=0", "javax.portlet.name=com_liferay_wsrp_portlet_WSRPConsumerPortlet", "javax.portlet.portlet-info.keywords=WSRP Consumer", "javax.portlet.portlet-info.short-title=WSRP Consumer", "javax.portlet.portlet-info.title=WSRP Consumer", "javax.portlet.resource-bundle=content.Language", "javax.portlet.security-role-ref=administrator,guest,power-user,user", "javax.portlet.supports.mime-type=text/html"}, service={Portlet.class})
public class ConsumerPortlet
extends MVCPortlet {
    public static final String PORTLET_NAME_PREFIX = "WSRP_";
    private static final String _BLOCKING_ACTION_TEMPLATE;
    private static final String[] _CHAR_SETS;
    private static final String[] _MIME_TYPES;
    private static final String _RENDER_TEMPLATE;
    private static final String _RESOURCE_TEMPLATE;
    private static final Log _log;
    private static final Pattern _navigationalValuesPattern;
    private static final Pattern _parameterPattern;
    private static final Pattern _rewritePattern;
    @ServiceReference(type=AddressLocalService.class)
    private AddressLocalService _addressLocalService;
    @ServiceReference(type=EmailAddressLocalService.class)
    private EmailAddressLocalService _emailAddressLocalService;
    @ServiceReference(type=ListTypeService.class)
    private ListTypeService _listTypeService;
    @ServiceReference(type=PhoneLocalService.class)
    private PhoneLocalService _phoneLocalService;
    @ServiceReference(type=Portal.class)
    private Portal _portal;
    @ServiceReference(type=WebsiteLocalService.class)
    private WebsiteLocalService _websiteLocalService;
    private WSRPConsumerLocalService _wsrpConsumerLocalService;
    private WSRPConsumerPortletLocalService _wsrpConsumerPortletLocalService;
    @ServiceReference(type=WSRPURLUtil.class)
    private WSRPURLUtil _wsrpURLUtil;

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        try {
            this.doProcessAction(actionRequest, actionResponse);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (PortletException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        try {
            this.doProcessEvent(eventRequest, eventResponse);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (PortletException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        try {
            this.doRender(renderRequest, renderResponse);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (PortletException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        try {
            this.doServeResource(resourceRequest, resourceResponse);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (PortletException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void setWsrpConsumerLocalService(WSRPConsumerLocalService wsrpConsumerLocalService) {
        this._wsrpConsumerLocalService = wsrpConsumerLocalService;
    }

    public void setWsrpConsumerPortletLocalService(WSRPConsumerPortletLocalService wsrpConsumerPortletLocalService) {
        this._wsrpConsumerPortletLocalService = wsrpConsumerPortletLocalService;
    }

    protected void addFormField(List<NamedString> formParameters, String name, String[] values) {
        for (String value : values) {
            NamedString formParameter = new NamedString();
            formParameter.setName(name);
            formParameter.setValue(value);
            formParameters.add(formParameter);
        }
    }

    protected boolean authorize(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        WSRPGroupServiceConfiguration wsrpGroupServiceConfiguration = WSRPConfigurationUtil.getWSRPConfiguration();
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)resourceRequest);
        HttpServletResponse response = PortalUtil.getHttpServletResponse((PortletResponse)resourceResponse);
        String resourceID = GetterUtil.getString((String)resourceRequest.getResourceID());
        String url = GetterUtil.getString((String)resourceRequest.getParameter("wsrp-url"));
        String wsrpAuth = GetterUtil.getString((String)resourceRequest.getParameter("wsrp-auth"));
        StringBundler sb = new StringBundler(3);
        sb.append(resourceID);
        sb.append(url);
        sb.append(wsrpGroupServiceConfiguration.soapDebug());
        ThemeDisplay themeDisplay = (ThemeDisplay)resourceRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String expectedWSRPAuth = this._wsrpURLUtil.encodeWSRPAuth(themeDisplay.getCompanyId(), sb.toString());
        if (wsrpAuth.equals(expectedWSRPAuth)) {
            return true;
        }
        sb.append(AuthTokenUtil.getToken((HttpServletRequest)request));
        expectedWSRPAuth = this._wsrpURLUtil.encodeWSRPAuth(themeDisplay.getCompanyId(), sb.toString());
        if (wsrpAuth.equals(expectedWSRPAuth)) {
            return true;
        }
        response.setStatus(401);
        return false;
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        WSRPConsumerPortlet wsrpConsumerPortlet = this.getWSRPConsumerPortlet();
        WSRPConsumer wsrpConsumer = this._wsrpConsumerLocalService.getWSRPConsumer(wsrpConsumerPortlet.getWsrpConsumerId());
        WSRPConsumerManager wsrpConsumerManager = WSRPConsumerManagerFactory.getWSRPConsumerManager(wsrpConsumer);
        InteractionParams interactionParams = new InteractionParams();
        MarkupParams markupParams = new MarkupParams();
        PortletContext portletContext = new PortletContext();
        RuntimeContext runtimeContext = new RuntimeContext();
        UserContext userContext = new UserContext();
        this.initContexts(actionRequest, actionResponse, wsrpConsumer, wsrpConsumerPortlet, wsrpConsumerManager, interactionParams, markupParams, portletContext, runtimeContext, userContext);
        PerformBlockingInteraction performBlockingInteraction = new PerformBlockingInteraction();
        performBlockingInteraction.setInteractionParams(interactionParams);
        performBlockingInteraction.setMarkupParams(markupParams);
        performBlockingInteraction.setPortletContext(portletContext);
        performBlockingInteraction.setRegistrationContext(wsrpConsumer.getRegistrationContext());
        performBlockingInteraction.setRuntimeContext(runtimeContext);
        performBlockingInteraction.setUserContext(userContext);
        ServiceHolder serviceHolder = this.getServiceHolder((PortletRequest)actionRequest, wsrpConsumerManager, wsrpConsumer);
        WSRP_v2_Markup_PortType markupService = serviceHolder.getMarkupService();
        BlockingInteractionResponse blockingInteractionResponse = markupService.performBlockingInteraction(performBlockingInteraction);
        this.processBlockingInteractionResponse(actionRequest, actionResponse, wsrpConsumerManager, serviceHolder, blockingInteractionResponse);
    }

    protected void doProcessEvent(EventRequest eventRequest, EventResponse eventResponse) throws Exception {
        WSRPConsumerPortlet wsrpConsumerPortlet = this.getWSRPConsumerPortlet();
        WSRPConsumer wsrpConsumer = this._wsrpConsumerLocalService.getWSRPConsumer(wsrpConsumerPortlet.getWsrpConsumerId());
        WSRPConsumerManager wsrpConsumerManager = WSRPConsumerManagerFactory.getWSRPConsumerManager(wsrpConsumer);
        EventParams eventParams = new EventParams();
        MarkupParams markupParams = new MarkupParams();
        PortletContext portletContext = new PortletContext();
        RuntimeContext runtimeContext = new RuntimeContext();
        UserContext userContext = new UserContext();
        this.initContexts(eventRequest, eventResponse, wsrpConsumer, wsrpConsumerPortlet, wsrpConsumerManager, eventParams, markupParams, portletContext, runtimeContext, userContext);
        HandleEvents handleEvents = new HandleEvents();
        handleEvents.setEventParams(eventParams);
        handleEvents.setMarkupParams(markupParams);
        handleEvents.setPortletContext(portletContext);
        handleEvents.setRegistrationContext(wsrpConsumer.getRegistrationContext());
        handleEvents.setRuntimeContext(runtimeContext);
        handleEvents.setUserContext(userContext);
        ServiceHolder serviceHolder = this.getServiceHolder((PortletRequest)eventRequest, wsrpConsumerManager, wsrpConsumer);
        WSRP_v2_Markup_PortType markupService = serviceHolder.getMarkupService();
        HandleEventsResponse handleEventsResponse = markupService.handleEvents(handleEvents);
        this.processHandleEventsResponse(eventRequest, eventResponse, wsrpConsumerManager, serviceHolder, handleEventsResponse);
    }

    protected void doRender(RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        PortletSession portletSession = renderRequest.getPortletSession();
        MarkupContext markupContext = (MarkupContext)portletSession.getAttribute("MARKUP_CONTEXT");
        if (markupContext != null) {
            portletSession.removeAttribute("MARKUP_CONTEXT");
        } else {
            MarkupResponse markupResponse = this.getMarkupResponse((PortletRequest)renderRequest, (PortletResponse)renderResponse);
            markupContext = markupResponse.getMarkupContext();
        }
        this.processMimeResponse((PortletRequest)renderRequest, (javax.portlet.MimeResponse)renderResponse, (MimeResponse)markupContext);
    }

    protected void doServeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        WSRPGroupServiceConfiguration wsrpGroupServiceConfiguration = WSRPConfigurationUtil.getWSRPConfiguration();
        if (wsrpGroupServiceConfiguration.secureResourceUrlsEnabled() && !this.authorize(resourceRequest, resourceResponse)) {
            return;
        }
        String resourceID = resourceRequest.getResourceID();
        String url = ParamUtil.getString((PortletRequest)resourceRequest, (String)"wsrp-url");
        boolean preferOperation = ParamUtil.getBoolean((PortletRequest)resourceRequest, (String)"wsrp-preferOperation");
        if (Validator.isNotNull((String)resourceID) && Validator.isNotNull((String)url) && preferOperation) {
            this.getResource(resourceRequest, resourceResponse);
        } else if (Validator.isNotNull((String)url)) {
            this.proxyURL(resourceRequest, resourceResponse, url);
        } else if (Validator.isNotNull((String)resourceID)) {
            this.getResource(resourceRequest, resourceResponse);
        }
    }

    protected Calendar getBdate(User user) throws Exception {
        Calendar birthday = Calendar.getInstance();
        birthday.setTime(user.getBirthday());
        return birthday;
    }

    protected String getCharSet(String contentType) {
        int x;
        if (Validator.isNotNull((String)contentType) && (x = contentType.lastIndexOf("charset=")) >= 0) {
            return contentType.substring(x + 8).trim();
        }
        return "UTF-8";
    }

    protected Contact getContact(User user, String listTypeName) throws Exception {
        Contact contact = new Contact();
        Postal postal = this.getPostal(user, listTypeName);
        if (postal != null) {
            contact.setPostal(postal);
        }
        Online online = this.getOnline(user, listTypeName);
        contact.setOnline(online);
        Telecom telecom = this.getTelecom(user, listTypeName);
        contact.setTelecom(telecom);
        return contact;
    }

    protected String getGender(User user) throws Exception {
        if (user.isMale()) {
            return "M";
        }
        return "F";
    }

    protected MarkupResponse getMarkupResponse(PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        PortletSession portletSession = portletRequest.getPortletSession();
        WSRPConsumerPortlet wsrpConsumerPortlet = this.getWSRPConsumerPortlet();
        WSRPConsumer wsrpConsumer = this._wsrpConsumerLocalService.getWSRPConsumer(wsrpConsumerPortlet.getWsrpConsumerId());
        WSRPConsumerManager wsrpConsumerManager = WSRPConsumerManagerFactory.getWSRPConsumerManager(wsrpConsumer);
        MarkupParams markupParams = new MarkupParams();
        PortletContext portletContext = new PortletContext();
        RuntimeContext runtimeContext = new RuntimeContext();
        UserContext userContext = new UserContext();
        this.initContexts(portletRequest, portletResponse, wsrpConsumer, wsrpConsumerPortlet, wsrpConsumerManager, (MimeRequest)markupParams, portletContext, runtimeContext, userContext);
        GetMarkup getMarkup = new GetMarkup();
        getMarkup.setMarkupParams(markupParams);
        PortletContext existingPortletContext = (PortletContext)portletSession.getAttribute("PORTLET_CONTEXT");
        if (existingPortletContext != null) {
            getMarkup.setPortletContext(existingPortletContext);
        } else {
            getMarkup.setPortletContext(portletContext);
        }
        getMarkup.setRegistrationContext(wsrpConsumer.getRegistrationContext());
        getMarkup.setRuntimeContext(runtimeContext);
        getMarkup.setUserContext(userContext);
        ServiceHolder serviceHolder = this.getServiceHolder(portletRequest, wsrpConsumerManager, wsrpConsumer);
        WSRP_v2_Markup_PortType markupService = serviceHolder.getMarkupService();
        MarkupResponse markupResponse = null;
        try {
            markupResponse = markupService.getMarkup(getMarkup);
        }
        catch (InvalidCookieFault icf) {
            InitCookie initCookie = new InitCookie();
            markupService.initCookie(initCookie);
            markupResponse = markupService.getMarkup(getMarkup);
        }
        Stub stub = (Stub)markupService;
        stub._createCall();
        this.processMarkupResponse(portletRequest, portletResponse, serviceHolder, markupResponse);
        return markupResponse;
    }

    protected Online getOnline(User user, String listTypeName) throws Exception {
        String uri;
        Online online = new Online();
        String email = this.getOnlineEmail(user, "email");
        if (email != null) {
            online.setEmail(email);
        }
        if ((uri = this.getOnlineUri(user, listTypeName)) != null) {
            online.setUri(uri);
        }
        return online;
    }

    protected String getOnlineEmail(User user, String listTypeName) throws Exception {
        List emailAddresses = this._emailAddressLocalService.getEmailAddresses(user.getCompanyId(), com.liferay.portal.kernel.model.Contact.class.getName(), user.getContactId());
        for (EmailAddress emailAddress : emailAddresses) {
            ListType listType = emailAddress.getType();
            if (!listTypeName.equals(listType.getName())) continue;
            return emailAddress.getAddress();
        }
        return user.getEmailAddress();
    }

    protected String getOnlineUri(User user, String listTypeName) throws Exception {
        List websites = this._websiteLocalService.getWebsites(user.getCompanyId(), com.liferay.portal.kernel.model.Contact.class.getName(), user.getContactId());
        for (Website website : websites) {
            ListType listType = website.getType();
            if (!listTypeName.equals(listType.getName())) continue;
            return website.getUrl();
        }
        return null;
    }

    protected PersonName getPersonName(User user) throws Exception {
        PersonName personName;
        block5: {
            ListType listType;
            com.liferay.portal.kernel.model.Contact contact;
            block4: {
                personName = new PersonName();
                personName.setFamily(user.getLastName());
                personName.setGiven(user.getFirstName());
                personName.setMiddle(user.getMiddleName());
                personName.setNickname(user.getScreenName());
                contact = user.getContact();
                try {
                    listType = this._listTypeService.getListType(contact.getPrefixId());
                    personName.setPrefix(listType.getName());
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)"Unable to retrieve name prefix", (Throwable)e);
                }
            }
            try {
                listType = this._listTypeService.getListType(contact.getSuffixId());
                personName.setSuffix(listType.getName());
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)"Unable to retrieve name suffix", (Throwable)e);
            }
        }
        return personName;
    }

    protected PortletMode getPortletMode(String portletMode) {
        return new PortletMode(portletMode.substring(5));
    }

    protected Postal getPostal(User user, String listTypeName) throws Exception {
        List addresses = this._addressLocalService.getAddresses(user.getCompanyId(), com.liferay.portal.kernel.model.Contact.class.getName(), user.getContactId());
        for (Address address : addresses) {
            ListType listType = address.getType();
            if (!listTypeName.equals(listType.getName())) continue;
            Postal postal = new Postal();
            postal.setCity(address.getCity());
            postal.setCountry(address.getCountry().getName());
            postal.setName(address.getUserName());
            postal.setPostalcode(address.getZip());
            postal.setStateprov(address.getRegion().getName());
            String street = address.getStreet1() + address.getStreet2() + address.getStreet3();
            postal.setStreet(street);
            return postal;
        }
        return null;
    }

    protected void getResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws Exception {
        PortletSession portletSession = resourceRequest.getPortletSession();
        WSRPConsumerPortlet wsrpConsumerPortlet = this.getWSRPConsumerPortlet();
        WSRPConsumer wsrpConsumer = this._wsrpConsumerLocalService.getWSRPConsumer(wsrpConsumerPortlet.getWsrpConsumerId());
        WSRPConsumerManager wsrpConsumerManager = WSRPConsumerManagerFactory.getWSRPConsumerManager(wsrpConsumer);
        PortletContext portletContext = new PortletContext();
        ResourceParams resourceParams = new ResourceParams();
        RuntimeContext runtimeContext = new RuntimeContext();
        UserContext userContext = new UserContext();
        this.initContexts(resourceRequest, resourceResponse, wsrpConsumer, wsrpConsumerPortlet, wsrpConsumerManager, portletContext, resourceParams, runtimeContext, userContext);
        GetResource getResource = new GetResource();
        PortletContext existingPortletContext = (PortletContext)portletSession.getAttribute("PORTLET_CONTEXT");
        if (existingPortletContext != null) {
            getResource.setPortletContext(existingPortletContext);
        } else {
            getResource.setPortletContext(portletContext);
        }
        getResource.setRegistrationContext(wsrpConsumer.getRegistrationContext());
        getResource.setResourceParams(resourceParams);
        getResource.setRuntimeContext(runtimeContext);
        getResource.setUserContext(userContext);
        ServiceHolder serviceHolder = this.getServiceHolder((PortletRequest)resourceRequest, wsrpConsumerManager, wsrpConsumer);
        WSRP_v2_Markup_PortType markupService = serviceHolder.getMarkupService();
        oasis.names.tc.wsrp.v2.types.ResourceResponse wsrpResourceResponse = markupService.getResource(getResource);
        this.processResourceResponse(resourceRequest, resourceResponse, wsrpConsumerManager, serviceHolder, wsrpResourceResponse);
    }

    protected ServiceHolder getServiceHolder(PortletRequest portletRequest, WSRPConsumerManager wsrpConsumerManager, WSRPConsumer wsrpConsumer) throws Exception {
        String markupServiceKey;
        PortletSession portletSession = portletRequest.getPortletSession();
        TransientValue serviceHolderTransientValue = (TransientValue)portletSession.getAttribute(markupServiceKey = this.getSessionKey("MARKUP_SERVICE", portletRequest, wsrpConsumer), 1);
        if (serviceHolderTransientValue == null || serviceHolderTransientValue.isNull()) {
            String cookieProtocolValue;
            ServiceHolder serviceHolder = new ServiceHolder();
            WSRP_v2_Markup_PortType markupService = wsrpConsumerManager.getMarkupService();
            serviceHolder.setMarkupService(markupService);
            RegistrationContext registrationContext = wsrpConsumer.getRegistrationContext();
            serviceHolder.setRegistrationContext(registrationContext);
            serviceHolderTransientValue = new TransientValue((Object)serviceHolder);
            portletSession.setAttribute(markupServiceKey, (Object)serviceHolderTransientValue, 1);
            ServiceDescription serviceDescription = wsrpConsumerManager.getServiceDescription();
            String cookieKey = this.getSessionKey("COOKIE", portletRequest, wsrpConsumer);
            String cookie = (String)portletSession.getAttribute(cookieKey, 1);
            CookieProtocol cookieProtocol = serviceDescription.getRequiresInitCookie();
            if (cookie == null && cookieProtocol != null && ((cookieProtocolValue = cookieProtocol.getValue()).equals("perGroup") || cookieProtocolValue.equals("perUser"))) {
                InitCookie initCookie = new InitCookie();
                initCookie.setRegistrationContext(registrationContext);
                markupService.initCookie(initCookie);
                cookie = WSRPHTTPSender.getCurrentCookie();
                portletSession.setAttribute(cookieKey, (Object)cookie, 1);
            }
        }
        return (ServiceHolder)serviceHolderTransientValue.getValue();
    }

    protected String getSessionKey(String baseKey, PortletRequest portletRequest, WSRPConsumer wsrpConsumer) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        StringBundler sb = new StringBundler();
        sb.append(baseKey);
        sb.append("_");
        sb.append(themeDisplay.getScopeGroupId());
        sb.append("_");
        sb.append(wsrpConsumer.getWsrpConsumerId());
        sb.append("_");
        sb.append(wsrpConsumer.getUrl());
        return sb.toString();
    }

    protected Telecom getTelecom(User user, String listTypeName) throws Exception {
        TelephoneNum phoneTelephoneNum;
        Telecom telecom = new Telecom();
        TelephoneNum faxTelephoneNum = this.getTelephoneNum(user, listTypeName + "-fax");
        if (faxTelephoneNum != null) {
            telecom.setFax(faxTelephoneNum);
        }
        if ((phoneTelephoneNum = this.getTelephoneNum(user, listTypeName)) != null) {
            telecom.setTelephone(phoneTelephoneNum);
        }
        return telecom;
    }

    protected TelephoneNum getTelephoneNum(User user, String listTypeName) throws Exception {
        List phones = this._phoneLocalService.getPhones(user.getCompanyId(), com.liferay.portal.kernel.model.Contact.class.getName(), user.getContactId());
        for (Phone phone : phones) {
            ListType listType = phone.getType();
            if (!listTypeName.equals(listType.getName())) continue;
            TelephoneNum telephoneNum = new TelephoneNum();
            telephoneNum.setExt(phone.getExtension());
            telephoneNum.setNumber(phone.getNumber());
            return telephoneNum;
        }
        return null;
    }

    protected UserProfile getUserProfile(User user) throws Exception {
        UserProfile userProfile = new UserProfile();
        Calendar bdate = this.getBdate(user);
        userProfile.setBdate(bdate);
        Contact businessInfoContact = this.getContact(user, "business");
        userProfile.setBusinessInfo(businessInfoContact);
        String gender = this.getGender(user);
        userProfile.setGender(gender);
        Contact homeInfoContact = this.getContact(user, "personal");
        userProfile.setHomeInfo(homeInfoContact);
        PersonName personName = this.getPersonName(user);
        userProfile.setName(personName);
        return userProfile;
    }

    protected WindowState getWindowState(String windowState) {
        return new WindowState(windowState.substring(5));
    }

    protected WSRPConsumerPortlet getWSRPConsumerPortlet() throws Exception {
        String portletName;
        PortletConfig portletConfig = this.getPortletConfig();
        String wsrpConsumerPortletUuid = portletName = portletConfig.getPortletName();
        if (portletName.startsWith(PORTLET_NAME_PREFIX)) {
            wsrpConsumerPortletUuid = portletName.substring(5, portletName.length());
        }
        wsrpConsumerPortletUuid = PortalUUIDUtil.fromJsSafeUuid((String)wsrpConsumerPortletUuid);
        WSRPConsumerPortlet wsrpConsumerPortlet = this._wsrpConsumerPortletLocalService.getWSRPConsumerPortlet(wsrpConsumerPortletUuid);
        return wsrpConsumerPortlet;
    }

    protected String getWSRPKey(String key) {
        return "wsrp:".concat(key);
    }

    protected String getWSRPMode(PortletMode portletMode) {
        return this.getWSRPKey(portletMode.toString());
    }

    protected String getWSRPWindowState(WindowState windowState) {
        return this.getWSRPKey(windowState.toString());
    }

    protected void initContexts(ActionRequest actionRequest, ActionResponse actionResponse, WSRPConsumer wsrpConsumer, WSRPConsumerPortlet wsrpConsumerPortlet, WSRPConsumerManager wsrpConsumerManager, InteractionParams interactionParams, MarkupParams markupParams, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext) throws Exception {
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)actionRequest);
        this.initContexts((PortletRequest)actionRequest, (PortletResponse)actionResponse, wsrpConsumer, wsrpConsumerPortlet, wsrpConsumerManager, (MimeRequest)markupParams, portletContext, runtimeContext, userContext);
        interactionParams.setPortletStateChange(StateChange.cloneBeforeWrite);
        String interactionState = actionRequest.getParameter("wsrp-interactionState");
        interactionParams.setInteractionState(interactionState);
        String contentType = request.getContentType();
        if (Validator.isNotNull((String)contentType) && contentType.startsWith("multipart/form-data")) {
            this.processMultipartForm(actionRequest, actionResponse, interactionParams);
        } else {
            this.processFormParameters(actionRequest, actionResponse, interactionParams);
        }
    }

    protected void initContexts(EventRequest eventRequest, EventResponse eventResponse, WSRPConsumer wsrpConsumer, WSRPConsumerPortlet wsrpConsumerPortlet, WSRPConsumerManager wsrpConsumerManager, EventParams eventParams, MarkupParams markupParams, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext) throws Exception {
        this.initContexts((PortletRequest)eventRequest, (PortletResponse)eventResponse, wsrpConsumer, wsrpConsumerPortlet, wsrpConsumerManager, (MimeRequest)markupParams, portletContext, runtimeContext, userContext);
        eventParams.setPortletStateChange(StateChange.cloneBeforeWrite);
        Event jxEvent = eventRequest.getEvent();
        oasis.names.tc.wsrp.v2.types.Event event = (oasis.names.tc.wsrp.v2.types.Event)jxEvent.getValue();
        eventParams.setEvents(new oasis.names.tc.wsrp.v2.types.Event[]{event});
    }

    protected void initContexts(PortletRequest portletRequest, PortletResponse portletResponse, WSRPConsumer wsrpConsumer, WSRPConsumerPortlet wsrpConsumerPortlet, WSRPConsumerManager wsrpConsumerManager, MimeRequest mimeRequest, PortletContext portletContext, RuntimeContext runtimeContext, UserContext userContext) throws Exception {
        PortletSession portletSession = portletRequest.getPortletSession();
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ClientData clientData = new ClientData();
        clientData.setRequestVerb(request.getMethod());
        clientData.setUserAgent(request.getHeader("User-Agent"));
        User user = themeDisplay.getUser();
        ArrayList<MessageElement> clientAttributes = new ArrayList<MessageElement>();
        Enumeration enu = request.getHeaderNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            String value = request.getHeader(name);
            ExtensionHelperUtil.addMessageElement(clientAttributes, name, value);
        }
        ExtensionHelperUtil.addMessageElement(clientAttributes, "LIFERAY_EMAIL_ADDRESS", user.getEmailAddress());
        ExtensionHelperUtil.addMessageElement(clientAttributes, "LIFERAY_SCREEN_NAME", user.getScreenName());
        ExtensionHelperUtil.addMessageElement(clientAttributes, "LIFERAY_USER_ID", String.valueOf(user.getUserId()));
        ConsumerRequestExtensionsHelper.addClientAttributes(clientAttributes);
        clientData.setExtensions(ExtensionHelperUtil.getExtensions(clientAttributes));
        mimeRequest.setClientData(clientData);
        ArrayList locales = Collections.list(portletRequest.getLocales());
        Object[] localesArray = new String[locales.size()];
        for (int i = 0; i < locales.size(); ++i) {
            Locale locale = (Locale)locales.get(i);
            localesArray[i] = locale.toString();
        }
        Locale locale = themeDisplay.getLocale();
        if (!locales.contains(locale)) {
            localesArray = (String[])ArrayUtil.append((Object[])new String[]{locale.toString(), locale.getLanguage()}, (Object[])localesArray);
        }
        mimeRequest.setLocales((String[])localesArray);
        String[] markupCharacterSets = null;
        if (Validator.isNotNull((String)wsrpConsumer.getMarkupCharacterSets())) {
            String markupCharacterSetsString = wsrpConsumer.getMarkupCharacterSets();
            markupCharacterSetsString = MarkupCharacterSetsUtil.getSupportedMarkupCharacterSets(markupCharacterSetsString);
            markupCharacterSets = StringUtil.split((String)markupCharacterSetsString);
        } else {
            markupCharacterSets = _CHAR_SETS;
        }
        mimeRequest.setMarkupCharacterSets(markupCharacterSets);
        mimeRequest.setMimeTypes(_MIME_TYPES);
        mimeRequest.setMode(this.getWSRPMode(portletRequest.getPortletMode()));
        mimeRequest.setWindowState(this.getWSRPWindowState(portletRequest.getWindowState()));
        String[] modes = new String[]{this.getWSRPMode(PortletMode.EDIT), this.getWSRPMode(PortletMode.HELP), this.getWSRPMode(PortletMode.VIEW)};
        mimeRequest.setValidNewModes(modes);
        String[] windowStates = new String[]{this.getWSRPWindowState(WindowState.MAXIMIZED), this.getWSRPWindowState(WindowState.MINIMIZED), this.getWSRPWindowState(WindowState.NORMAL)};
        mimeRequest.setValidNewWindowStates(windowStates);
        NavigationalContext navigationalContext = new NavigationalContext();
        String navigationalState = portletRequest.getParameter("wsrp-navigationalState");
        if (Validator.isNotNull((String)navigationalState)) {
            navigationalState = new String(Base64.decodeFromURL((String)navigationalState), "UTF-8");
            navigationalContext.setOpaqueValue(navigationalState);
        }
        Map publicParameterMap = portletRequest.getPublicParameterMap();
        ArrayList<NamedString> publicValues = new ArrayList<NamedString>();
        for (Map.Entry entry : publicParameterMap.entrySet()) {
            String[] values;
            String name = (String)entry.getKey();
            for (String value : values = (String[])entry.getValue()) {
                NamedString publicValue = new NamedString();
                publicValue.setName(name);
                publicValue.setValue(value);
                publicValues.add(publicValue);
            }
        }
        navigationalContext.setPublicValues(publicValues.toArray(new NamedString[publicValues.size()]));
        mimeRequest.setNavigationalContext(navigationalContext);
        if (mimeRequest instanceof MarkupParams) {
            this.processFormParameters(portletRequest, portletResponse, mimeRequest);
        }
        portletContext.setPortletHandle(wsrpConsumerPortlet.getPortletHandle());
        runtimeContext.setNamespacePrefix(portletResponse.getNamespace());
        runtimeContext.setPortletInstanceKey(portletResponse.getNamespace());
        SessionContext sessionContext = (SessionContext)portletSession.getAttribute("SESSION_CONTEXT");
        if (sessionContext != null) {
            SessionParams sessionParams = new SessionParams();
            sessionParams.setSessionID(sessionContext.getSessionID());
            runtimeContext.setSessionParams(sessionParams);
        }
        runtimeContext.setUserAuthentication("wsrp:password");
        PortletDescription portletDescription = wsrpConsumerManager.getPortletDescription(wsrpConsumerPortlet.getPortletHandle());
        Boolean doesUrlTemplateProcessing = portletDescription.getDoesUrlTemplateProcessing();
        if (doesUrlTemplateProcessing != null && doesUrlTemplateProcessing.booleanValue()) {
            Templates templates = new Templates();
            templates.setBlockingActionTemplate(_BLOCKING_ACTION_TEMPLATE);
            templates.setRenderTemplate(_RENDER_TEMPLATE);
            templates.setResourceTemplate(_RESOURCE_TEMPLATE);
            templates.setSecureBlockingActionTemplate(_BLOCKING_ACTION_TEMPLATE);
            templates.setSecureRenderTemplate(_RENDER_TEMPLATE);
            templates.setSecureResourceTemplate(_RESOURCE_TEMPLATE);
            runtimeContext.setTemplates(templates);
        }
        UserProfile userProfile = this.getUserProfile(user);
        ConsumerRequestExtensionsHelper.addUserProfileAttributes(userProfile, user);
        userContext.setProfile(userProfile);
        userContext.setUserContextKey(String.valueOf(user.getUserId()));
    }

    protected void initContexts(ResourceRequest resourceRequest, ResourceResponse resourceResponse, WSRPConsumer wsrpConsumer, WSRPConsumerPortlet wsrpConsumerPortlet, WSRPConsumerManager wsrpConsumerManager, PortletContext portletContext, ResourceParams resourceParams, RuntimeContext runtimeContext, UserContext userContext) throws Exception {
        String contentType;
        String resourceCacheability;
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)resourceRequest);
        this.initContexts((PortletRequest)resourceRequest, (PortletResponse)resourceResponse, wsrpConsumer, wsrpConsumerPortlet, wsrpConsumerManager, (MimeRequest)resourceParams, portletContext, runtimeContext, userContext);
        String resourceID = resourceRequest.getResourceID();
        resourceParams.setResourceID(resourceID);
        resourceParams.setPortletStateChange(StateChange.cloneBeforeWrite);
        String resourceState = ParamUtil.getString((PortletRequest)resourceRequest, (String)"wsrp-resourceState");
        if (Validator.isNotNull((String)resourceState)) {
            resourceParams.setResourceState(resourceState);
        }
        if (Validator.isNotNull((String)(resourceCacheability = ParamUtil.getString((PortletRequest)resourceRequest, (String)"wsrp-resourceCacheability")))) {
            resourceParams.setResourceState(resourceCacheability);
        }
        if (Validator.isNotNull((String)(contentType = request.getContentType())) && contentType.startsWith("multipart/form-data")) {
            this.processMultipartForm(resourceRequest, resourceResponse, resourceParams);
        } else {
            this.processFormParameters(resourceRequest, resourceResponse, resourceParams);
        }
    }

    protected boolean isReservedParameter(String name) {
        return name.startsWith("wsrp-");
    }

    protected void processBlockingInteractionResponse(ActionRequest actionRequest, ActionResponse actionResponse, WSRPConsumerManager wsrpConsumerManager, ServiceHolder serviceHolder, BlockingInteractionResponse blockingInteractionResponse) throws Exception {
        String redirectURL = blockingInteractionResponse.getRedirectURL();
        if (Validator.isNotNull((String)redirectURL)) {
            this.sendRedirect(actionRequest, actionResponse, redirectURL);
            return;
        }
        this.processUpdateResponse((PortletRequest)actionRequest, (StateAwareResponse)actionResponse, wsrpConsumerManager, serviceHolder, blockingInteractionResponse.getUpdateResponse());
    }

    protected void processFormParameters(ActionRequest actionRequest, ActionResponse actionResponse, InteractionParams interactionParams) {
        List<NamedString> formParameters = this.processFormParameters((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        if (!formParameters.isEmpty()) {
            interactionParams.setFormParameters(formParameters.toArray(new NamedString[formParameters.size()]));
        }
    }

    protected List<NamedString> processFormParameters(PortletRequest portletRequest, PortletResponse portletResponse) {
        ArrayList<NamedString> formParameters = new ArrayList<NamedString>();
        Enumeration enu = portletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String[] values;
            String name = (String)enu.nextElement();
            if (this.isReservedParameter(name) || (values = portletRequest.getParameterValues(name)) == null) continue;
            this.addFormField(formParameters, name, values);
        }
        return formParameters;
    }

    protected void processFormParameters(PortletRequest portletRequest, PortletResponse portletResponse, MimeRequest mimeRequest) {
        ArrayList<MessageElement> formParameters = new ArrayList<MessageElement>();
        Enumeration enu = portletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String[] values;
            String name = (String)enu.nextElement();
            if (this.isReservedParameter(name) || (values = portletRequest.getParameterValues(name)) == null) continue;
            for (String value : values) {
                ExtensionHelperUtil.addMessageElement(formParameters, name, value);
            }
        }
        if (!formParameters.isEmpty()) {
            mimeRequest.setExtensions(ExtensionHelperUtil.getExtensions(formParameters));
        }
    }

    protected void processFormParameters(ResourceRequest resourceRequest, ResourceResponse resourceResponse, ResourceParams resourceParams) {
        List<NamedString> formParameters = this.processFormParameters((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        if (!formParameters.isEmpty()) {
            resourceParams.setFormParameters(formParameters.toArray(new NamedString[formParameters.size()]));
        }
    }

    protected void processHandleEventsResponse(EventRequest eventRequest, EventResponse eventResponse, WSRPConsumerManager wsrpConsumerManager, ServiceHolder serviceHolder, HandleEventsResponse handleEventsResponse) throws Exception {
        this.processUpdateResponse((PortletRequest)eventRequest, (StateAwareResponse)eventResponse, wsrpConsumerManager, serviceHolder, handleEventsResponse.getUpdateResponse());
    }

    protected void processMarkupResponse(PortletRequest portletRequest, PortletResponse portletResponse, ServiceHolder serviceHolder, MarkupResponse markupResponse) {
        PortletSession portletSession = portletRequest.getPortletSession();
        SessionContext sessionContext = markupResponse.getSessionContext();
        this.updateSessionContext(portletSession, serviceHolder, sessionContext);
    }

    protected void processMimeResponse(PortletRequest portletRequest, javax.portlet.MimeResponse jxMimeResponse, MimeResponse mimeResponse) throws Exception {
        String contentType = GetterUtil.get((String)mimeResponse.getMimeType(), (String)"text/html; charset=UTF-8");
        jxMimeResponse.setContentType(contentType);
        String charSet = this.getCharSet(contentType);
        String itemString = mimeResponse.getItemString();
        byte[] itemBinary = mimeResponse.getItemBinary();
        Boolean requiresRewriting = mimeResponse.getRequiresRewriting();
        if (requiresRewriting == null) {
            requiresRewriting = ParamUtil.getBoolean((PortletRequest)portletRequest, (String)"wsrp-requiresRewrite");
        }
        if (requiresRewriting.booleanValue() && contentType.contains("text")) {
            if (itemBinary != null) {
                itemString = new String(itemBinary, charSet);
            }
            itemString = this.rewriteURLs(portletRequest, (PortletResponse)jxMimeResponse, itemString);
        }
        if (Validator.isNotNull((String)itemString)) {
            if (jxMimeResponse instanceof ResourceResponse) {
                ResourceResponse resourceResponse = (ResourceResponse)jxMimeResponse;
                resourceResponse.setContentLength(itemString.length());
            }
            PortletResponseUtil.write((javax.portlet.MimeResponse)jxMimeResponse, (String)itemString);
        } else if (itemBinary != null) {
            if (jxMimeResponse instanceof ResourceResponse) {
                ResourceResponse resourceResponse = (ResourceResponse)jxMimeResponse;
                resourceResponse.setContentLength(itemBinary.length);
            }
            PortletResponseUtil.write((javax.portlet.MimeResponse)jxMimeResponse, (byte[])itemBinary);
        }
    }

    protected void processMultipartForm(ActionRequest actionRequest, ActionResponse actionResponse, InteractionParams interactionParams) throws Exception {
        Object[] formData = this.processMultipartForm((PortletRequest)actionRequest, (PortletResponse)actionResponse);
        List formParameters = (List)formData[0];
        List uploadContexts = (List)formData[1];
        if (!formParameters.isEmpty()) {
            interactionParams.setFormParameters(formParameters.toArray(new NamedString[formParameters.size()]));
        }
        if (!uploadContexts.isEmpty()) {
            interactionParams.setUploadContexts(uploadContexts.toArray(new UploadContext[uploadContexts.size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object[] processMultipartForm(PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        ArrayList<NamedString> formParameters = new ArrayList<NamedString>();
        ArrayList<UploadContext> uploadContexts = new ArrayList<UploadContext>();
        UploadPortletRequest uploadPortletRequest = PortalUtil.getUploadPortletRequest((PortletRequest)portletRequest);
        Enumeration enu = uploadPortletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            byte[] bytes;
            InputStream inputStream;
            UploadContext uploadContext;
            block7: {
                block6: {
                    String name = (String)enu.nextElement();
                    if (this.isReservedParameter(name) || name.startsWith("p_p_")) continue;
                    if (uploadPortletRequest.isFormField(name).booleanValue()) {
                        String[] values = uploadPortletRequest.getParameterValues(name);
                        if (values == null) continue;
                        this.addFormField(formParameters, name, values);
                        continue;
                    }
                    uploadContext = new UploadContext();
                    String contentType = uploadPortletRequest.getContentType(name);
                    uploadContext.setMimeType(contentType);
                    StringBuilder sb = new StringBuilder();
                    sb.append("form-data; ");
                    sb.append("name=");
                    sb.append(name);
                    sb.append("; filename=");
                    sb.append(uploadPortletRequest.getFileName(name));
                    NamedString mimeAttribute = new NamedString();
                    mimeAttribute.setName("Content-Disposition");
                    mimeAttribute.setValue(sb.toString());
                    uploadContext.setMimeAttributes(new NamedString[]{mimeAttribute});
                    inputStream = null;
                    try {
                        inputStream = uploadPortletRequest.getFileAsStream(name);
                        if (inputStream != null) break block6;
                    }
                    catch (Throwable throwable) {
                        StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                        throw throwable;
                    }
                    StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                    continue;
                }
                bytes = FileUtil.getBytes((InputStream)inputStream);
                if (bytes != null) break block7;
                StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
                continue;
            }
            uploadContext.setUploadData(bytes);
            StreamUtil.cleanUp((Closeable[])new Closeable[]{inputStream});
            uploadContexts.add(uploadContext);
        }
        return new Object[]{formParameters, uploadContexts};
    }

    protected void processMultipartForm(ResourceRequest resourceRequest, ResourceResponse resourceResponse, ResourceParams resourceParams) throws Exception {
        Object[] formData = this.processMultipartForm((PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        List formParameters = (List)formData[0];
        List uploadContexts = (List)formData[1];
        if (!formParameters.isEmpty()) {
            resourceParams.setFormParameters(formParameters.toArray(new NamedString[formParameters.size()]));
        }
        if (!uploadContexts.isEmpty()) {
            resourceParams.setUploadContexts(uploadContexts.toArray(new UploadContext[uploadContexts.size()]));
        }
    }

    protected void processResourceResponse(ResourceRequest resourceRequest, ResourceResponse resourceResponse, WSRPConsumerManager wsrpConsumerManager, ServiceHolder serviceHolder, oasis.names.tc.wsrp.v2.types.ResourceResponse wsrpResourceResponse) throws Exception {
        NamedString[] clientAttributes;
        PortletSession portletSession = resourceRequest.getPortletSession();
        PortletContext portletContext = wsrpResourceResponse.getPortletContext();
        if (portletContext != null) {
            portletSession.setAttribute("PORTLET_CONTEXT", (Object)portletContext);
        }
        SessionContext sessionContext = wsrpResourceResponse.getSessionContext();
        this.updateSessionContext(portletSession, serviceHolder, sessionContext);
        ResourceContext resourceContext = wsrpResourceResponse.getResourceContext();
        CacheControl cacheControl = resourceContext.getCacheControl();
        if (cacheControl != null) {
            if (cacheControl.getExpires() == 0) {
                resourceResponse.setProperty("Cache-Control", "private, no-cache, no-store, must-revalidate");
            } else if (cacheControl.getExpires() > 0) {
                resourceResponse.setProperty("Cache-Control", "max-age=" + cacheControl.getExpires());
            } else {
                resourceResponse.setProperty("Cache-Control", "max-age=315360000, public");
            }
        }
        if ((clientAttributes = resourceContext.getClientAttributes()) != null) {
            for (NamedString clientAttribute : clientAttributes) {
                String name = clientAttribute.getName();
                String value = clientAttribute.getValue();
                if (!StringUtil.equalsIgnoreCase((String)name, (String)"Content-Disposition")) continue;
                resourceResponse.setProperty("Content-Disposition", value);
                break;
            }
        }
        this.processMimeResponse((PortletRequest)resourceRequest, (javax.portlet.MimeResponse)resourceResponse, (MimeResponse)resourceContext);
    }

    protected void processUpdateResponse(PortletRequest portletRequest, StateAwareResponse stateAwareResponse, WSRPConsumerManager wsrpConsumerManager, ServiceHolder serviceHolder, UpdateResponse updateResponse) throws Exception {
        oasis.names.tc.wsrp.v2.types.Event[] events;
        String windowState;
        PortletContext portletContext;
        PortletSession portletSession = portletRequest.getPortletSession();
        if (updateResponse == null) {
            return;
        }
        portletSession.setAttribute("MARKUP_CONTEXT", (Object)updateResponse.getMarkupContext());
        NavigationalContext navigationalContext = updateResponse.getNavigationalContext();
        if (navigationalContext != null) {
            NamedString[] publicValues;
            String opaqueValue = navigationalContext.getOpaqueValue();
            if (Validator.isNotNull((String)opaqueValue)) {
                byte[] opaqueValueBytes = opaqueValue.getBytes("UTF-8");
                opaqueValue = Base64.encodeToURL((byte[])opaqueValueBytes);
                stateAwareResponse.setRenderParameter("wsrp-navigationalState", opaqueValue);
            }
            if ((publicValues = navigationalContext.getPublicValues()) != null) {
                for (NamedString publicValue : publicValues) {
                    String name = publicValue.getName();
                    String value = publicValue.getValue();
                    if (Validator.isNotNull((String)value)) {
                        stateAwareResponse.setRenderParameter(name, value);
                        continue;
                    }
                    stateAwareResponse.removePublicRenderParameter(name);
                }
            }
        }
        if ((portletContext = updateResponse.getPortletContext()) != null) {
            portletSession.setAttribute("PORTLET_CONTEXT", (Object)portletContext);
        }
        SessionContext sessionContext = updateResponse.getSessionContext();
        this.updateSessionContext(portletSession, serviceHolder, sessionContext);
        String portletMode = updateResponse.getNewMode();
        if (Validator.isNotNull((String)portletMode)) {
            stateAwareResponse.setPortletMode(this.getPortletMode(portletMode));
        }
        if (Validator.isNotNull((String)(windowState = updateResponse.getNewWindowState()))) {
            stateAwareResponse.setWindowState(this.getWindowState(windowState));
        }
        if ((events = updateResponse.getEvents()) != null) {
            for (oasis.names.tc.wsrp.v2.types.Event event : events) {
                QName qName = wsrpConsumerManager.getEventQName(event.getName());
                event.setName(qName);
                stateAwareResponse.setEvent(qName, (Serializable)event);
            }
        }
    }

    protected void proxyURL(ResourceRequest resourceRequest, ResourceResponse resourceResponse, String url) throws Exception {
        String contentType;
        int contentLength;
        PortletSession portletSession = resourceRequest.getPortletSession();
        WSRPConsumerPortlet wsrpConsumerPortlet = this.getWSRPConsumerPortlet();
        WSRPConsumer wsrpConsumer = this._wsrpConsumerLocalService.getWSRPConsumer(wsrpConsumerPortlet.getWsrpConsumerId());
        Http.Options options = new Http.Options();
        options.setLocation(url);
        String cookieKey = this.getSessionKey("COOKIE", (PortletRequest)resourceRequest, wsrpConsumer);
        String cookie = (String)portletSession.getAttribute(cookieKey, 1);
        if (Validator.isNotNull((String)cookie)) {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Cookie", cookie);
            options.setHeaders(headers);
        }
        byte[] bytes = HttpUtil.URLtoByteArray((Http.Options)options);
        Http.Response response = options.getResponse();
        String contentDisposition = response.getHeader("Content-Disposition");
        if (Validator.isNotNull((String)contentDisposition)) {
            resourceResponse.setProperty("Content-Disposition", contentDisposition);
        }
        if ((contentLength = response.getContentLength()) >= 0) {
            resourceResponse.setContentLength(contentLength);
        }
        if (Validator.isNotNull((String)(contentType = response.getContentType()))) {
            resourceResponse.setContentType(contentType);
        }
        String charSet = this.getCharSet(contentType);
        if (ParamUtil.getBoolean((PortletRequest)resourceRequest, (String)"wsrp-requiresRewrite")) {
            String content = this.rewriteURLs((PortletRequest)resourceRequest, (PortletResponse)resourceResponse, new String(bytes, charSet));
            PortletResponseUtil.write((javax.portlet.MimeResponse)resourceResponse, (String)content);
        } else {
            PortletResponseUtil.write((javax.portlet.MimeResponse)resourceResponse, (byte[])bytes);
        }
    }

    protected String rewriteURL(PortletRequest portletRequest, PortletResponse portletResponse, Map<String, String> parameterMap) throws Exception {
        LiferayPortletResponse liferayPortletResponse = this._portal.getLiferayPortletResponse(portletResponse);
        String lifecycle = parameterMap.get("wsrp-urlType");
        LiferayPortletURL liferayPortletURL = null;
        if (lifecycle.equals("blockingAction")) {
            liferayPortletURL = (LiferayPortletURL)liferayPortletResponse.createActionURL();
        } else if (lifecycle.equals("render")) {
            liferayPortletURL = (LiferayPortletURL)liferayPortletResponse.createRenderURL();
        } else if (lifecycle.equals("resource")) {
            WSRPGroupServiceConfiguration wsrpGroupServiceConfiguration = WSRPConfigurationUtil.getWSRPConfiguration();
            liferayPortletURL = (LiferayPortletURL)liferayPortletResponse.createResourceURL();
            if (wsrpGroupServiceConfiguration.secureResourceUrlsEnabled()) {
                this.secureResourceURL(portletRequest, liferayPortletURL, parameterMap);
            }
        }
        for (Map.Entry entry : parameterMap.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (name.equals("wsrp-mode")) {
                try {
                    liferayPortletURL.setPortletMode(this.getPortletMode(value));
                }
                catch (Exception e) {
                    liferayPortletURL.setPortletMode(PortletMode.VIEW);
                }
                continue;
            }
            if (name.equals("wsrp-navigationalState")) {
                if (!Validator.isNotNull((String)value)) continue;
                byte[] valueBytes = value.getBytes("UTF-8");
                value = Base64.encodeToURL((byte[])valueBytes);
                liferayPortletURL.setParameter(name, value);
                continue;
            }
            if (name.equals("wsrp-navigationalValues")) {
                Matcher navigationalValuesMatcher = _navigationalValuesPattern.matcher(value);
                while (navigationalValuesMatcher.find()) {
                    String navigationalValuesName = navigationalValuesMatcher.group(1);
                    String navigationalValuesValue = navigationalValuesMatcher.group(2);
                    if (Validator.isNull((String)navigationalValuesValue)) {
                        liferayPortletURL.removePublicRenderParameter(navigationalValuesName);
                        continue;
                    }
                    liferayPortletURL.setParameter(navigationalValuesName, navigationalValuesValue, true);
                }
                continue;
            }
            if (name.equals("wsrp-resourceID")) {
                liferayPortletURL.setResourceID(value);
                continue;
            }
            if (name.equals("wsrp-urlType")) continue;
            if (name.equals("wsrp-windowState")) {
                try {
                    liferayPortletURL.setWindowState(this.getWindowState(value));
                }
                catch (Exception e) {
                    liferayPortletURL.setWindowState(WindowState.NORMAL);
                }
                continue;
            }
            liferayPortletURL.setParameter(name, value);
        }
        String url = liferayPortletURL.toString();
        return url;
    }

    protected String rewriteURLs(PortletRequest portletRequest, PortletResponse portletResponse, String content) throws Exception {
        Matcher rewriteMatcher = _rewritePattern.matcher(content);
        StringBuffer sb = new StringBuffer();
        while (rewriteMatcher.find()) {
            String replacement;
            String rewrittenURL;
            String namespace = rewriteMatcher.group(1);
            String url = rewriteMatcher.group(2);
            String extensionURL1 = rewriteMatcher.group(3);
            String extensionURL2 = rewriteMatcher.group(4);
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            if (Validator.isNotNull((String)namespace)) {
                rewriteMatcher.appendReplacement(sb, portletResponse.getNamespace());
                continue;
            }
            if (Validator.isNotNull((String)url)) {
                Matcher parameterMatcher = _parameterPattern.matcher(url);
                while (parameterMatcher.find()) {
                    String name = parameterMatcher.group(1);
                    String value = parameterMatcher.group(2);
                    if (Validator.isNull((String)value) || value.equals("\"\"")) continue;
                    parameterMap.put(name, HttpUtil.decodeURL((String)value));
                }
                String rewrittenURL2 = this.rewriteURL(portletRequest, portletResponse, parameterMap);
                rewriteMatcher.appendReplacement(sb, rewrittenURL2);
                continue;
            }
            if (Validator.isNotNull((String)extensionURL1)) {
                parameterMap.put("wsrp-urlType", "render");
                parameterMap.put("wsrp-windowState", "wsrp:normal");
                rewrittenURL = this.rewriteURL(portletRequest, portletResponse, parameterMap);
                replacement = "location.href = '" + rewrittenURL + "'";
                rewriteMatcher.appendReplacement(sb, replacement);
                continue;
            }
            if (!Validator.isNotNull((String)extensionURL2)) continue;
            parameterMap.put("wsrp-urlType", "render");
            parameterMap.put("wsrp-windowState", "wsrp:normal");
            rewrittenURL = this.rewriteURL(portletRequest, portletResponse, parameterMap);
            replacement = "href=\"" + rewrittenURL + "\"";
            rewriteMatcher.appendReplacement(sb, replacement);
        }
        rewriteMatcher.appendTail(sb);
        return sb.toString();
    }

    protected void secureResourceURL(PortletRequest portletRequest, LiferayPortletURL liferayPortletURL, Map<String, String> parameterMap) throws Exception {
        WSRPGroupServiceConfiguration wsrpGroupServiceConfiguration = WSRPConfigurationUtil.getWSRPConfiguration();
        HttpServletRequest request = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String resourceID = GetterUtil.getString((String)parameterMap.get("wsrp-resourceID"));
        String url = GetterUtil.getString((String)parameterMap.get("wsrp-url"));
        StringBundler sb = new StringBundler(4);
        sb.append(resourceID);
        sb.append(url);
        sb.append(wsrpGroupServiceConfiguration.secureResourceUrlsSalt());
        if (themeDisplay.isSignedIn()) {
            sb.append(AuthTokenUtil.getToken((HttpServletRequest)request));
        }
        String wsrpAuth = this._wsrpURLUtil.encodeWSRPAuth(themeDisplay.getCompanyId(), sb.toString());
        parameterMap.put("wsrp-auth", wsrpAuth);
    }

    protected void sendRedirect(ActionRequest actionRequest, ActionResponse actionResponse, String redirectURL) throws Exception {
        redirectURL = this.rewriteURLs((PortletRequest)actionRequest, (PortletResponse)actionResponse, redirectURL);
        actionResponse.sendRedirect(redirectURL);
    }

    protected void updateSessionContext(PortletSession portletSession, ServiceHolder serviceHolder, SessionContext sessionContext) {
        if (sessionContext == null) {
            return;
        }
        portletSession.setAttribute("SESSION_CONTEXT", (Object)sessionContext);
        serviceHolder.setSessionContext(sessionContext);
    }

    static {
        _CHAR_SETS = new String[]{"UTF-8"};
        _MIME_TYPES = new String[]{"text/html"};
        _log = LogFactoryUtil.getLog(ConsumerPortlet.class);
        _navigationalValuesPattern = Pattern.compile("(?:([^&=]+)(?:=([^&=]*))?)&?");
        _parameterPattern = Pattern.compile("(?:([^&]+)=([^&]*))(?:&amp;|&)?");
        _rewritePattern = Pattern.compile("(wsrp_rewrite_)|(?:wsrp_rewrite\\?([^\\s/]+)/wsrp_rewrite)|(?:location\\.href\\s*=\\s*'(/widget/c/portal/layout(?:[^']+))')|(?:href\\s*=\\s*\"(/widget/c/portal/layout(?:[^\"]+))\")");
        StringBundler sb = new StringBundler(6);
        sb.append("wsrp_rewrite?wsrp-urlType=blockingAction&");
        sb.append("wsrp-navigationalState={wsrp-navigationalState}&");
        sb.append("wsrp-navigationalValues={wsrp-navigationalValues}&");
        sb.append("wsrp-interactionState={wsrp-interactionState}&");
        sb.append("wsrp-mode={wsrp-mode}&wsrp-windowState={wsrp-windowState}");
        sb.append("&wsrp-fragmentID={wsrp-fragmentID}/wsrp_rewrite");
        _BLOCKING_ACTION_TEMPLATE = sb.toString();
        sb = new StringBundler(5);
        sb.append("wsrp_rewrite?wsrp-urlType=render&");
        sb.append("wsrp-navigationalState={wsrp-navigationalState}&");
        sb.append("wsrp-navigationalValues={wsrp-navigationalValues}&");
        sb.append("wsrp-mode={wsrp-mode}&wsrp-windowState={wsrp-windowState}&");
        sb.append("wsrp-fragmentID={wsrp-fragmentID}/wsrp_rewrite");
        _RENDER_TEMPLATE = sb.toString();
        sb = new StringBundler(7);
        sb.append("wsrp_rewrite?wsrp-urlType=resource&wsrp-url={wsrp-url}&");
        sb.append("wsrp-resourceID={wsrp-resourceID}&");
        sb.append("wsrp-preferOperation={wsrp-preferOperation}&");
        sb.append("wsrp-resourceState={wsrp-resourceState}&");
        sb.append("wsrp-requiresRewrite={wsrp-requiresRewrite}&");
        sb.append("wsrp-resourceCacheability={wsrp-resourceCacheability}");
        sb.append("/wsrp_rewrite");
        _RESOURCE_TEMPLATE = sb.toString();
    }
}

