/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wsrp.internal.bind;

import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.axis.ServletUtil;
import com.liferay.wsrp.internal.bind.BaseServiceImpl;
import com.liferay.wsrp.model.WSRPProducer;
import com.liferay.wsrp.util.ExtensionHelperUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import oasis.names.tc.wsrp.v2.intf.WSRP_v2_Markup_PortType;
import oasis.names.tc.wsrp.v2.types.BlockingInteractionResponse;
import oasis.names.tc.wsrp.v2.types.ClientData;
import oasis.names.tc.wsrp.v2.types.Extension;
import oasis.names.tc.wsrp.v2.types.GetMarkup;
import oasis.names.tc.wsrp.v2.types.GetResource;
import oasis.names.tc.wsrp.v2.types.HandleEvents;
import oasis.names.tc.wsrp.v2.types.HandleEventsResponse;
import oasis.names.tc.wsrp.v2.types.InitCookie;
import oasis.names.tc.wsrp.v2.types.InteractionParams;
import oasis.names.tc.wsrp.v2.types.MarkupContext;
import oasis.names.tc.wsrp.v2.types.MarkupResponse;
import oasis.names.tc.wsrp.v2.types.MimeRequest;
import oasis.names.tc.wsrp.v2.types.NamedString;
import oasis.names.tc.wsrp.v2.types.NavigationalContext;
import oasis.names.tc.wsrp.v2.types.PerformBlockingInteraction;
import oasis.names.tc.wsrp.v2.types.PortletContext;
import oasis.names.tc.wsrp.v2.types.ReleaseSessions;
import oasis.names.tc.wsrp.v2.types.ResourceContext;
import oasis.names.tc.wsrp.v2.types.ResourceParams;
import oasis.names.tc.wsrp.v2.types.ResourceResponse;
import oasis.names.tc.wsrp.v2.types.RuntimeContext;
import oasis.names.tc.wsrp.v2.types.UpdateResponse;
import oasis.names.tc.wsrp.v2.types.UploadContext;
import org.apache.axis.message.MessageElement;

public class V2MarkupServiceImpl
extends BaseServiceImpl
implements WSRP_v2_Markup_PortType {
    private static final String _PATH_WIDGET = "/widget/c/portal/layout";
    private static final Log _log = LogFactoryUtil.getLog(V2MarkupServiceImpl.class);

    public MarkupResponse getMarkup(GetMarkup getMarkup) throws RemoteException {
        try {
            return this.doGetMarkup(getMarkup);
        }
        catch (RemoteException re) {
            _log.error((Object)re, (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public ResourceResponse getResource(GetResource getResource) throws RemoteException {
        try {
            return this.doGetResource(getResource);
        }
        catch (RemoteException re) {
            _log.error((Object)re, (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public HandleEventsResponse handleEvents(HandleEvents handleEvents) throws RemoteException {
        try {
            return this.doHandleEvents(handleEvents);
        }
        catch (RemoteException re) {
            _log.error((Object)re, (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public Extension[] initCookie(InitCookie initCookie) throws RemoteException {
        try {
            return this.doInitCookie(initCookie);
        }
        catch (RemoteException re) {
            _log.error((Object)re, (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public BlockingInteractionResponse performBlockingInteraction(PerformBlockingInteraction performBlockingInteraction) throws RemoteException {
        try {
            return this.doPerformBlockingInteraction(performBlockingInteraction);
        }
        catch (RemoteException re) {
            _log.error((Object)re, (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public Extension[] releaseSessions(ReleaseSessions releaseSessions) throws RemoteException {
        try {
            return this.doReleaseSessions(releaseSessions);
        }
        catch (RemoteException re) {
            _log.error((Object)re, (Throwable)re);
            throw re;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    protected void addHeaders(MimeRequest mimeRequest, Http.Options httpOptions) {
        ClientData clientData = mimeRequest.getClientData();
        Extension[] extensions = clientData.getExtensions();
        MessageElement[] clientAttributes = ExtensionHelperUtil.getMessageElements(extensions);
        if (clientAttributes == null) {
            return;
        }
        for (MessageElement clientAttribute : clientAttributes) {
            String name = ExtensionHelperUtil.getNameAttribute(clientAttribute);
            String value = clientAttribute.getValue();
            if (StringUtil.equalsIgnoreCase((String)name, (String)"Accept-Encoding") || StringUtil.equalsIgnoreCase((String)name, (String)"Content-Length") || StringUtil.equalsIgnoreCase((String)name, (String)"Content-Type") || StringUtil.equalsIgnoreCase((String)name, (String)"Cookie")) continue;
            httpOptions.addHeader(name, value);
        }
    }

    protected MarkupResponse doGetMarkup(GetMarkup getMarkup) throws Exception {
        WSRPProducer wsrpProducer = this.getWSRPProducer();
        Http.Options httpOptions = new Http.Options();
        this.addHeaders((MimeRequest)getMarkup.getMarkupParams(), httpOptions);
        httpOptions.setLocation(this.getURL(getMarkup, wsrpProducer));
        String rawContent = this.getRawContent(httpOptions);
        String windowState = this.getWindowState((MimeRequest)getMarkup.getMarkupParams());
        String content = this.getContent(rawContent, windowState);
        MarkupContext markupContext = new MarkupContext();
        markupContext.setItemString(content);
        markupContext.setMimeType("text/html; charset=UTF-8");
        markupContext.setRequiresRewriting(Boolean.valueOf(true));
        MarkupResponse markupResponse = new MarkupResponse();
        markupResponse.setMarkupContext(markupContext);
        return markupResponse;
    }

    protected ResourceResponse doGetResource(GetResource getResource) throws Exception {
        int contentLength;
        NamedString clientAttribute;
        WSRPProducer wsrpProducer = this.getWSRPProducer();
        Http.Options httpOptions = new Http.Options();
        this.addHeaders((MimeRequest)getResource.getResourceParams(), httpOptions);
        httpOptions.setLocation(this.getURL(getResource, wsrpProducer));
        ResourceParams resourceParams = getResource.getResourceParams();
        UploadContext[] uploadContexts = resourceParams.getUploadContexts();
        this.processUploadContexts(uploadContexts, httpOptions);
        NamedString[] formParameters = resourceParams.getFormParameters();
        if (formParameters != null) {
            NavigationalContext navigationalContext = resourceParams.getNavigationalContext();
            PortletContext portletContext = getResource.getPortletContext();
            String namespace = PortalUtil.getPortletNamespace((String)this.getPortletId(portletContext, navigationalContext));
            for (NamedString formParameter : formParameters) {
                httpOptions.addPart(namespace + formParameter.getName(), formParameter.getValue());
            }
            if (formParameters.length > 0) {
                httpOptions.setPost(true);
            }
        }
        httpOptions.setFollowRedirects(false);
        byte[] itemBinary = this.getBinaryContent(httpOptions);
        ResourceContext resourceContext = new ResourceContext();
        Http.Response response = httpOptions.getResponse();
        String contentType = response.getContentType();
        if (itemBinary != null) {
            if (Validator.isNotNull((String)contentType) && StringUtil.toLowerCase((String)contentType).startsWith("text")) {
                String content = new String(itemBinary);
                resourceContext.setItemString(content);
                resourceContext.setRequiresRewriting(Boolean.valueOf(true));
            } else {
                resourceContext.setItemBinary(itemBinary);
            }
        }
        ArrayList<NamedString> clientAttributes = new ArrayList<NamedString>();
        String contentDisposition = response.getHeader("Content-Disposition");
        if (Validator.isNotNull((String)contentDisposition)) {
            clientAttribute = new NamedString();
            clientAttribute.setName("Content-Disposition");
            clientAttribute.setValue(contentDisposition);
            clientAttributes.add(clientAttribute);
        }
        if (Validator.isNotNull((String)contentType)) {
            resourceContext.setMimeType(contentType);
            clientAttribute = new NamedString();
            clientAttribute.setName("Content-Type");
            clientAttribute.setValue(contentType);
            clientAttributes.add(clientAttribute);
        }
        if ((contentLength = response.getContentLength()) >= 0) {
            NamedString clientAttribute2 = new NamedString();
            clientAttribute2.setName("Content-Length");
            clientAttribute2.setValue(Integer.toString(contentLength));
            clientAttributes.add(clientAttribute2);
        }
        resourceContext.setClientAttributes(clientAttributes.toArray(new NamedString[clientAttributes.size()]));
        ResourceResponse resourceResponse = new ResourceResponse();
        resourceResponse.setResourceContext(resourceContext);
        return resourceResponse;
    }

    protected HandleEventsResponse doHandleEvents(HandleEvents handleEvents) throws Exception {
        HandleEventsResponse handleEventsResponse = new HandleEventsResponse();
        return handleEventsResponse;
    }

    protected Extension[] doInitCookie(InitCookie initCookie) throws Exception {
        ServletUtil.getSession();
        return null;
    }

    protected BlockingInteractionResponse doPerformBlockingInteraction(PerformBlockingInteraction performBlockingInteraction) throws Exception {
        WSRPProducer wsrpProducer = this.getWSRPProducer();
        Http.Options httpOptions = new Http.Options();
        this.addHeaders((MimeRequest)performBlockingInteraction.getMarkupParams(), httpOptions);
        httpOptions.setLocation(this.getURL(performBlockingInteraction, wsrpProducer));
        RuntimeContext runtimeContext = performBlockingInteraction.getRuntimeContext();
        InteractionParams interactionParams = performBlockingInteraction.getInteractionParams();
        UploadContext[] uploadContexts = interactionParams.getUploadContexts();
        this.processUploadContexts(uploadContexts, httpOptions);
        NamedString[] formParameters = interactionParams.getFormParameters();
        if (formParameters != null) {
            for (NamedString formParameter : formParameters) {
                String name = StringUtil.replace((String)formParameter.getName(), (String)runtimeContext.getNamespacePrefix(), (String)"");
                httpOptions.addPart(name, formParameter.getValue());
            }
        }
        httpOptions.setFollowRedirects(false);
        httpOptions.setPost(true);
        String rawContent = this.getRawContent(httpOptions);
        Http.Response response = httpOptions.getResponse();
        String redirect = response.getRedirect();
        String widgetPath = this.getWidgetPath();
        BlockingInteractionResponse blockingInteractionResponse = new BlockingInteractionResponse();
        if (Validator.isNotNull((String)redirect) && !redirect.startsWith(widgetPath)) {
            int pos = redirect.indexOf("wsrp_rewrite?");
            if (pos >= 0) {
                redirect = redirect.substring(pos);
            }
            blockingInteractionResponse.setRedirectURL(redirect);
        } else {
            if (Validator.isNotNull((String)redirect) && redirect.startsWith(widgetPath)) {
                httpOptions.setLocation(redirect);
                rawContent = this.getRawContent(httpOptions);
            }
            String windowState = this.getWindowState((MimeRequest)performBlockingInteraction.getMarkupParams());
            String content = this.getContent(rawContent, windowState);
            MarkupContext markupContext = new MarkupContext();
            markupContext.setItemString(content);
            markupContext.setMimeType("text/html; charset=UTF-8");
            markupContext.setRequiresRewriting(Boolean.valueOf(true));
            UpdateResponse updateResponse = new UpdateResponse();
            updateResponse.setMarkupContext(markupContext);
            blockingInteractionResponse.setUpdateResponse(updateResponse);
        }
        return blockingInteractionResponse;
    }

    protected Extension[] doReleaseSessions(ReleaseSessions releaseSessions) throws Exception {
        return null;
    }

    protected byte[] getBinaryContent(Http.Options httpOptions) throws Exception {
        HttpSession session = ServletUtil.getSession();
        Cookie[] cookies = (Cookie[])session.getAttribute("COOKIES");
        if (cookies != null) {
            httpOptions.setCookies(cookies);
        }
        byte[] binaryContent = HttpUtil.URLtoByteArray((Http.Options)httpOptions);
        cookies = HttpUtil.getCookies();
        if (cookies != null) {
            session.setAttribute("COOKIES", (Object)cookies);
        }
        return binaryContent;
    }

    protected String getContent(String rawContent, String windowState) throws Exception {
        if (windowState.equals(LiferayWindowState.EXCLUSIVE.toString())) {
            return rawContent;
        }
        String beginPortletContent = "<liferay-wsrp-portlet>";
        String endPortletContent = "</liferay-wsrp-portlet>";
        int x = rawContent.indexOf(beginPortletContent);
        if (x == -1) {
            throw new SystemException("Unable to find <liferay-wsrp-portlet>");
        }
        int offset = beginPortletContent.length();
        int y = rawContent.indexOf(endPortletContent, x);
        if (y == -1) {
            throw new SystemException("Unable to find </liferay-wsrp-portlet>");
        }
        return rawContent.substring(x + offset, y);
    }

    protected Layout getLayout(PortletContext portletContext, WSRPProducer wsrpProducer) throws Exception {
        String portletId;
        List layouts = LayoutLocalServiceUtil.getLayouts((long)wsrpProducer.getGroupId(), (boolean)false, (long)0L, (boolean)false, (int)0, (int)1);
        if (layouts.isEmpty()) {
            throw new NoSuchLayoutException();
        }
        Layout layout = (Layout)layouts.get(0);
        LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
        if (!layoutTypePortlet.hasPortletId(portletId = this.getPortletId(portletContext))) {
            layoutTypePortlet.addPortletId(0L, portletId, "column-1", -1, false);
            LayoutLocalServiceUtil.updateLayout((long)layout.getGroupId(), (boolean)layout.isPrivateLayout(), (long)layout.getLayoutId(), (String)layout.getTypeSettings());
            PortletPreferencesFactoryUtil.getLayoutPortletSetup((Layout)layout, (String)portletId);
        }
        return layout;
    }

    protected String getPortletId(PortletContext portletContext) throws Exception {
        return portletContext.getPortletHandle();
    }

    protected String getPortletId(PortletContext portletContext, NavigationalContext navigationalContext) throws Exception {
        String portletConfigurationPortletId;
        Map parameterMap;
        String portletId = this.getPortletId(portletContext);
        if (navigationalContext == null) {
            return portletId;
        }
        String opaqueValue = navigationalContext.getOpaqueValue();
        if (Validator.isNotNull((String)opaqueValue)) {
            opaqueValue = new String(Base64.decodeFromURL((String)opaqueValue), "UTF-8");
        }
        if ((parameterMap = HttpUtil.parameterMapFromString((String)opaqueValue)).containsKey(PortalUtil.getPortletNamespace((String)(portletConfigurationPortletId = PortletProviderUtil.getPortletId((String)"com.liferay.portlet.configuration.kernel.util.PortletConfigurationApplicationType$PortletConfiguration", (PortletProvider.Action)PortletProvider.Action.VIEW))) + "portletConfiguration")) {
            portletId = portletConfigurationPortletId;
        }
        return portletId;
    }

    protected String getPortletMode(MimeRequest mimeRequest) throws Exception {
        String portletMode = mimeRequest.getMode();
        return portletMode.substring(5);
    }

    protected String getRawContent(Http.Options httpOptions) throws Exception {
        HttpServletRequest request;
        Cookie[] forwardCookies;
        HashMap<String, Cookie> cookiesMap = new HashMap<String, Cookie>();
        HttpSession session = ServletUtil.getSession();
        Cookie[] sessionCookies = (Cookie[])session.getAttribute("COOKIES");
        if (sessionCookies != null) {
            for (Cookie cookie : sessionCookies) {
                cookiesMap.put(cookie.getName(), cookie);
            }
        }
        if ((forwardCookies = (request = ServletUtil.getRequest()).getCookies()) != null) {
            for (Cookie cookie : forwardCookies) {
                String cookieName = cookie.getName();
                if (StringUtil.equalsIgnoreCase((String)cookieName, (String)"cookie_support") || StringUtil.equalsIgnoreCase((String)cookieName, (String)"guest_language_id") || StringUtil.equalsIgnoreCase((String)cookieName, (String)"jsessionid")) continue;
                if (Validator.isNull((String)cookie.getDomain())) {
                    cookie.setDomain(request.getServerName());
                }
                if (Validator.isNull((String)cookie.getPath())) {
                    cookie.setPath("/");
                }
                cookiesMap.put(cookieName, cookie);
            }
        }
        if (!cookiesMap.isEmpty()) {
            Collection cookiesCollection = cookiesMap.values();
            httpOptions.setCookies(cookiesCollection.toArray(new Cookie[0]));
        }
        String rawContent = HttpUtil.URLtoString((Http.Options)httpOptions);
        Cookie[] cookies = HttpUtil.getCookies();
        if (cookies != null) {
            session.setAttribute("COOKIES", (Object)cookies);
        }
        return rawContent;
    }

    protected String getURL(GetMarkup getMarkup, WSRPProducer wsrpProducer) throws Exception {
        return this.getURL("0", null, (MimeRequest)getMarkup.getMarkupParams(), getMarkup.getPortletContext(), wsrpProducer);
    }

    protected String getURL(GetResource getResource, WSRPProducer wsrpProducer) throws Exception {
        ResourceParams resourceParams = getResource.getResourceParams();
        return this.getURL("2", resourceParams.getResourceID(), (MimeRequest)resourceParams, getResource.getPortletContext(), wsrpProducer);
    }

    protected String getURL(PerformBlockingInteraction performBlockingInteraction, WSRPProducer wsrpProducer) throws Exception {
        return this.getURL("1", null, (MimeRequest)performBlockingInteraction.getMarkupParams(), performBlockingInteraction.getPortletContext(), wsrpProducer);
    }

    protected String getURL(String lifecycle, String resourceID, MimeRequest mimeRequest, PortletContext portletContext, WSRPProducer wsrpProducer) throws Exception {
        MessageElement[] formParameters;
        StringBundler sb = new StringBundler();
        String[] locales = mimeRequest.getLocales();
        if (locales.length > 0) {
            sb.append(this.getWidgetPath(locales[0]));
        } else {
            sb.append(this.getWidgetPath());
        }
        sb.append("?");
        String propertiesAuthenticatonTokenSharedSecret = DigesterUtil.digest((String)PropsUtil.get((String)"auth.token.shared.secret"));
        sb.append("p_auth_secret=");
        sb.append(URLCodec.encodeURL((String)propertiesAuthenticatonTokenSharedSecret));
        Layout layout = this.getLayout(portletContext, wsrpProducer);
        sb.append("&p_l_id=");
        sb.append(layout.getPlid());
        NavigationalContext navigationalContext = mimeRequest.getNavigationalContext();
        String portletId = this.getPortletId(portletContext, navigationalContext);
        sb.append("&p_p_id=");
        sb.append(URLCodec.encodeURL((String)portletId));
        sb.append("&p_p_lifecycle=");
        sb.append(lifecycle);
        String windowState = this.getWindowState(mimeRequest);
        sb.append("&p_p_state=");
        sb.append(URLCodec.encodeURL((String)windowState));
        String portletMode = this.getPortletMode(mimeRequest);
        sb.append("&p_p_mode=");
        sb.append(URLCodec.encodeURL((String)portletMode));
        if (lifecycle.equals("2") && Validator.isNotNull((String)resourceID)) {
            sb.append("&p_p_resource_id=");
            sb.append(resourceID);
        }
        sb.append("&p_p_isolated=1");
        String opaqueValue = null;
        if (navigationalContext != null) {
            opaqueValue = navigationalContext.getOpaqueValue();
        }
        if (Validator.isNotNull(opaqueValue)) {
            sb.append("&");
            opaqueValue = new String(Base64.decodeFromURL((String)opaqueValue), "UTF-8");
            sb.append(opaqueValue);
        }
        if (lifecycle.equals("0") && (formParameters = ExtensionHelperUtil.getMessageElements(mimeRequest.getExtensions())) != null) {
            String namespace = PortalUtil.getPortletNamespace((String)portletId);
            for (MessageElement formParameter : formParameters) {
                sb.append("&");
                String name = namespace.concat(ExtensionHelperUtil.getNameAttribute(formParameter));
                sb.append(name);
                sb.append("=");
                sb.append(URLCodec.encodeURL((String)formParameter.getValue()));
            }
        }
        if (windowState.equals(LiferayWindowState.EXCLUSIVE.toString())) {
            sb.append("&ensureContentLength=1");
        }
        sb.append("&wsrp=1");
        if (_log.isInfoEnabled()) {
            _log.info((Object)("URL " + sb.toString()));
        }
        return sb.toString();
    }

    protected String getWidgetPath() {
        return this.getWidgetPath(null);
    }

    protected String getWidgetPath(String languageId) {
        HttpServletRequest request = ServletUtil.getRequest();
        String portalURL = PortalUtil.getPortalURL((HttpServletRequest)request);
        StringBundler sb = new StringBundler(5);
        sb.append(portalURL);
        sb.append(PortalUtil.getPathContext());
        Object[] localesEnabled = PropsUtil.getArray((String)"locales.enabled");
        if (ArrayUtil.contains((Object[])localesEnabled, (Object)languageId)) {
            sb.append("/");
            sb.append(languageId);
        }
        sb.append(_PATH_WIDGET);
        return sb.toString();
    }

    protected String getWindowState(MimeRequest mimeRequest) throws Exception {
        String windowState = mimeRequest.getWindowState();
        return windowState.substring(5);
    }

    protected void processUploadContexts(UploadContext[] uploadContexts, Http.Options httpOptions) {
        if (uploadContexts == null) {
            return;
        }
        for (UploadContext uploadContext : uploadContexts) {
            NamedString mimeAttribute = uploadContext.getMimeAttributes(0);
            String[] mimeAttributeValues = StringUtil.split((String)mimeAttribute.getValue(), (String)";");
            String name = StringUtil.replace((String)mimeAttributeValues[1], (String)"name=", (String)"");
            name = StringUtil.trim((String)name);
            String fileName = StringUtil.replace((String)mimeAttributeValues[2], (String)"filename=", (String)"");
            fileName = StringUtil.trim((String)fileName);
            String contentType = uploadContext.getMimeType();
            String charSet = null;
            if (contentType.contains(";")) {
                int pos = contentType.indexOf(";");
                charSet = contentType.substring(pos + 1);
                charSet = StringUtil.trim((String)charSet);
                contentType = contentType.substring(0, pos);
            }
            httpOptions.addFilePart(name, fileName, uploadContext.getUploadData(), contentType, charSet);
        }
    }
}

