/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.impl;

import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.service.permission.ModelPermissions;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.NotificationThreadLocal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.zip.ZipReaderFactory;
import com.liferay.subscription.service.SubscriptionLocalService;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.exception.RestoreEntryException;
import com.liferay.trash.exception.TrashEntryException;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.exception.DuplicateNodeNameException;
import com.liferay.wiki.exception.NodeNameException;
import com.liferay.wiki.internal.importer.MediaWikiImporter;
import com.liferay.wiki.internal.util.WikiCacheThreadLocal;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.model.WikiPageDisplay;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.base.WikiNodeLocalServiceBaseImpl;
import com.liferay.wiki.service.persistence.WikiPagePersistence;
import com.liferay.wiki.validator.WikiPageTitleValidator;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.wiki.configuration.WikiGroupServiceConfiguration"}, property={"model.class.name=com.liferay.wiki.model.WikiNode"}, service={AopService.class})
public class WikiNodeLocalServiceImpl
extends WikiNodeLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(WikiNodeLocalServiceImpl.class);
    @Reference
    private AssetTagLocalService _assetTagLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;
    private MediaWikiImporter _mediaWikiImporter;
    @Reference
    private MultiVMPool _multiVMPool;
    private PortalCache<?, ?> _portalCache;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashHelper _trashHelper;
    @Reference
    private UserLocalService _userLocalService;
    private WikiGroupServiceConfiguration _wikiGroupServiceConfiguration;
    @Reference
    private WikiPageLocalService _wikiPageLocalService;
    @Reference
    private WikiPagePersistence _wikiPagePersistence;
    @Reference
    private WikiPageTitleValidator _wikiPageTitleValidator;
    @Reference
    private ZipReaderFactory _zipReaderFactory;

    public WikiNode addDefaultNode(long userId, ServiceContext serviceContext) throws PortalException {
        return this.addNode(userId, this._wikiGroupServiceConfiguration.initialNodeName(), "", serviceContext);
    }

    @Deprecated
    @Indexable(type=IndexableType.REINDEX)
    public WikiNode addNode(long userId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this.addNode(null, userId, name, description, serviceContext);
    }

    @Indexable(type=IndexableType.REINDEX)
    public WikiNode addNode(String externalReferenceCode, long userId, String name, String description, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        long groupId = serviceContext.getScopeGroupId();
        this._validate(groupId, name);
        long nodeId = this.counterLocalService.increment();
        WikiNode node = this.wikiNodePersistence.create(nodeId);
        node.setUuid(serviceContext.getUuid());
        node.setExternalReferenceCode(externalReferenceCode);
        node.setGroupId(groupId);
        node.setCompanyId(user.getCompanyId());
        node.setUserId(user.getUserId());
        node.setUserName(user.getFullName());
        node.setName(name);
        node.setDescription(description);
        try {
            node = (WikiNode)this.wikiNodePersistence.update((BaseModel)node);
        }
        catch (SystemException systemException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Add failed, fetch {groupId=", groupId, ", name=", name, "}"}));
            }
            if ((node = this.wikiNodePersistence.fetchByG_N(groupId, name, false)) == null) {
                throw systemException;
            }
            return node;
        }
        if (serviceContext.isAddGroupPermissions() || serviceContext.isAddGuestPermissions()) {
            this.addNodeResources(node, serviceContext.isAddGroupPermissions(), serviceContext.isAddGuestPermissions());
        } else {
            this.addNodeResources(node, serviceContext.getModelPermissions());
        }
        return node;
    }

    public void addNodeResources(long nodeId, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.addNodeResources(node, addGroupPermissions, addGuestPermissions);
    }

    public void addNodeResources(WikiNode node, boolean addGroupPermissions, boolean addGuestPermissions) throws PortalException {
        this._resourceLocalService.addResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), false, addGroupPermissions, addGuestPermissions);
    }

    public void addNodeResources(WikiNode node, ModelPermissions modelPermissions) throws PortalException {
        this._resourceLocalService.addModelResources(node.getCompanyId(), node.getGroupId(), node.getUserId(), WikiNode.class.getName(), node.getNodeId(), modelPermissions);
    }

    public void deleteNode(long nodeId) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this.wikiNodeLocalService.deleteNode(node);
    }

    @SystemEvent(action=1, type=1)
    public void deleteNode(WikiNode node) throws PortalException {
        boolean clearCache = WikiCacheThreadLocal.isClearCache();
        try {
            WikiCacheThreadLocal.setClearCache(false);
            this._wikiPageLocalService.deletePages(node.getNodeId());
        }
        finally {
            WikiCacheThreadLocal.setClearCache(clearCache);
            this._portalCache.removeAll();
        }
        this.wikiNodePersistence.remove((BaseModel)node);
        this._resourceLocalService.deleteResource(node.getCompanyId(), WikiNode.class.getName(), 4, node.getNodeId());
        long folderId = node.getAttachmentsFolderId();
        if (folderId != 0L) {
            this._portletFileRepository.deletePortletFolder(folderId);
        }
        this._subscriptionLocalService.deleteSubscriptions(node.getCompanyId(), WikiNode.class.getName(), node.getNodeId());
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(WikiNode.class);
        indexer.delete((Object)node);
        if (node.isInTrash()) {
            node.setName(this._trashHelper.getOriginalTitle(node.getName()));
            this._trashEntryLocalService.deleteEntry(WikiNode.class.getName(), node.getNodeId());
        }
    }

    public void deleteNodes(long groupId) throws PortalException {
        List nodes = this.wikiNodePersistence.findByGroupId(groupId);
        for (WikiNode node : nodes) {
            this.wikiNodeLocalService.deleteNode(node);
        }
        this._portletFileRepository.deletePortletRepository(groupId, "com.liferay.wiki");
    }

    public WikiNode fetchNode(long groupId, String name) {
        return this.wikiNodePersistence.fetchByG_N(groupId, name);
    }

    public WikiNode fetchNodeByUuidAndGroupId(String uuid, long groupId) {
        return this.wikiNodePersistence.fetchByUUID_G(uuid, groupId);
    }

    public List<WikiNode> getCompanyNodes(long companyId, int start, int end) {
        return this.wikiNodePersistence.findByC_S(companyId, 0, start, end);
    }

    public List<WikiNode> getCompanyNodes(long companyId, int status, int start, int end) {
        return this.wikiNodePersistence.findByC_S(companyId, status, start, end);
    }

    public int getCompanyNodesCount(long companyId) {
        return this.wikiNodePersistence.countByC_S(companyId, 0);
    }

    public int getCompanyNodesCount(long companyId, int status) {
        return this.wikiNodePersistence.countByC_S(companyId, status);
    }

    public WikiNode getNode(long nodeId) throws PortalException {
        return this.wikiNodePersistence.findByPrimaryKey(nodeId);
    }

    public WikiNode getNode(long groupId, String nodeName) throws PortalException {
        return this.wikiNodePersistence.findByG_N(groupId, nodeName);
    }

    public List<WikiNode> getNodes(long groupId) throws PortalException {
        return this.getNodes(groupId, 0);
    }

    public List<WikiNode> getNodes(long groupId, int status) throws PortalException {
        List<WikiNode> nodes = this.wikiNodePersistence.findByG_S(groupId, status);
        if (nodes.isEmpty()) {
            nodes = this._addDefaultNode(groupId);
        }
        return nodes;
    }

    public List<WikiNode> getNodes(long groupId, int start, int end) throws PortalException {
        return this.getNodes(groupId, 0, start, end);
    }

    public List<WikiNode> getNodes(long groupId, int status, int start, int end) throws PortalException {
        List<WikiNode> nodes = this.wikiNodePersistence.findByG_S(groupId, status, start, end);
        if (nodes.isEmpty()) {
            nodes = this._addDefaultNode(groupId);
        }
        return nodes;
    }

    public int getNodesCount(long groupId) {
        return this.wikiNodePersistence.countByG_S(groupId, 0);
    }

    public int getNodesCount(long groupId, int status) {
        return this.wikiNodePersistence.countByG_S(groupId, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPages(long userId, long nodeId, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException {
        WikiNode node = this.getNode(nodeId);
        boolean notificationsEnabled = NotificationThreadLocal.isEnabled();
        boolean clearCache = WikiCacheThreadLocal.isClearCache();
        try {
            NotificationThreadLocal.setEnabled((boolean)false);
            WikiCacheThreadLocal.setClearCache(false);
            this._mediaWikiImporter.importPages(userId, node, inputStreams, options);
        }
        finally {
            NotificationThreadLocal.setEnabled((boolean)notificationsEnabled);
            WikiCacheThreadLocal.setClearCache(clearCache);
            this._portalCache.removeAll();
        }
    }

    public WikiNode moveNodeToTrash(long userId, long nodeId) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        return this.moveNodeToTrash(userId, node);
    }

    public WikiNode moveNodeToTrash(long userId, WikiNode node) throws PortalException {
        if (node.isInTrash()) {
            throw new TrashEntryException();
        }
        int oldStatus = node.getStatus();
        node = this.updateStatus(userId, node, 8, new ServiceContext());
        TrashEntry trashEntry = this._trashEntryLocalService.addTrashEntry(userId, node.getGroupId(), WikiNode.class.getName(), node.getNodeId(), node.getUuid(), null, oldStatus, null, UnicodePropertiesBuilder.put((String)"title", (String)node.getName()).build());
        node.setName(this._trashHelper.getTrashTitle(trashEntry.getEntryId()));
        node = (WikiNode)this.wikiNodePersistence.update((BaseModel)node);
        this._moveDependentsToTrash(node.getNodeId(), trashEntry.getEntryId());
        return node;
    }

    public void restoreNodeFromTrash(long userId, WikiNode node) throws PortalException {
        if (!node.isInTrash()) {
            throw new RestoreEntryException(4);
        }
        node.setName(this._trashHelper.getOriginalTitle(node.getName()));
        node = (WikiNode)this.wikiNodePersistence.update((BaseModel)node);
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(WikiNode.class.getName(), node.getNodeId());
        this.updateStatus(userId, node, trashEntry.getStatus(), new ServiceContext());
        this._restoreDependentsFromTrash(userId, node.getNodeId());
        this._trashEntryLocalService.deleteEntry(trashEntry);
    }

    public void subscribeNode(long userId, long nodeId) throws PortalException {
        WikiNode node = this.getNode(nodeId);
        this._subscriptionLocalService.addSubscription(userId, node.getGroupId(), WikiNode.class.getName(), nodeId);
    }

    public void unsubscribeNode(long userId, long nodeId) throws PortalException {
        this._subscriptionLocalService.deleteSubscription(userId, WikiNode.class.getName(), nodeId);
    }

    public WikiNode updateNode(long nodeId, String name, String description, ServiceContext serviceContext) throws PortalException {
        WikiNode node = this.wikiNodePersistence.findByPrimaryKey(nodeId);
        this._validate(nodeId, node.getGroupId(), name);
        node.setName(name);
        node.setDescription(description);
        return (WikiNode)this.wikiNodePersistence.update((BaseModel)node);
    }

    public WikiNode updateStatus(long userId, WikiNode node, int status, ServiceContext serviceContext) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        node.setStatus(status);
        node.setStatusByUserId(userId);
        node.setStatusByUserName(user.getFullName());
        node.setStatusDate(new Date());
        node = (WikiNode)this.wikiNodePersistence.update((BaseModel)node);
        Indexer indexer = this._indexerRegistry.nullSafeGetIndexer(WikiNode.class);
        indexer.reindex((Object)node);
        return node;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._wikiGroupServiceConfiguration = (WikiGroupServiceConfiguration)ConfigurableUtil.createConfigurable(WikiGroupServiceConfiguration.class, properties);
        this._mediaWikiImporter = new MediaWikiImporter(this._assetTagLocalService, this._companyLocalService, this._portletFileRepository, this._userLocalService, this._wikiGroupServiceConfiguration, this._wikiPageLocalService, this._wikiPageTitleValidator, this._zipReaderFactory);
        this._portalCache = this._multiVMPool.getPortalCache(WikiPageDisplay.class.getName());
    }

    private List<WikiNode> _addDefaultNode(long groupId) throws PortalException {
        Group group = this._groupLocalService.getGroup(groupId);
        long guestUserId = this._userLocalService.getGuestUserId(group.getCompanyId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        WikiNode node = this.wikiNodeLocalService.addDefaultNode(guestUserId, serviceContext);
        return ListUtil.fromArray((Object[])new WikiNode[]{node});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _moveDependentsToTrash(long nodeId, long trashEntryId) throws PortalException {
        boolean clearCache = WikiCacheThreadLocal.isClearCache();
        try {
            WikiCacheThreadLocal.setClearCache(false);
            List pages = this._wikiPagePersistence.findByN_H(nodeId, true);
            for (WikiPage page : pages) {
                this._wikiPageLocalService.moveDependentToTrash(page, trashEntryId);
            }
        }
        finally {
            WikiCacheThreadLocal.setClearCache(clearCache);
            this._portalCache.removeAll();
        }
    }

    private void _restoreDependentsFromTrash(long userId, long nodeId) throws PortalException {
        List pages = this._wikiPagePersistence.findByN_H(nodeId, true);
        for (WikiPage page : pages) {
            if (!this._trashHelper.isInTrashImplicitly((TrashedModel)page)) continue;
            this._wikiPageLocalService.restorePageFromTrash(userId, page);
        }
    }

    private void _validate(long nodeId, long groupId, String name) throws PortalException {
        if (StringUtil.equalsIgnoreCase((String)name, (String)"tag")) {
            throw new NodeNameException(name + " is reserved");
        }
        if (Validator.isNull((String)name)) {
            throw new NodeNameException();
        }
        if (Validator.isNumber((String)name)) {
            throw new NodeNameException("Node name cannot be a number");
        }
        WikiNode node = this.wikiNodePersistence.fetchByG_N(groupId, name);
        if (node != null && node.getNodeId() != nodeId) {
            throw new DuplicateNodeNameException("{nodeId=" + nodeId + "}");
        }
    }

    private void _validate(long groupId, String name) throws PortalException {
        this._validate(0L, groupId, name);
    }
}

