/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageServiceUtil;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;

public class WikiPageServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(WikiPageServiceHttp.class);
    private static final Class<?>[] _addPageParameterTypes0 = new Class[]{Long.TYPE, String.class, String.class, String.class, Boolean.TYPE, ServiceContext.class};
    private static final Class<?>[] _addPageParameterTypes1 = new Class[]{Long.TYPE, String.class, String.class, String.class, Boolean.TYPE, String.class, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _addPageParameterTypes2 = new Class[]{String.class, Long.TYPE, String.class, Double.TYPE, String.class, String.class, Boolean.TYPE, String.class, Boolean.TYPE, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _addPageParameterTypes3 = new Class[]{String.class, Long.TYPE, String.class, String.class, String.class, Boolean.TYPE, String.class, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _addPageAttachmentParameterTypes4 = new Class[]{Long.TYPE, String.class, String.class, File.class, String.class};
    private static final Class<?>[] _addPageAttachmentParameterTypes5 = new Class[]{Long.TYPE, String.class, String.class, InputStream.class, String.class};
    private static final Class<?>[] _addPageAttachmentsParameterTypes6 = new Class[]{Long.TYPE, String.class, List.class};
    private static final Class<?>[] _addTempFileEntryParameterTypes7 = new Class[]{Long.TYPE, String.class, String.class, InputStream.class, String.class};
    private static final Class<?>[] _changeParentParameterTypes8 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _copyPageAttachmentsParameterTypes9 = new Class[]{Long.TYPE, String.class, Long.TYPE, String.class};
    private static final Class<?>[] _deletePageParameterTypes10 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _deletePageAttachmentParameterTypes11 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _deletePageAttachmentsParameterTypes12 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _deleteTempFileEntryParameterTypes13 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _deleteTrashPageAttachmentsParameterTypes14 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _discardDraftParameterTypes15 = new Class[]{Long.TYPE, String.class, Double.TYPE};
    private static final Class<?>[] _fetchLatestPageByExternalReferenceCodeParameterTypes16 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _fetchPageParameterTypes17 = new Class[]{Long.TYPE, String.class, Double.TYPE};
    private static final Class<?>[] _getChildrenParameterTypes18 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE, String.class};
    private static final Class<?>[] _getDraftPageParameterTypes19 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getLatestPageByExternalReferenceCodeParameterTypes20 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getNodePagesParameterTypes21 = new Class[]{Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _getNodePagesRSSParameterTypes22 = new Class[]{Long.TYPE, Integer.TYPE, String.class, Double.TYPE, String.class, String.class, String.class, String.class};
    private static final Class<?>[] _getOrphansParameterTypes23 = new Class[]{WikiNode.class};
    private static final Class<?>[] _getPageParameterTypes24 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getPageParameterTypes25 = new Class[]{Long.TYPE, Long.TYPE, String.class};
    private static final Class<?>[] _getPageParameterTypes26 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getPageParameterTypes27 = new Class[]{Long.TYPE, String.class, Boolean.class};
    private static final Class<?>[] _getPageParameterTypes28 = new Class[]{Long.TYPE, String.class, Double.TYPE};
    private static final Class<?>[] _getPageByPageIdParameterTypes29 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getPagesParameterTypes30 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getPagesParameterTypes31 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getPagesParameterTypes32 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getPagesCountParameterTypes33 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE};
    private static final Class<?>[] _getPagesCountParameterTypes34 = new Class[]{Long.TYPE, Long.TYPE, Boolean.TYPE, Long.TYPE, Boolean.TYPE, Integer.TYPE};
    private static final Class<?>[] _getPagesCountParameterTypes35 = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _getPagesRSSParameterTypes36 = new Class[]{Long.TYPE, String.class, Integer.TYPE, String.class, Double.TYPE, String.class, String.class, String.class, String.class, Locale.class};
    private static final Class<?>[] _getRecentChangesParameterTypes37 = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getRecentChangesCountParameterTypes38 = new Class[]{Long.TYPE, Long.TYPE};
    private static final Class<?>[] _getTempFileNamesParameterTypes39 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _movePageAttachmentToTrashParameterTypes40 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _movePageToTrashParameterTypes41 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _movePageToTrashParameterTypes42 = new Class[]{Long.TYPE, String.class, Double.TYPE};
    private static final Class<?>[] _renamePageParameterTypes43 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _restorePageAttachmentFromTrashParameterTypes44 = new Class[]{Long.TYPE, String.class, String.class};
    private static final Class<?>[] _restorePageFromTrashParameterTypes45 = new Class[]{Long.TYPE};
    private static final Class<?>[] _revertPageParameterTypes46 = new Class[]{Long.TYPE, String.class, Double.TYPE, ServiceContext.class};
    private static final Class<?>[] _subscribePageParameterTypes47 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _unsubscribePageParameterTypes48 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _updatePageParameterTypes49 = new Class[]{Long.TYPE, String.class, Double.TYPE, String.class, String.class, Boolean.TYPE, String.class, String.class, String.class, ServiceContext.class};

    public static WikiPage addPage(HttpPrincipal httpPrincipal, long nodeId, String title, String content, String summary, boolean minorEdit, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "addPage", (Class[])_addPageParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, content, summary, minorEdit, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage addPage(HttpPrincipal httpPrincipal, long nodeId, String title, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "addPage", (Class[])_addPageParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage addPage(HttpPrincipal httpPrincipal, String externalReferenceCode, long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, boolean head, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "addPage", (Class[])_addPageParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{externalReferenceCode, nodeId, title, version, content, summary, minorEdit, format, head, parentTitle, redirectTitle, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage addPage(HttpPrincipal httpPrincipal, String externalReferenceCode, long nodeId, String title, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "addPage", (Class[])_addPageParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{externalReferenceCode, nodeId, title, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static FileEntry addPageAttachment(HttpPrincipal httpPrincipal, long nodeId, String title, String fileName, File file, String mimeType) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "addPageAttachment", (Class[])_addPageAttachmentParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, fileName, file, mimeType});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (FileEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static FileEntry addPageAttachment(HttpPrincipal httpPrincipal, long nodeId, String title, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "addPageAttachment", (Class[])_addPageAttachmentParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, fileName, inputStream, mimeType});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (FileEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<FileEntry> addPageAttachments(HttpPrincipal httpPrincipal, long nodeId, String title, List<ObjectValuePair<String, InputStream>> inputStreamOVPs) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "addPageAttachments", (Class[])_addPageAttachmentsParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, inputStreamOVPs});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static FileEntry addTempFileEntry(HttpPrincipal httpPrincipal, long nodeId, String folderName, String fileName, InputStream inputStream, String mimeType) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "addTempFileEntry", (Class[])_addTempFileEntryParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, folderName, fileName, inputStream, mimeType});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (FileEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void changeParent(HttpPrincipal httpPrincipal, long nodeId, String title, String newParentTitle, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "changeParent", (Class[])_changeParentParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, newParentTitle, serviceContext});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void copyPageAttachments(HttpPrincipal httpPrincipal, long templateNodeId, String templateTitle, long nodeId, String title) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "copyPageAttachments", (Class[])_copyPageAttachmentsParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{templateNodeId, templateTitle, nodeId, title});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deletePage(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "deletePage", (Class[])_deletePageParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deletePageAttachment(HttpPrincipal httpPrincipal, long nodeId, String title, String fileName) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "deletePageAttachment", (Class[])_deletePageAttachmentParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, fileName});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deletePageAttachments(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "deletePageAttachments", (Class[])_deletePageAttachmentsParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteTempFileEntry(HttpPrincipal httpPrincipal, long nodeId, String folderName, String fileName) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "deleteTempFileEntry", (Class[])_deleteTempFileEntryParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, folderName, fileName});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteTrashPageAttachments(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "deleteTrashPageAttachments", (Class[])_deleteTrashPageAttachmentsParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void discardDraft(HttpPrincipal httpPrincipal, long nodeId, String title, double version) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "discardDraft", (Class[])_discardDraftParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, version});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage fetchLatestPageByExternalReferenceCode(HttpPrincipal httpPrincipal, long groupId, String externalReferenceCode) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "fetchLatestPageByExternalReferenceCode", (Class[])_fetchLatestPageByExternalReferenceCodeParameterTypes16);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, externalReferenceCode});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage fetchPage(HttpPrincipal httpPrincipal, long nodeId, String title, double version) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "fetchPage", (Class[])_fetchPageParameterTypes17);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, version});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiPage> getChildren(HttpPrincipal httpPrincipal, long groupId, long nodeId, boolean head, String parentTitle) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getChildren", (Class[])_getChildrenParameterTypes18);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, nodeId, head, parentTitle});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage getDraftPage(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getDraftPage", (Class[])_getDraftPageParameterTypes19);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage getLatestPageByExternalReferenceCode(HttpPrincipal httpPrincipal, long groupId, String externalReferenceCode) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getLatestPageByExternalReferenceCode", (Class[])_getLatestPageByExternalReferenceCodeParameterTypes20);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, externalReferenceCode});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiPage> getNodePages(HttpPrincipal httpPrincipal, long nodeId, int max) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getNodePages", (Class[])_getNodePagesParameterTypes21);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, max});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static String getNodePagesRSS(HttpPrincipal httpPrincipal, long nodeId, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getNodePagesRSS", (Class[])_getNodePagesRSSParameterTypes22);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, max, type, version, displayStyle, feedURL, entryURL, attachmentURLPrefix});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (String)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiPage> getOrphans(HttpPrincipal httpPrincipal, WikiNode node) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getOrphans", (Class[])_getOrphansParameterTypes23);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{node});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage getPage(HttpPrincipal httpPrincipal, long pageId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPage", (Class[])_getPageParameterTypes24);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{pageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage getPage(HttpPrincipal httpPrincipal, long groupId, long nodeId, String title) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPage", (Class[])_getPageParameterTypes25);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, nodeId, title});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage getPage(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPage", (Class[])_getPageParameterTypes26);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage getPage(HttpPrincipal httpPrincipal, long nodeId, String title, Boolean head) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPage", (Class[])_getPageParameterTypes27);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, head});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage getPage(HttpPrincipal httpPrincipal, long nodeId, String title, double version) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPage", (Class[])_getPageParameterTypes28);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, version});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage getPageByPageId(HttpPrincipal httpPrincipal, long pageId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPageByPageId", (Class[])_getPageByPageIdParameterTypes29);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{pageId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiPage> getPages(HttpPrincipal httpPrincipal, long groupId, long nodeId, boolean head, int status, int start, int end, OrderByComparator<WikiPage> orderByComparator) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPages", (Class[])_getPagesParameterTypes30);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, nodeId, head, status, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiPage> getPages(HttpPrincipal httpPrincipal, long groupId, long nodeId, boolean head, long userId, boolean includeOwner, int status, int start, int end, OrderByComparator<WikiPage> orderByComparator) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPages", (Class[])_getPagesParameterTypes31);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, nodeId, head, userId, includeOwner, status, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiPage> getPages(HttpPrincipal httpPrincipal, long groupId, long userId, long nodeId, int status, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPages", (Class[])_getPagesParameterTypes32);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, nodeId, status, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getPagesCount(HttpPrincipal httpPrincipal, long groupId, long nodeId, boolean head) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPagesCount", (Class[])_getPagesCountParameterTypes33);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, nodeId, head});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getPagesCount(HttpPrincipal httpPrincipal, long groupId, long nodeId, boolean head, long userId, boolean includeOwner, int status) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPagesCount", (Class[])_getPagesCountParameterTypes34);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, nodeId, head, userId, includeOwner, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getPagesCount(HttpPrincipal httpPrincipal, long groupId, long userId, long nodeId, int status) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPagesCount", (Class[])_getPagesCountParameterTypes35);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, userId, nodeId, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static String getPagesRSS(HttpPrincipal httpPrincipal, long nodeId, String title, int max, String type, double version, String displayStyle, String feedURL, String entryURL, String attachmentURLPrefix, Locale locale) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getPagesRSS", (Class[])_getPagesRSSParameterTypes36);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, max, type, version, displayStyle, feedURL, entryURL, attachmentURLPrefix, locale});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (String)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiPage> getRecentChanges(HttpPrincipal httpPrincipal, long groupId, long nodeId, int start, int end) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getRecentChanges", (Class[])_getRecentChangesParameterTypes37);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, nodeId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getRecentChangesCount(HttpPrincipal httpPrincipal, long groupId, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getRecentChangesCount", (Class[])_getRecentChangesCountParameterTypes38);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, nodeId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static String[] getTempFileNames(HttpPrincipal httpPrincipal, long nodeId, String folderName) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "getTempFileNames", (Class[])_getTempFileNamesParameterTypes39);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, folderName});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (String[])returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static FileEntry movePageAttachmentToTrash(HttpPrincipal httpPrincipal, long nodeId, String title, String fileName) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "movePageAttachmentToTrash", (Class[])_movePageAttachmentToTrashParameterTypes40);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, fileName});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (FileEntry)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage movePageToTrash(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "movePageToTrash", (Class[])_movePageToTrashParameterTypes41);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage movePageToTrash(HttpPrincipal httpPrincipal, long nodeId, String title, double version) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "movePageToTrash", (Class[])_movePageToTrashParameterTypes42);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, version});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void renamePage(HttpPrincipal httpPrincipal, long nodeId, String title, String newTitle, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "renamePage", (Class[])_renamePageParameterTypes43);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, newTitle, serviceContext});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void restorePageAttachmentFromTrash(HttpPrincipal httpPrincipal, long nodeId, String title, String fileName) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "restorePageAttachmentFromTrash", (Class[])_restorePageAttachmentFromTrashParameterTypes44);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, fileName});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void restorePageFromTrash(HttpPrincipal httpPrincipal, long resourcePrimKey) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "restorePageFromTrash", (Class[])_restorePageFromTrashParameterTypes45);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{resourcePrimKey});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage revertPage(HttpPrincipal httpPrincipal, long nodeId, String title, double version, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "revertPage", (Class[])_revertPageParameterTypes46);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, version, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void subscribePage(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "subscribePage", (Class[])_subscribePageParameterTypes47);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void unsubscribePage(HttpPrincipal httpPrincipal, long nodeId, String title) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "unsubscribePage", (Class[])_unsubscribePageParameterTypes48);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiPage updatePage(HttpPrincipal httpPrincipal, long nodeId, String title, double version, String content, String summary, boolean minorEdit, String format, String parentTitle, String redirectTitle, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiPageServiceUtil.class, "updatePage", (Class[])_updatePageParameterTypes49);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, title, version, content, summary, minorEdit, format, parentTitle, redirectTitle, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiPage)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

