/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.http;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.service.WikiNodeServiceUtil;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class WikiNodeServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(WikiNodeServiceHttp.class);
    private static final Class<?>[] _addNodeParameterTypes0 = new Class[]{String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _addNodeParameterTypes1 = new Class[]{String.class, String.class, String.class, ServiceContext.class};
    private static final Class<?>[] _deleteNodeParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getNodeParameterTypes3 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getNodeParameterTypes4 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getNodesParameterTypes5 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getNodesParameterTypes6 = new Class[]{Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _getNodesParameterTypes7 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getNodesParameterTypes8 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
    private static final Class<?>[] _getNodesParameterTypes9 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getNodesCountParameterTypes10 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getNodesCountParameterTypes11 = new Class[]{Long.TYPE, Integer.TYPE};
    private static final Class<?>[] _getWikiNodeByExternalReferenceCodeParameterTypes12 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _importPagesParameterTypes13 = new Class[]{Long.TYPE, InputStream[].class, Map.class};
    private static final Class<?>[] _moveNodeToTrashParameterTypes14 = new Class[]{Long.TYPE};
    private static final Class<?>[] _restoreNodeFromTrashParameterTypes15 = new Class[]{Long.TYPE};
    private static final Class<?>[] _subscribeNodeParameterTypes16 = new Class[]{Long.TYPE};
    private static final Class<?>[] _unsubscribeNodeParameterTypes17 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateNodeParameterTypes18 = new Class[]{Long.TYPE, String.class, String.class, ServiceContext.class};

    public static WikiNode addNode(HttpPrincipal httpPrincipal, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "addNode", (Class[])_addNodeParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiNode addNode(HttpPrincipal httpPrincipal, String externalReferenceCode, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "addNode", (Class[])_addNodeParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{externalReferenceCode, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void deleteNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "deleteNode", (Class[])_deleteNodeParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiNode getNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNode", (Class[])_getNodeParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiNode getNode(HttpPrincipal httpPrincipal, long groupId, String name) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNode", (Class[])_getNodeParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, name});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiNode> getNodes(HttpPrincipal httpPrincipal, long groupId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodes", (Class[])_getNodesParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiNode> getNodes(HttpPrincipal httpPrincipal, long groupId, int status) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodes", (Class[])_getNodesParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiNode> getNodes(HttpPrincipal httpPrincipal, long groupId, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodes", (Class[])_getNodesParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiNode> getNodes(HttpPrincipal httpPrincipal, long groupId, int status, int start, int end) {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodes", (Class[])_getNodesParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, status, start, end});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<WikiNode> getNodes(HttpPrincipal httpPrincipal, long groupId, int status, int start, int end, OrderByComparator<WikiNode> orderByComparator) {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodes", (Class[])_getNodesParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, status, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getNodesCount(HttpPrincipal httpPrincipal, long groupId) {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodesCount", (Class[])_getNodesCountParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getNodesCount(HttpPrincipal httpPrincipal, long groupId, int status) {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getNodesCount", (Class[])_getNodesCountParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, status});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiNode getWikiNodeByExternalReferenceCode(HttpPrincipal httpPrincipal, long groupId, String externalReferenceCode) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "getWikiNodeByExternalReferenceCode", (Class[])_getWikiNodeByExternalReferenceCodeParameterTypes12);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{groupId, externalReferenceCode});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void importPages(HttpPrincipal httpPrincipal, long nodeId, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "importPages", (Class[])_importPagesParameterTypes13);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, inputStreams, options});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiNode moveNodeToTrash(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "moveNodeToTrash", (Class[])_moveNodeToTrashParameterTypes14);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void restoreNodeFromTrash(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "restoreNodeFromTrash", (Class[])_restoreNodeFromTrashParameterTypes15);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void subscribeNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "subscribeNode", (Class[])_subscribeNodeParameterTypes16);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static void unsubscribeNode(HttpPrincipal httpPrincipal, long nodeId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "unsubscribeNode", (Class[])_unsubscribeNodeParameterTypes17);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId});
            try {
                TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static WikiNode updateNode(HttpPrincipal httpPrincipal, long nodeId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(WikiNodeServiceUtil.class, "updateNode", (Class[])_updateNodeParameterTypes18);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{nodeId, name, description, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (WikiNode)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

