/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Conjunction;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Disjunction;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.ProjectionFactoryUtil;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.service.persistence.WikiPageFinder;
import com.liferay.wiki.service.persistence.WikiPagePersistence;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class WikiPageLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
WikiPageLocalService {
    protected WikiPageLocalService wikiPageLocalService;
    @Reference
    protected WikiPagePersistence wikiPagePersistence;
    @Reference
    protected WikiPageFinder wikiPageFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(WikiPageLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public WikiPage addWikiPage(WikiPage wikiPage) {
        wikiPage.setNew(true);
        return (WikiPage)this.wikiPagePersistence.update((BaseModel)wikiPage);
    }

    @Transactional(enabled=false)
    public WikiPage createWikiPage(long pageId) {
        return this.wikiPagePersistence.create(pageId);
    }

    @Indexable(type=IndexableType.DELETE)
    public WikiPage deleteWikiPage(long pageId) throws PortalException {
        return this.wikiPagePersistence.remove(pageId);
    }

    @Indexable(type=IndexableType.DELETE)
    public WikiPage deleteWikiPage(WikiPage wikiPage) {
        return (WikiPage)this.wikiPagePersistence.remove((BaseModel)wikiPage);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.wikiPagePersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(WikiPage.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.wikiPagePersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.wikiPagePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.wikiPagePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.wikiPagePersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.wikiPagePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public WikiPage fetchWikiPage(long pageId) {
        return this.wikiPagePersistence.fetchByPrimaryKey(pageId);
    }

    public WikiPage fetchWikiPageByUuidAndGroupId(String uuid, long groupId) {
        return this.wikiPagePersistence.fetchByUUID_G(uuid, groupId);
    }

    public WikiPage getWikiPage(long pageId) throws PortalException {
        return this.wikiPagePersistence.findByPrimaryKey(pageId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.wikiPageLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(WikiPage.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("pageId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.wikiPageLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(WikiPage.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("pageId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.wikiPageLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(WikiPage.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("pageId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }

            protected Projection getCountProjection() {
                return ProjectionFactoryUtil.countDistinct((String)"resourcePrimKey");
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                Disjunction disjunction;
                Criterion modifiedDateCriterion = portletDataContext.getDateRangeCriteria("modifiedDate");
                if (modifiedDateCriterion != null) {
                    Conjunction conjunction = RestrictionsFactoryUtil.conjunction();
                    conjunction.add(modifiedDateCriterion);
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(RestrictionsFactoryUtil.gtProperty((String)"modifiedDate", (String)"lastPublishDate"));
                    Property lastPublishDateProperty = PropertyFactoryUtil.forName((String)"lastPublishDate");
                    disjunction.add(lastPublishDateProperty.isNull());
                    conjunction.add((Criterion)disjunction);
                    modifiedDateCriterion = conjunction;
                }
                Criterion statusDateCriterion = portletDataContext.getDateRangeCriteria("statusDate");
                if (modifiedDateCriterion != null && statusDateCriterion != null) {
                    disjunction = RestrictionsFactoryUtil.disjunction();
                    disjunction.add(modifiedDateCriterion);
                    disjunction.add(statusDateCriterion);
                    dynamicQuery.add((Criterion)disjunction);
                }
                Property workflowStatusProperty = PropertyFactoryUtil.forName((String)"status");
                if (portletDataContext.isInitialPublication()) {
                    dynamicQuery.add(workflowStatusProperty.ne((Object)8));
                } else {
                    StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)WikiPage.class.getName());
                    dynamicQuery.add(workflowStatusProperty.in(stagedModelDataHandler.getExportableStatuses()));
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setGroupId(portletDataContext.getScopeGroupId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<WikiPage>(){

            public void performAction(WikiPage wikiPage) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)wikiPage);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)WikiPage.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.wikiPagePersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement WikiPageLocalServiceImpl#deleteWikiPage(WikiPage) to avoid orphaned data");
        }
        return this.wikiPageLocalService.deleteWikiPage((WikiPage)persistedModel);
    }

    public BasePersistence<WikiPage> getBasePersistence() {
        return this.wikiPagePersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.wikiPagePersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<? extends PersistedModel> getPersistedModel(long resourcePrimKey) throws PortalException {
        return this.wikiPagePersistence.findByResourcePrimKey(resourcePrimKey);
    }

    public List<WikiPage> getWikiPagesByUuidAndCompanyId(String uuid, long companyId) {
        return this.wikiPagePersistence.findByUuid_C(uuid, companyId);
    }

    public List<WikiPage> getWikiPagesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<WikiPage> orderByComparator) {
        return this.wikiPagePersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public WikiPage getWikiPageByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.wikiPagePersistence.findByUUID_G(uuid, groupId);
    }

    public List<WikiPage> getWikiPages(int start, int end) {
        return this.wikiPagePersistence.findAll(start, end);
    }

    public int getWikiPagesCount() {
        return this.wikiPagePersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public WikiPage updateWikiPage(WikiPage wikiPage) {
        return (WikiPage)this.wikiPagePersistence.update((BaseModel)wikiPage);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{WikiPageLocalService.class, IdentifiableOSGiService.class, CTService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.wikiPageLocalService = (WikiPageLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return WikiPageLocalService.class.getName();
    }

    public CTPersistence<WikiPage> getCTPersistence() {
        return this.wikiPagePersistence;
    }

    public Class<WikiPage> getModelClass() {
        return WikiPage.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<WikiPage>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.wikiPagePersistence);
    }

    protected String getModelClassName() {
        return WikiPage.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.wikiPagePersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

