/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.search;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.TermQueryImpl;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.localization.SearchLocalizationHelper;
import com.liferay.portal.search.model.uid.UIDFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiNodeLocalService;
import com.liferay.wiki.service.WikiNodeService;
import com.liferay.wiki.service.WikiPageLocalService;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletResponse;
import java.util.List;
import java.util.Locale;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={Indexer.class})
public class WikiPageIndexer
extends BaseIndexer<WikiPage> {
    public static final String CLASS_NAME = WikiPage.class.getName();
    @Reference
    protected UIDFactory uidFactory;
    private static final Log _log = LogFactoryUtil.getLog(WikiPageIndexer.class);
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private Localization _localization;
    @Reference
    private SearchLocalizationHelper _searchLocalizationHelper;
    private ServiceTrackerList<ModelDocumentContributor<WikiPage>> _serviceTrackerList;
    @Reference
    private WikiNodeLocalService _wikiNodeLocalService;
    @Reference
    private WikiNodeService _wikiNodeService;
    @Reference
    private WikiPageLocalService _wikiPageLocalService;
    @Reference(target="(model.class.name=com.liferay.wiki.model.WikiPage)")
    private ModelResourcePermission<WikiPage> _wikiPageModelResourcePermission;

    public WikiPageIndexer() {
        this.setDefaultSelectedFieldNames(new String[]{"assetTagNames", "companyId", "content", "entryClassName", "entryClassPK", "groupId", "modified", "scopeGroupId", "title", "uid"});
        this.setDefaultSelectedLocalizedFieldNames(new String[]{"content", "title"});
        this.setFilterSearch(true);
        this.setPermissionAware(true);
    }

    public String getClassName() {
        return CLASS_NAME;
    }

    public boolean hasPermission(PermissionChecker permissionChecker, String entryClassName, long entryClassPK, String actionId) throws Exception {
        return this._wikiPageModelResourcePermission.contains(permissionChecker, (ClassedModel)this._wikiPageLocalService.getPage(entryClassPK), "VIEW");
    }

    public boolean isVisible(long classPK, int status) throws Exception {
        WikiPage page = this._wikiPageLocalService.getPage(classPK);
        return this.isVisible(page.getStatus(), status);
    }

    public void postProcessContextBooleanFilter(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this.addStatus(contextBooleanFilter, searchContext);
        long[] nodeIds = searchContext.getNodeIds();
        if (ArrayUtil.isNotEmpty((long[])nodeIds)) {
            TermsFilter nodesIdTermsFilter = new TermsFilter("nodeId");
            for (long nodeId : nodeIds) {
                try {
                    this._wikiNodeService.getNode(nodeId);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Object)("Unable to get wiki node " + nodeId), (Throwable)exception);
                    continue;
                }
                nodesIdTermsFilter.addValue(String.valueOf(nodeId));
            }
            if (!nodesIdTermsFilter.isEmpty()) {
                contextBooleanFilter.add((Filter)nodesIdTermsFilter, BooleanClauseOccur.MUST);
            }
        }
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        if (searchContext.isIncludeAttachments() || searchContext.isIncludeDiscussions()) {
            this.addSearchLocalizedTerm(searchQuery, searchContext, "content", false);
            this.addSearchLocalizedTerm(searchQuery, searchContext, "title", false);
            return;
        }
        BooleanQueryImpl keywordsBooleanQuery = new BooleanQueryImpl();
        this.addSearchLocalizedTerm((BooleanQuery)keywordsBooleanQuery, searchContext, "content", false);
        this.addSearchLocalizedTerm((BooleanQuery)keywordsBooleanQuery, searchContext, "title", false);
        if (!keywordsBooleanQuery.hasClauses()) {
            return;
        }
        try {
            BooleanQueryImpl modelBooleanQuery = new BooleanQueryImpl();
            modelBooleanQuery.add((Query)new TermQueryImpl("entryClassName", CLASS_NAME), BooleanClauseOccur.MUST);
            modelBooleanQuery.add((Query)keywordsBooleanQuery, BooleanClauseOccur.MUST);
            searchQuery.add((Query)modelBooleanQuery, BooleanClauseOccur.SHOULD);
        }
        catch (ParseException parseException) {
            throw new SystemException((Throwable)parseException);
        }
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.addHighlightFieldNames(this._searchLocalizationHelper.getLocalizedFieldNames(new String[]{"content", "title"}, searchContext));
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        Hits hits = super.search(searchContext);
        hits.setQueryTerms((String[])ArrayUtil.append((Object[])GetterUtil.getStringValues((String[])hits.getQueryTerms()), (Object[])StringUtil.split((String)searchContext.getKeywords(), (String)" ")));
        return hits;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, ModelDocumentContributor.class, (String)"(indexer.class.name=com.liferay.wiki.model.WikiPage)");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }

    protected void doDelete(WikiPage wikiPage) throws Exception {
        this.deleteDocument(wikiPage.getCompanyId(), "UID=" + this.uidFactory.getUID((ClassedModel)wikiPage));
    }

    protected Document doGetDocument(WikiPage wikiPage) throws Exception {
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)wikiPage);
        this._serviceTrackerList.forEach(modelDocumentContributor -> modelDocumentContributor.contribute(document, (BaseModel)wikiPage));
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        String languageId = LocaleUtil.toLanguageId((Locale)locale);
        String content = this._localization.getLocalizedName("content", languageId);
        String title = this._localization.getLocalizedName("title", languageId);
        Summary summary = this.createSummary(document, title, content);
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(String className, long classPK) throws Exception {
        WikiPage wikiPage = this._wikiPageLocalService.fetchWikiPage(classPK);
        if (wikiPage != null) {
            this._reindexEveryVersionOfResourcePrimKey(wikiPage.getResourcePrimKey());
            return;
        }
        long resourcePrimKey = classPK;
        this._reindexEveryVersionOfResourcePrimKey(resourcePrimKey);
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this._reindexNodes(companyId);
    }

    protected void doReindex(WikiPage wikiPage) throws Exception {
        if (!wikiPage.isHead() || !wikiPage.isApproved() && !wikiPage.isInTrash()) {
            return;
        }
        if (Validator.isNotNull((String)wikiPage.getRedirectTitle())) {
            return;
        }
        this._indexWriterHelper.updateDocument(wikiPage.getCompanyId(), this.getDocument(wikiPage));
        this._reindexAttachments(wikiPage);
    }

    private void _deleteDocument(WikiPage wikiPage) {
        try {
            this._indexWriterHelper.deleteDocument(wikiPage.getCompanyId(), this.uidFactory.getUID((ClassedModel)wikiPage), this.isCommitImmediately());
        }
        catch (SearchException searchException) {
            throw new RuntimeException(searchException);
        }
    }

    private void _reindexAttachments(WikiPage wikiPage) throws Exception {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(DLFileEntry.class);
        for (FileEntry attachmentsFileEntry : wikiPage.getAttachmentsFileEntries()) {
            indexer.reindex((Object)((DLFileEntry)attachmentsFileEntry.getModel()));
        }
    }

    private void _reindexEveryVersionOfResourcePrimKey(long resourcePrimKey) throws Exception {
        List wikiPages = this._wikiPageLocalService.getPersistedModel(resourcePrimKey);
        if (ListUtil.isEmpty((List)wikiPages)) {
            return;
        }
        WikiPage latestWikiPage = this._wikiPageLocalService.getPage(resourcePrimKey, (Boolean)null);
        for (WikiPage wikiPage : wikiPages) {
            if (wikiPage.getPrimaryKey() == latestWikiPage.getPrimaryKey()) {
                this.doReindex(wikiPage);
                continue;
            }
            this._deleteDocument(wikiPage);
        }
    }

    private void _reindexNodes(long companyId) throws Exception {
        ActionableDynamicQuery actionableDynamicQuery = this._wikiNodeLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setCompanyId(companyId);
        actionableDynamicQuery.setPerformActionMethod(node -> this._reindexPages(companyId, node.getGroupId(), node.getNodeId()));
        actionableDynamicQuery.performActions();
    }

    private void _reindexPages(long companyId, long groupId, long nodeId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._wikiPageLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
            Property nodeIdProperty = PropertyFactoryUtil.forName((String)"nodeId");
            dynamicQuery.add(nodeIdProperty.eq((Object)nodeId));
            Property headProperty = PropertyFactoryUtil.forName((String)"head");
            dynamicQuery.add(headProperty.eq((Object)true));
        });
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setGroupId(groupId);
        indexableActionableDynamicQuery.setPerformActionMethod(page -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(page)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index wiki page " + page.getPageId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.performActions();
    }
}

