/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.internal.importer;

import com.liferay.asset.kernel.model.AssetTag;
import com.liferay.asset.kernel.service.AssetTagLocalService;
import com.liferay.asset.util.AssetHelper;
import com.liferay.document.library.kernel.util.DLValidatorUtil;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.ProgressTrackerThreadLocal;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.zip.ZipReader;
import com.liferay.portal.kernel.zip.ZipReaderFactory;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.exception.ImportFilesException;
import com.liferay.wiki.exception.NoSuchPageException;
import com.liferay.wiki.internal.translator.MediaWikiToCreoleTranslator;
import com.liferay.wiki.model.WikiNode;
import com.liferay.wiki.model.WikiPage;
import com.liferay.wiki.service.WikiPageLocalService;
import com.liferay.wiki.validator.WikiPageTitleValidator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaWikiImporter {
    private static final String _WORK_IN_PROGRESS = "{{Work in progress}}";
    private static final String _WORK_IN_PROGRESS_TAG = "work in progress";
    private static final Log _log = LogFactoryUtil.getLog(MediaWikiImporter.class);
    private static final Pattern _categoriesPattern = Pattern.compile("\\[\\[[Cc]ategory:([^\\]]*)\\]\\][\\n]*");
    private static final Pattern _mediaLinkPattern = Pattern.compile("\\[\\[(Media:)([^\\]\\|]*)(\\|[^\\]]*)?\\]\\]", 32);
    private static final Pattern _parentPattern = Pattern.compile("\\{{2}OtherTopics\\|([^\\}]*)\\}{2}");
    private static final Pattern _redirectPattern = Pattern.compile("#REDIRECT \\[\\[([^\\]]*)\\]\\]");
    private static final Set<String> _specialMediaWikiDirs = SetUtil.fromArray((Object[])new String[]{"archive", "temp", "thumb"});
    private final AssetTagLocalService _assetTagLocalService;
    private final CompanyLocalService _companyLocalService;
    private final PortletFileRepository _portletFileRepository;
    private final MediaWikiToCreoleTranslator _translator = new MediaWikiToCreoleTranslator();
    private final UserLocalService _userLocalService;
    private volatile WikiGroupServiceConfiguration _wikiGroupServiceConfiguration;
    private final WikiPageLocalService _wikiPageLocalService;
    private final WikiPageTitleValidator _wikiPageTitleValidator;
    private final ZipReaderFactory _zipReaderFactory;

    public MediaWikiImporter(AssetTagLocalService assetTagLocalService, CompanyLocalService companyLocalService, PortletFileRepository portletFileRepository, UserLocalService userLocalService, WikiGroupServiceConfiguration wikiGroupServiceConfiguration, WikiPageLocalService wikiPageLocalService, WikiPageTitleValidator wikiPageTitleValidator, ZipReaderFactory zipReaderFactory) {
        this._assetTagLocalService = assetTagLocalService;
        this._companyLocalService = companyLocalService;
        this._portletFileRepository = portletFileRepository;
        this._userLocalService = userLocalService;
        this._wikiGroupServiceConfiguration = wikiGroupServiceConfiguration;
        this._wikiPageLocalService = wikiPageLocalService;
        this._wikiPageTitleValidator = wikiPageTitleValidator;
        this._zipReaderFactory = zipReaderFactory;
    }

    public void importPages(long userId, WikiNode node, InputStream[] inputStreams, Map<String, String[]> options) throws PortalException {
        if (inputStreams.length < 1 || inputStreams[0] == null) {
            throw new PortalException("The pages file is mandatory");
        }
        InputStream pagesInputStream = inputStreams[0];
        InputStream usersInputStream = null;
        if (inputStreams.length > 1) {
            usersInputStream = inputStreams[1];
        }
        InputStream imagesInputStream = null;
        if (inputStreams.length > 2) {
            imagesInputStream = inputStreams[2];
        }
        try {
            Document document = SAXReaderUtil.read((InputStream)pagesInputStream);
            Map<String, String> usersMap = this._readUsersFile(usersInputStream);
            Element rootElement = document.getRootElement();
            List<String> specialNamespaces = this._readSpecialNamespaces(rootElement);
            this._processImages(userId, node, imagesInputStream);
            this._processSpecialPages(userId, node, rootElement, specialNamespaces);
            this._processRegularPages(userId, node, rootElement, specialNamespaces, usersMap, imagesInputStream, options);
            this._moveFrontPage(userId, node, options);
        }
        catch (DocumentException documentException) {
            throw new ImportFilesException("Invalid XML file provided", (Throwable)documentException);
        }
        catch (IOException ioException) {
            throw new ImportFilesException("Error reading the files provided", (Throwable)ioException);
        }
        catch (PortalException portalException) {
            throw portalException;
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
    }

    private String _getCreoleRedirectContent(String redirectTitle) {
        return "[[" + redirectTitle + "]]";
    }

    private long _getUserId(long userId, WikiNode node, String author, Map<String, String> usersMap) {
        User user = null;
        String emailAddress = usersMap.get(author);
        user = Validator.isNotNull((String)emailAddress) ? this._userLocalService.fetchUserByEmailAddress(node.getCompanyId(), emailAddress) : this._userLocalService.fetchUserByScreenName(node.getCompanyId(), StringUtil.toLowerCase((String)author));
        if (user != null) {
            return user.getUserId();
        }
        return userId;
    }

    private void _importPage(long userId, String author, WikiNode node, String title, String content, String summary, Map<String, String> usersMap, boolean strictImportMode) throws PortalException {
        try {
            long authorUserId = this._getUserId(userId, node, author, usersMap);
            String parentTitle = this._readParentTitle(content);
            String redirectTitle = this._readRedirectTitle(content);
            if (Validator.isNotNull((String)redirectTitle)) {
                content = this._getCreoleRedirectContent(redirectTitle);
            } else {
                content = this._translateMediaWikiToCreole(content, strictImportMode);
                content = this._translateMediaLinks(node, content);
            }
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            serviceContext.setAssetTagNames(this._readAssetTagNames(userId, node, content));
            WikiPage page = null;
            try {
                page = this._wikiPageLocalService.getPage(node.getNodeId(), title);
            }
            catch (NoSuchPageException noSuchPageException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchPageException);
                }
                page = this._wikiPageLocalService.addPage(authorUserId, node.getNodeId(), title, "New", null, true, serviceContext);
            }
            this._wikiPageLocalService.updatePage(authorUserId, node.getNodeId(), title, page.getVersion(), content, summary, true, "creole", parentTitle, redirectTitle, serviceContext);
        }
        catch (Exception exception) {
            throw new PortalException("Error importing page " + title, (Throwable)exception);
        }
    }

    private boolean _isSpecialMediaWikiPage(String title, List<String> specialNamespaces) {
        for (String namespace : specialNamespaces) {
            if (!title.startsWith(namespace + ":")) continue;
            return true;
        }
        return false;
    }

    private boolean _isValidImage(String[] paths, InputStream inputStream) {
        if (_specialMediaWikiDirs.contains(paths[0]) || paths.length > 1 && _specialMediaWikiDirs.contains(paths[1])) {
            return false;
        }
        String fileName = paths[paths.length - 1];
        try {
            DLValidatorUtil.validateFileName((String)fileName);
            DLValidatorUtil.validateFileExtension((String)fileName);
            DLValidatorUtil.validateFileSize((long)GroupThreadLocal.getGroupId(), (String)fileName, (String)MimeTypesUtil.getContentType((String)fileName), (InputStream)inputStream);
        }
        catch (PortalException | SystemException exception) {
            if (_log.isDebugEnabled()) {
                _log.debug(exception);
            }
            return false;
        }
        return true;
    }

    private void _moveFrontPage(long userId, WikiNode node, Map<String, String[]> options) {
        block4: {
            String frontPageTitle = MapUtil.getString(options, (Object)"OPTIONS_FRONT_PAGE");
            if (Validator.isNull((String)frontPageTitle)) {
                return;
            }
            frontPageTitle = this._wikiPageTitleValidator.normalize(frontPageTitle);
            try {
                int count = this._wikiPageLocalService.getPagesCount(node.getNodeId(), frontPageTitle, true);
                if (count > 0) {
                    ServiceContext serviceContext = new ServiceContext();
                    serviceContext.setAddGroupPermissions(true);
                    serviceContext.setAddGuestPermissions(true);
                    this._wikiPageLocalService.renamePage(userId, node.getNodeId(), frontPageTitle, this._wikiGroupServiceConfiguration.frontPageName(), false, serviceContext);
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"Could not move ", this._wikiGroupServiceConfiguration.frontPageName(), " to the title provided: ", frontPageTitle}), (Throwable)exception);
            }
        }
    }

    private String _normalize(String categoryName, int length) {
        categoryName = this._toWord(categoryName.trim());
        return StringUtil.shorten((String)categoryName, (int)length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _processImages(long userId, WikiNode node, InputStream imagesInputStream) throws Exception {
        if (imagesInputStream == null) {
            return;
        }
        ZipReader zipReader = this._zipReaderFactory.getZipReader(imagesInputStream);
        List entries = zipReader.getEntries();
        if (entries == null) {
            throw new ImportFilesException();
        }
        ProgressTracker progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        int count = 0;
        int total = entries.size();
        if (total > 0) {
            try {
                this._wikiPageLocalService.getPage(node.getNodeId(), "SharedImages");
            }
            catch (NoSuchPageException noSuchPageException) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)noSuchPageException);
                }
                ServiceContext serviceContext = new ServiceContext();
                serviceContext.setAddGroupPermissions(true);
                serviceContext.setAddGuestPermissions(true);
                this._wikiPageLocalService.addPage(userId, node.getNodeId(), "SharedImages", "See attachments", null, true, serviceContext);
            }
        }
        ArrayList<ObjectValuePair> inputStreamOVPs = new ArrayList<ObjectValuePair>();
        try {
            int percentage = 50;
            for (int i = 0; i < entries.size(); ++i) {
                String entry;
                String key = entry = (String)entries.get(i);
                InputStream inputStream = zipReader.getEntryAsInputStream(entry);
                String[] paths = StringUtil.split((String)key, (char)'/');
                if (!this._isValidImage(paths, inputStream)) {
                    if (!_log.isInfoEnabled()) continue;
                    _log.info((Object)("Ignoring " + key));
                    continue;
                }
                String fileName = StringUtil.toLowerCase((String)paths[paths.length - 1]);
                ObjectValuePair inputStreamOVP = new ObjectValuePair((Object)fileName, (Object)inputStream);
                inputStreamOVPs.add(inputStreamOVP);
                ++count;
                if (i % 5 != 0) continue;
                this._wikiPageLocalService.addPageAttachments(userId, node.getNodeId(), "SharedImages", inputStreamOVPs);
                inputStreamOVPs.clear();
                if (progressTracker == null) continue;
                percentage = Math.min(50 + i * 50 / total, 99);
                progressTracker.setPercent(percentage);
            }
            if (!inputStreamOVPs.isEmpty()) {
                this._wikiPageLocalService.addPageAttachments(userId, node.getNodeId(), "SharedImages", inputStreamOVPs);
            }
        }
        finally {
            for (ObjectValuePair inputStreamOVP : inputStreamOVPs) {
                try {
                    InputStream inputStream = (InputStream)inputStreamOVP.getValue();
                    if (inputStream == null) continue;
                    inputStream.close();
                }
                catch (IOException ioException) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Throwable)ioException);
                }
            }
        }
        zipReader.close();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Imported ", count, " images into ", node.getName()}));
        }
    }

    private void _processRegularPages(long userId, WikiNode node, Element rootElement, List<String> specialNamespaces, Map<String, String> usersMap, InputStream imagesInputStream, Map<String, String[]> options) {
        boolean importLatestVersion = MapUtil.getBoolean(options, (String)"OPTIONS_IMPORT_LATEST_VERSION");
        boolean strictImportMode = MapUtil.getBoolean(options, (String)"OPTIONS_STRICT_IMPORT_MODE");
        ProgressTracker progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        int count = 0;
        int percentage = 10;
        int maxPercentage = 50;
        if (imagesInputStream == null) {
            maxPercentage = 99;
        }
        List pageElements = rootElement.elements("page");
        for (int i = 0; i < pageElements.size(); ++i) {
            Element pageElement = (Element)pageElements.get(i);
            String title = pageElement.elementText("title");
            if (this._isSpecialMediaWikiPage(title, specialNamespaces)) continue;
            title = this._wikiPageTitleValidator.normalize(title);
            percentage = Math.min(10 + i * (maxPercentage - percentage) / pageElements.size(), maxPercentage);
            progressTracker.setPercent(percentage);
            ArrayList<Element> revisionElements = pageElement.elements("revision");
            if (importLatestVersion) {
                Element lastRevisionElement = (Element)revisionElements.get(revisionElements.size() - 1);
                revisionElements = new ArrayList<Element>();
                revisionElements.add(lastRevisionElement);
            }
            for (Element revisionElement : revisionElements) {
                Element contributorElement = revisionElement.element("contributor");
                String author = contributorElement.elementText("username");
                String content = revisionElement.elementText("text");
                String summary = revisionElement.elementText("comment");
                try {
                    this._importPage(userId, author, node, title, content, summary, usersMap, strictImportMode);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Page with title " + title + " could not be imported"), (Throwable)exception);
                }
            }
            ++count;
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Imported ", count, " pages into ", node.getName()}));
        }
    }

    private void _processSpecialPages(long userId, WikiNode node, Element rootElement, List<String> specialNamespaces) throws PortalException {
        ProgressTracker progressTracker = ProgressTrackerThreadLocal.getProgressTracker();
        List pageElements = rootElement.elements("page");
        for (int i = 0; i < pageElements.size(); ++i) {
            Element pageElement = (Element)pageElements.get(i);
            String title = pageElement.elementText("title");
            if (!title.startsWith("Category:")) {
                if (!this._isSpecialMediaWikiPage(title, specialNamespaces)) continue;
                rootElement.remove(pageElement);
                continue;
            }
            String categoryName = title.substring("Category:".length());
            categoryName = this._normalize(categoryName, 75);
            this._assetTagLocalService.checkTags(userId, node.getGroupId(), new String[]{categoryName});
            if (i % 5 != 0) continue;
            progressTracker.setPercent(i * 10 / pageElements.size());
        }
    }

    private String[] _readAssetTagNames(long userId, WikiNode node, String content) throws PortalException {
        Matcher matcher = _categoriesPattern.matcher(content);
        ArrayList<String> assetTagNames = new ArrayList<String>();
        while (matcher.find()) {
            String categoryName = matcher.group(1);
            categoryName = this._normalize(categoryName, 75);
            List assetTags = this._assetTagLocalService.checkTags(userId, node.getGroupId(), new String[]{categoryName});
            assetTagNames.addAll(ListUtil.toList((List)assetTags, (Accessor)AssetTag.NAME_ACCESSOR));
        }
        if (content.contains(_WORK_IN_PROGRESS)) {
            assetTagNames.add(_WORK_IN_PROGRESS_TAG);
        }
        return assetTagNames.toArray(new String[0]);
    }

    private String _readParentTitle(String content) {
        Matcher matcher = _parentPattern.matcher(content);
        Object redirectTitle = "";
        if (matcher.find()) {
            redirectTitle = matcher.group(1);
            redirectTitle = this._wikiPageTitleValidator.normalize((String)redirectTitle);
            redirectTitle = (String)redirectTitle + " (disambiguation)";
        }
        return redirectTitle;
    }

    private String _readRedirectTitle(String content) {
        Matcher matcher = _redirectPattern.matcher(content);
        String redirectTitle = "";
        if (matcher.find()) {
            redirectTitle = matcher.group(1);
            redirectTitle = this._wikiPageTitleValidator.normalize(redirectTitle);
        }
        return redirectTitle;
    }

    private List<String> _readSpecialNamespaces(Element root) throws ImportFilesException {
        Element siteinfoElement = root.element("siteinfo");
        if (siteinfoElement == null) {
            throw new ImportFilesException("Invalid pages XML file");
        }
        Element namespacesElement = siteinfoElement.element("namespaces");
        return TransformUtil.transform((Collection)namespacesElement.elements("namespace"), namespaceElement -> {
            Attribute attribute = namespaceElement.attribute("key");
            String value = attribute.getValue();
            if (value.equals("0")) {
                return null;
            }
            return namespaceElement.getText();
        });
    }

    private Map<String, String> _readUsersFile(InputStream usersInputStream) throws IOException {
        if (usersInputStream == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> usersMap = new HashMap<String, String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader((Reader)new InputStreamReader(usersInputStream));
        String line = unsyncBufferedReader.readLine();
        while (line != null) {
            String[] array = StringUtil.split((String)line);
            if (array.length == 2 && Validator.isNotNull((String)array[0]) && Validator.isNotNull((String)array[1])) {
                usersMap.put(array[0], array[1]);
            } else if (_log.isInfoEnabled()) {
                _log.info((Object)("Ignoring line " + line + " because it does not contain exactly 2 columns"));
            }
            line = unsyncBufferedReader.readLine();
        }
        return usersMap;
    }

    private String _toWord(String text) {
        if (Validator.isNull((String)text)) {
            return text;
        }
        char[] textCharArray = text.toCharArray();
        block0: for (int i = 0; i < textCharArray.length; ++i) {
            char c = textCharArray[i];
            for (char invalidChar : AssetHelper.INVALID_CHARACTERS) {
                if (c != invalidChar) continue;
                textCharArray[i] = 32;
                continue block0;
            }
        }
        return new String(textCharArray);
    }

    private String _translateMediaLinks(WikiNode node, String content) {
        try {
            StringBuffer sb = new StringBuffer();
            WikiPage sharedImagesPage = this._wikiPageLocalService.getPage(node.getNodeId(), "SharedImages");
            Company company = this._companyLocalService.getCompany(node.getCompanyId());
            String portalURL = company.getPortalURL(node.getGroupId());
            Matcher matcher = _mediaLinkPattern.matcher(content);
            while (matcher.find()) {
                String fileName = matcher.group(2);
                FileEntry fileEntry = this._portletFileRepository.fetchPortletFileEntry(node.getGroupId(), sharedImagesPage.getAttachmentsFolderId(), fileName);
                if (fileEntry == null) {
                    matcher.appendReplacement(sb, matcher.group());
                    continue;
                }
                String fileEntryURL = this._portletFileRepository.getPortletFileEntryURL(null, fileEntry, "");
                Object linkLabel = matcher.group(3);
                if (linkLabel == null) {
                    linkLabel = "|" + fileName;
                }
                matcher.appendReplacement(sb, StringBundler.concat((String[])new String[]{"[[", portalURL, fileEntryURL, linkLabel, "]]"}));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            return content;
        }
    }

    private String _translateMediaWikiToCreole(String content, boolean strictImportMode) {
        this._translator.setStrictImportMode(strictImportMode);
        return this._translator.translate(content);
    }
}

