/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.wiki.model.impl;

import com.liferay.wiki.model.WikiPageResource;
import com.liferay.wiki.service.WikiPageResourceLocalServiceUtil;

/**
 * The extended model base implementation for the WikiPageResource service. Represents a row in the &quot;WikiPageResource&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link WikiPageResourceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see WikiPageResourceImpl
 * @see WikiPageResource
 * @generated
 */
public abstract class WikiPageResourceBaseImpl
	extends WikiPageResourceModelImpl implements WikiPageResource {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a wiki page resource model instance should use the <code>WikiPageResource</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			WikiPageResourceLocalServiceUtil.addWikiPageResource(this);
		}
		else {
			WikiPageResourceLocalServiceUtil.updateWikiPageResource(this);
		}
	}

}