/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.engine.jspwiki.internal;

import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiException;
import com.ecyrd.jspwiki.WikiPage;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundleLoader;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.language.LanguageResources;
import com.liferay.wiki.configuration.WikiGroupServiceConfiguration;
import com.liferay.wiki.engine.BaseWikiEngine;
import com.liferay.wiki.engine.WikiEngine;
import com.liferay.wiki.engine.jspwiki.internal.LiferayJSPWikiEngine;
import com.liferay.wiki.engine.jspwiki.internal.LiferayPageProvider;
import com.liferay.wiki.exception.PageContentException;
import com.liferay.wiki.service.WikiPageLocalService;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletURL;
import javax.servlet.ServletContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=-1000"}, service={WikiEngine.class})
public class JSPWikiEngine
extends BaseWikiEngine {
    private static final String[] _JSP_WIKI_NAME_1 = new String[]{"'", "@", "^", "!", "\u00a1", "\u00bf", "`", "?", "/", "*"};
    private static final String[] _JSP_WIKI_NAME_2 = new String[]{"__APO__", "__AT__", "__CAR__", "__EXM__", "__INE__", "__INQ__", "__GRA__", "__QUE__", "__SLA__", "__STA__"};
    private static final Log _log = LogFactoryUtil.getLog(JSPWikiEngine.class);
    private static final Pattern _wikiCommentPattern = Pattern.compile("[\\{]{3,3}(.*?)[\\}]{3,3}", 32);
    private static final Pattern _wikiLinkPattern = Pattern.compile("[\\[]{1,2}(.+?)[\\]]{1,2}", 32);
    private final Map<Long, LiferayJSPWikiEngine> _engines = new ConcurrentHashMap<Long, LiferayJSPWikiEngine>();
    private Properties _properties = new Properties();
    private ResourceBundleLoader _resourceBundleLoader;
    private ServletContext _servletContext;
    @Reference(target="(osgi.web.symbolicname=com.liferay.wiki.engine.input.editor.common)")
    private ServletContext _wikiEngineInputEditorServletContext;
    private WikiGroupServiceConfiguration _wikiGroupServiceConfiguration;
    private WikiPageLocalService _wikiPageLocalService;

    public static String decodeJSPWikiName(String jspWikiName) {
        return StringUtil.replace((String)jspWikiName, (String[])_JSP_WIKI_NAME_2, (String[])_JSP_WIKI_NAME_1);
    }

    public String convert(com.liferay.wiki.model.WikiPage page, PortletURL viewPageURL, PortletURL editPageURL, String attachmentURLPrefix) throws PageContentException {
        try {
            return this.convert(page);
        }
        catch (WikiException we) {
            throw new PageContentException((Throwable)we);
        }
    }

    public String getEditorName() {
        return this._wikiGroupServiceConfiguration.getCreoleEditor();
    }

    public String getFormat() {
        return "creole";
    }

    public String getHelpURL() {
        return "https://jspwiki-wiki.apache.org/Wiki.jsp?page=TextFormattingRules";
    }

    public Map<String, Boolean> getOutgoingLinks(com.liferay.wiki.model.WikiPage page) throws PageContentException {
        if (Validator.isNull((String)page.getContent())) {
            return Collections.emptyMap();
        }
        try {
            LiferayJSPWikiEngine engine = this.getEngine(page.getNodeId());
            WikiPage jspWikiPage = LiferayPageProvider.toJSPWikiPage(page, engine);
            Collection<String> titles = engine.scanWikiLinks(jspWikiPage, JSPWikiEngine._encodeJSPWikiContent(page.getContent()));
            HashMap<String, Boolean> links = new HashMap<String, Boolean>();
            for (String title : titles) {
                Boolean existsObj;
                if (title.startsWith("[[")) {
                    title = title.substring(2);
                } else if (title.startsWith("[")) {
                    title = title.substring(1);
                }
                if (title.endsWith("]]")) {
                    title = title.substring(0, title.length() - 2);
                } else if (title.endsWith("]")) {
                    title = title.substring(0, title.length() - 1);
                }
                if ((existsObj = (Boolean)links.get(title)) != null) continue;
                existsObj = this._wikiPageLocalService.getPagesCount(page.getNodeId(), title, true) > 0 ? Boolean.TRUE : Boolean.FALSE;
                links.put(title, existsObj);
            }
            return links;
        }
        catch (SystemException se) {
            throw new PageContentException((Throwable)se);
        }
        catch (WikiException we) {
            throw new PageContentException((Throwable)we);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Activate
    protected void activate() throws IOException {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("com/liferay/wiki/engine/jspwiki/dependencies/jspwiki.properties");){
            this._properties.load(inputStream);
        }
    }

    protected String convert(com.liferay.wiki.model.WikiPage page) throws WikiException {
        String content = JSPWikiEngine._encodeJSPWikiContent(page.getContent());
        if (Validator.isNull((String)content)) {
            return "";
        }
        LiferayJSPWikiEngine engine = this.getEngine(page.getNodeId());
        WikiPage jspWikiPage = LiferayPageProvider.toJSPWikiPage(page, engine);
        WikiContext wikiContext = new WikiContext((com.ecyrd.jspwiki.WikiEngine)engine, jspWikiPage);
        return JSPWikiEngine._decodeJSPWikiContent(engine.textToHTML(wikiContext, content));
    }

    protected ServletContext getEditPageServletContext() {
        return this._wikiEngineInputEditorServletContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LiferayJSPWikiEngine getEngine(long nodeId) throws WikiException {
        LiferayJSPWikiEngine engine = this._engines.get(nodeId);
        if (engine != null) {
            return engine;
        }
        Map<Long, LiferayJSPWikiEngine> map = this._engines;
        synchronized (map) {
            engine = this._engines.get(nodeId);
            if (engine != null) {
                return engine;
            }
            Properties nodeProperties = new Properties(this._properties);
            nodeProperties.setProperty("nodeId", String.valueOf(nodeId));
            String appName = nodeProperties.getProperty("jspwiki.applicationName");
            nodeProperties.setProperty("jspwiki.applicationName", appName + " for node " + nodeId);
            engine = new LiferayJSPWikiEngine(nodeProperties);
            this._engines.put(nodeId, engine);
            return engine;
        }
    }

    protected ServletContext getHelpPageServletContext() {
        return this._servletContext;
    }

    protected ResourceBundleLoader getResourceBundleLoader() {
        return this._resourceBundleLoader;
    }

    protected synchronized void setProperties(String configuration) {
        this._properties = new Properties();
        UnsyncByteArrayInputStream is = new UnsyncByteArrayInputStream(configuration.getBytes());
        try {
            this._properties.load((InputStream)is);
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
    }

    @Reference(target="(bundle.symbolic.name=com.liferay.wiki.engine.lang)", unbind="-")
    protected void setResourceBundleLoader(ResourceBundleLoader resourceBundleLoader) {
        this._resourceBundleLoader = new AggregateResourceBundleLoader(new ResourceBundleLoader[]{resourceBundleLoader, LanguageResources.RESOURCE_BUNDLE_LOADER});
    }

    @Reference(target="(osgi.web.symbolicname=com.liferay.wiki.engine.jspwiki)", unbind="-")
    protected void setServletContext(ServletContext servletContext) {
        this._servletContext = servletContext;
    }

    @Reference
    protected void setWikiGroupServiceConfiguration(WikiGroupServiceConfiguration wikiGroupServiceConfiguration) {
        this._wikiGroupServiceConfiguration = wikiGroupServiceConfiguration;
    }

    @Reference(unbind="-")
    protected void setWikiPageLocalService(WikiPageLocalService wikiPageLocalService) {
        this._wikiPageLocalService = wikiPageLocalService;
    }

    protected void unsetWikiGroupServiceConfiguration(WikiGroupServiceConfiguration wikiGroupServiceConfiguration) {
        this._wikiGroupServiceConfiguration = null;
    }

    private static String _decodeJSPWikiContent(String jspWikiContent) {
        return StringUtil.replace((String)jspWikiContent, (String[])_JSP_WIKI_NAME_2, (String[])_JSP_WIKI_NAME_1);
    }

    private static String _encodeJSPWikiContent(String content) {
        StringBundler sb = new StringBundler();
        Matcher commentMatcher = _wikiCommentPattern.matcher(content);
        int start = 0;
        int end = 0;
        while (commentMatcher.find()) {
            end = commentMatcher.start();
            String oldContent = content.substring(start, end);
            Matcher wikiLinkMatcher = _wikiLinkPattern.matcher(oldContent);
            sb.append(JSPWikiEngine._encodeLink(oldContent, wikiLinkMatcher));
            sb.append(content.substring(commentMatcher.start(), commentMatcher.end()));
            start = commentMatcher.end();
        }
        if (start < content.length()) {
            content = content.substring(start);
            Matcher wikiLinkMatcher = _wikiLinkPattern.matcher(content);
            sb.append(JSPWikiEngine._encodeLink(content, wikiLinkMatcher));
        }
        return sb.toString();
    }

    private static String _encodeJSPWikiName(String name) {
        if (name == null) {
            return "";
        }
        return StringUtil.replace((String)name, (String[])_JSP_WIKI_NAME_1, (String[])_JSP_WIKI_NAME_2);
    }

    private static String _encodeLink(String content, Matcher wikiLinkMatcher) {
        while (wikiLinkMatcher.find()) {
            String linkValues;
            String link = wikiLinkMatcher.group();
            String name = linkValues = wikiLinkMatcher.group(1);
            String url = linkValues;
            int pos = linkValues.indexOf(124);
            if (pos != -1) {
                name = linkValues.substring(pos + 1);
                url = linkValues.substring(0, pos);
            }
            String newLink = StringBundler.concat((String[])new String[]{"[[", JSPWikiEngine._encodeJSPWikiName(url), "|", JSPWikiEngine._encodeJSPWikiName(name), "]]"});
            content = StringUtil.replace((String)content, (String)link, (String)newLink);
        }
        return content;
    }
}

