/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.wiki.editor.configuration.internal;

import com.liferay.item.selector.ItemSelector;
import com.liferay.item.selector.ItemSelectorCriterion;
import com.liferay.item.selector.ItemSelectorReturnType;
import com.liferay.item.selector.criteria.FileEntryItemSelectorReturnType;
import com.liferay.item.selector.criteria.URLItemSelectorReturnType;
import com.liferay.item.selector.criteria.image.criterion.ImageItemSelectorCriterion;
import com.liferay.item.selector.criteria.upload.criterion.UploadItemSelectorCriterion;
import com.liferay.item.selector.criteria.url.criterion.URLItemSelectorCriterion;
import com.liferay.portal.kernel.editor.configuration.BaseEditorConfigContributor;
import com.liferay.portal.kernel.editor.configuration.EditorConfigContributor;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.wiki.item.selector.criterion.WikiAttachmentItemSelectorCriterion;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"editor.config.key=contentEditor", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiAdminPortlet", "javax.portlet.name=com_liferay_wiki_web_portlet_WikiDisplayPortlet", "service.ranking:Integer=100"}, service={EditorConfigContributor.class})
public class WikiAttachmentEditorConfigContributor
extends BaseEditorConfigContributor {
    private ItemSelector _itemSelector;

    public void populateConfigJSONObject(JSONObject jsonObject, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        String removePlugins = jsonObject.getString("removePlugins");
        removePlugins = Validator.isNotNull((String)removePlugins) ? removePlugins + ",ae_addimages" : "ae_addimages";
        jsonObject.put("removePlugins", removePlugins);
        boolean allowBrowseDocuments = GetterUtil.getBoolean((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:allowBrowseDocuments"));
        if (!allowBrowseDocuments) {
            return;
        }
        Map fileBrowserParamsMap = (Map)inputEditorTaglibAttributes.get("liferay-ui:input-editor:fileBrowserParams");
        long wikiPageResourcePrimKey = 0L;
        if (fileBrowserParamsMap != null) {
            wikiPageResourcePrimKey = GetterUtil.getLong((String)((String)fileBrowserParamsMap.get("wikiPageResourcePrimKey")));
        }
        if (wikiPageResourcePrimKey == 0L) {
            return;
        }
        ArrayList<ItemSelectorReturnType> desiredItemSelectorReturnTypes = new ArrayList<ItemSelectorReturnType>();
        desiredItemSelectorReturnTypes.add((ItemSelectorReturnType)new FileEntryItemSelectorReturnType());
        ItemSelectorCriterion attachmentItemSelectorCriterion = this.getWikiAttachmentItemSelectorCriterion(wikiPageResourcePrimKey, desiredItemSelectorReturnTypes);
        ItemSelectorCriterion imageItemSelectorCriterion = this.getImageItemSelectorCriterion(desiredItemSelectorReturnTypes);
        ItemSelectorCriterion urlItemSelectorCriterion = this.getURLItemSelectorCriterion();
        ItemSelectorCriterion uploadItemSelectorCriterion = this.getUploadItemSelectorCriterion(wikiPageResourcePrimKey, themeDisplay, requestBackedPortletURLFactory);
        String name = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:name"));
        boolean inlineEdit = GetterUtil.getBoolean((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:inlineEdit"));
        if (!inlineEdit) {
            String namespace = GetterUtil.getString((Object)inputEditorTaglibAttributes.get("liferay-ui:input-editor:namespace"));
            name = namespace + name;
        }
        PortletURL itemSelectorURL = this._itemSelector.getItemSelectorURL(requestBackedPortletURLFactory, name + "selectItem", new ItemSelectorCriterion[]{attachmentItemSelectorCriterion, imageItemSelectorCriterion, urlItemSelectorCriterion, uploadItemSelectorCriterion});
        jsonObject.put("filebrowserImageBrowseLinkUrl", itemSelectorURL.toString());
        jsonObject.put("filebrowserImageBrowseUrl", itemSelectorURL.toString());
    }

    @Reference(unbind="-")
    public void setItemSelector(ItemSelector itemSelector) {
        this._itemSelector = itemSelector;
    }

    protected ItemSelectorCriterion getImageItemSelectorCriterion(List<ItemSelectorReturnType> desiredItemSelectorReturnTypes) {
        ImageItemSelectorCriterion imageItemSelectorCriterion = new ImageItemSelectorCriterion();
        imageItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        return imageItemSelectorCriterion;
    }

    protected ItemSelectorCriterion getUploadItemSelectorCriterion(long wikiPageResourcePrimKey, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        PortletURL uploadURL = requestBackedPortletURLFactory.createActionURL("com_liferay_wiki_web_portlet_WikiPortlet");
        uploadURL.setParameter("javax.portlet.action", "/wiki/upload_page_attachment");
        uploadURL.setParameter("resourcePrimKey", String.valueOf(wikiPageResourcePrimKey));
        UploadItemSelectorCriterion uploadItemSelectorCriterion = new UploadItemSelectorCriterion(uploadURL.toString(), LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"page-attachments"));
        ArrayList<FileEntryItemSelectorReturnType> uploadDesiredItemSelectorReturnTypes = new ArrayList<FileEntryItemSelectorReturnType>();
        uploadDesiredItemSelectorReturnTypes.add(new FileEntryItemSelectorReturnType());
        uploadItemSelectorCriterion.setDesiredItemSelectorReturnTypes(uploadDesiredItemSelectorReturnTypes);
        return uploadItemSelectorCriterion;
    }

    protected ItemSelectorCriterion getURLItemSelectorCriterion() {
        URLItemSelectorCriterion urlItemSelectorCriterion = new URLItemSelectorCriterion();
        ArrayList<URLItemSelectorReturnType> urlDesiredItemSelectorReturnTypes = new ArrayList<URLItemSelectorReturnType>();
        urlDesiredItemSelectorReturnTypes.add(new URLItemSelectorReturnType());
        urlItemSelectorCriterion.setDesiredItemSelectorReturnTypes(urlDesiredItemSelectorReturnTypes);
        return urlItemSelectorCriterion;
    }

    protected ItemSelectorCriterion getWikiAttachmentItemSelectorCriterion(long wikiPageResourcePrimKey, List<ItemSelectorReturnType> desiredItemSelectorReturnTypes) {
        WikiAttachmentItemSelectorCriterion attachmentItemSelectorCriterion = new WikiAttachmentItemSelectorCriterion(wikiPageResourcePrimKey);
        attachmentItemSelectorCriterion.setDesiredItemSelectorReturnTypes(desiredItemSelectorReturnTypes);
        return attachmentItemSelectorCriterion;
    }
}

