/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.websocket.whiteboard.internal;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.osgi.framework.ServiceObjects;
import org.osgi.service.log.LogService;

public class EndpointWrapper
extends Endpoint {
    private volatile boolean _closed;
    private final Endpoint _endpoint;
    private final LogService _logService;
    private final ServiceObjects<Endpoint> _serviceObjects;
    private final Set<Session> _sessions = new HashSet<Session>();

    public EndpointWrapper(ServiceObjects<Endpoint> serviceObjects, LogService logService) {
        this._serviceObjects = serviceObjects;
        this._logService = logService;
        this._endpoint = (Endpoint)serviceObjects.getService();
    }

    public void onClose(Session session, CloseReason closeReason) {
        if (this._closed) {
            return;
        }
        this._endpoint.onClose(session, closeReason);
        this._sessions.remove(session);
        this._serviceObjects.ungetService((Object)this._endpoint);
    }

    public void onError(Session session, Throwable throwable) {
        if (this._closed) {
            return;
        }
        this._endpoint.onError(session, throwable);
    }

    public void onOpen(Session session, EndpointConfig endpointConfig) {
        if (this._closed) {
            return;
        }
        this._endpoint.onOpen(session, endpointConfig);
        this._sessions.add(session);
    }

    protected void close() {
        this._closed = true;
        Iterator<Session> iterator = this._sessions.iterator();
        while (iterator.hasNext()) {
            Session session = iterator.next();
            iterator.remove();
            try {
                CloseReason closeReason = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "Service is going away");
                session.close(closeReason);
                this._endpoint.onClose(session, closeReason);
                this._serviceObjects.ungetService((Object)this._endpoint);
            }
            catch (IOException ioException) {
                this._logService.log(1, "Unable to close session", (Throwable)ioException);
            }
        }
    }
}

