/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.view.count.service.persistence.impl;

import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.view.count.exception.NoSuchEntryException;
import com.liferay.view.count.model.ViewCountEntry;
import com.liferay.view.count.model.ViewCountEntryTable;
import com.liferay.view.count.model.impl.ViewCountEntryImpl;
import com.liferay.view.count.model.impl.ViewCountEntryModelImpl;
import com.liferay.view.count.service.persistence.ViewCountEntryPK;
import com.liferay.view.count.service.persistence.ViewCountEntryPersistence;
import com.liferay.view.count.service.persistence.ViewCountEntryUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ViewCountEntryPersistence.class})
public class ViewCountEntryPersistenceImpl
extends BasePersistenceImpl<ViewCountEntry>
implements ViewCountEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ViewCountEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByC_CN;
    private FinderPath _finderPathWithoutPaginationFindByC_CN;
    private FinderPath _finderPathCountByC_CN;
    private static final String _FINDER_COLUMN_C_CN_COMPANYID_2 = "viewCountEntry.id.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_CN_CLASSNAMEID_2 = "viewCountEntry.id.classNameId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_VIEWCOUNTENTRY = "SELECT viewCountEntry FROM ViewCountEntry viewCountEntry";
    private static final String _SQL_SELECT_VIEWCOUNTENTRY_WHERE = "SELECT viewCountEntry FROM ViewCountEntry viewCountEntry WHERE ";
    private static final String _SQL_COUNT_VIEWCOUNTENTRY = "SELECT COUNT(viewCountEntry) FROM ViewCountEntry viewCountEntry";
    private static final String _SQL_COUNT_VIEWCOUNTENTRY_WHERE = "SELECT COUNT(viewCountEntry) FROM ViewCountEntry viewCountEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "viewCountEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ViewCountEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ViewCountEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ViewCountEntryPersistenceImpl.class);
    private static final Set<String> _compoundPKColumnNames = SetUtil.fromArray((Object[])new String[]{"companyId", "classNameId", "classPK"});

    public List<ViewCountEntry> findByC_CN(long companyId, long classNameId) {
        return this.findByC_CN(companyId, classNameId, -1, -1, null);
    }

    public List<ViewCountEntry> findByC_CN(long companyId, long classNameId, int start, int end) {
        return this.findByC_CN(companyId, classNameId, start, end, null);
    }

    public List<ViewCountEntry> findByC_CN(long companyId, long classNameId, int start, int end, OrderByComparator<ViewCountEntry> orderByComparator) {
        return this.findByC_CN(companyId, classNameId, start, end, orderByComparator, true);
    }

    public List<ViewCountEntry> findByC_CN(long companyId, long classNameId, int start, int end, OrderByComparator<ViewCountEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_CN;
                finderArgs = new Object[]{companyId, classNameId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_CN;
            finderArgs = new Object[]{companyId, classNameId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (ViewCountEntry viewCountEntry : list) {
                if (companyId == viewCountEntry.getCompanyId() && classNameId == viewCountEntry.getClassNameId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_VIEWCOUNTENTRY_WHERE);
            sb.append(_FINDER_COLUMN_C_CN_COMPANYID_2);
            sb.append(_FINDER_COLUMN_C_CN_CLASSNAMEID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY viewCountEntry.id.companyId ASC, viewCountEntry.id.classNameId ASC, viewCountEntry.id.classPK ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(classNameId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ViewCountEntry findByC_CN_First(long companyId, long classNameId, OrderByComparator<ViewCountEntry> orderByComparator) throws NoSuchEntryException {
        ViewCountEntry viewCountEntry = this.fetchByC_CN_First(companyId, classNameId, orderByComparator);
        if (viewCountEntry != null) {
            return viewCountEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public ViewCountEntry fetchByC_CN_First(long companyId, long classNameId, OrderByComparator<ViewCountEntry> orderByComparator) {
        List<ViewCountEntry> list = this.findByC_CN(companyId, classNameId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ViewCountEntry findByC_CN_Last(long companyId, long classNameId, OrderByComparator<ViewCountEntry> orderByComparator) throws NoSuchEntryException {
        ViewCountEntry viewCountEntry = this.fetchByC_CN_Last(companyId, classNameId, orderByComparator);
        if (viewCountEntry != null) {
            return viewCountEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", classNameId=");
        sb.append(classNameId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public ViewCountEntry fetchByC_CN_Last(long companyId, long classNameId, OrderByComparator<ViewCountEntry> orderByComparator) {
        int count = this.countByC_CN(companyId, classNameId);
        if (count == 0) {
            return null;
        }
        List<ViewCountEntry> list = this.findByC_CN(companyId, classNameId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ViewCountEntry[] findByC_CN_PrevAndNext(ViewCountEntryPK viewCountEntryPK, long companyId, long classNameId, OrderByComparator<ViewCountEntry> orderByComparator) throws NoSuchEntryException {
        ViewCountEntry viewCountEntry = this.findByPrimaryKey(viewCountEntryPK);
        Session session = null;
        try {
            session = this.openSession();
            ViewCountEntry[] array = new ViewCountEntryImpl[]{this.getByC_CN_PrevAndNext(session, viewCountEntry, companyId, classNameId, orderByComparator, true), viewCountEntry, this.getByC_CN_PrevAndNext(session, viewCountEntry, companyId, classNameId, orderByComparator, false)};
            ViewCountEntry[] viewCountEntryArray = array;
            return viewCountEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ViewCountEntry getByC_CN_PrevAndNext(Session session, ViewCountEntry viewCountEntry, long companyId, long classNameId, OrderByComparator<ViewCountEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_VIEWCOUNTENTRY_WHERE);
        sb.append(_FINDER_COLUMN_C_CN_COMPANYID_2);
        sb.append(_FINDER_COLUMN_C_CN_CLASSNAMEID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY viewCountEntry.id.companyId ASC, viewCountEntry.id.classNameId ASC, viewCountEntry.id.classPK ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(classNameId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)viewCountEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ViewCountEntry)list.get(1);
        }
        return null;
    }

    public void removeByC_CN(long companyId, long classNameId) {
        for (ViewCountEntry viewCountEntry : this.findByC_CN(companyId, classNameId, -1, -1, null)) {
            this.remove((BaseModel)viewCountEntry);
        }
    }

    public int countByC_CN(long companyId, long classNameId) {
        FinderPath finderPath = this._finderPathCountByC_CN;
        Object[] finderArgs = new Object[]{companyId, classNameId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_VIEWCOUNTENTRY_WHERE);
            sb.append(_FINDER_COLUMN_C_CN_COMPANYID_2);
            sb.append(_FINDER_COLUMN_C_CN_CLASSNAMEID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(classNameId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ViewCountEntryPersistenceImpl() {
        this.setModelClass(ViewCountEntry.class);
        this.setModelImplClass(ViewCountEntryImpl.class);
        this.setModelPKClass(ViewCountEntryPK.class);
        this.setTable((Table)ViewCountEntryTable.INSTANCE);
    }

    public void cacheResult(ViewCountEntry viewCountEntry) {
        this.entityCache.putResult(ViewCountEntryImpl.class, (Serializable)viewCountEntry.getPrimaryKey(), (Serializable)viewCountEntry);
    }

    public void cacheResult(List<ViewCountEntry> viewCountEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && viewCountEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (ViewCountEntry viewCountEntry : viewCountEntries) {
            if (this.entityCache.getResult(ViewCountEntryImpl.class, (Serializable)viewCountEntry.getPrimaryKey()) != null) continue;
            this.cacheResult(viewCountEntry);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ViewCountEntryImpl.class);
        this.finderCache.clearCache(ViewCountEntryImpl.class);
    }

    public void clearCache(ViewCountEntry viewCountEntry) {
        this.entityCache.removeResult(ViewCountEntryImpl.class, (BaseModel)viewCountEntry);
    }

    public void clearCache(List<ViewCountEntry> viewCountEntries) {
        for (ViewCountEntry viewCountEntry : viewCountEntries) {
            this.entityCache.removeResult(ViewCountEntryImpl.class, (BaseModel)viewCountEntry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(ViewCountEntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(ViewCountEntryImpl.class, primaryKey);
        }
    }

    public ViewCountEntry create(ViewCountEntryPK viewCountEntryPK) {
        ViewCountEntryImpl viewCountEntry = new ViewCountEntryImpl();
        viewCountEntry.setNew(true);
        viewCountEntry.setPrimaryKey(viewCountEntryPK);
        viewCountEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return viewCountEntry;
    }

    public ViewCountEntry remove(ViewCountEntryPK viewCountEntryPK) throws NoSuchEntryException {
        return this.remove((Serializable)viewCountEntryPK);
    }

    public ViewCountEntry remove(Serializable primaryKey) throws NoSuchEntryException {
        Session session = null;
        try {
            session = this.openSession();
            ViewCountEntry viewCountEntry = (ViewCountEntry)session.get(ViewCountEntryImpl.class, primaryKey);
            if (viewCountEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
                }
                throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
            }
            ViewCountEntry viewCountEntry2 = (ViewCountEntry)this.remove((BaseModel)viewCountEntry);
            return viewCountEntry2;
        }
        catch (NoSuchEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ViewCountEntry removeImpl(ViewCountEntry viewCountEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)viewCountEntry)) {
                viewCountEntry = (ViewCountEntry)session.get(ViewCountEntryImpl.class, viewCountEntry.getPrimaryKeyObj());
            }
            if (viewCountEntry != null) {
                session.delete((Object)viewCountEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (viewCountEntry != null) {
            this.clearCache(viewCountEntry);
        }
        return viewCountEntry;
    }

    public ViewCountEntry updateImpl(ViewCountEntry viewCountEntry) {
        boolean isNew = viewCountEntry.isNew();
        if (!(viewCountEntry instanceof ViewCountEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass((Class)viewCountEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)viewCountEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in viewCountEntry proxy " + String.valueOf(invocationHandler.getClass()));
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom ViewCountEntry implementation " + String.valueOf(viewCountEntry.getClass()));
        }
        ViewCountEntryModelImpl viewCountEntryModelImpl = (ViewCountEntryModelImpl)viewCountEntry;
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)viewCountEntry);
            } else {
                viewCountEntry = (ViewCountEntry)session.merge((Object)viewCountEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(ViewCountEntryImpl.class, (BaseModel)viewCountEntryModelImpl, false, true);
        if (isNew) {
            viewCountEntry.setNew(false);
        }
        viewCountEntry.resetOriginalValues();
        return viewCountEntry;
    }

    public ViewCountEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchEntryException {
        ViewCountEntry viewCountEntry = (ViewCountEntry)this.fetchByPrimaryKey(primaryKey);
        if (viewCountEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
            }
            throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
        }
        return viewCountEntry;
    }

    public ViewCountEntry findByPrimaryKey(ViewCountEntryPK viewCountEntryPK) throws NoSuchEntryException {
        return this.findByPrimaryKey((Serializable)viewCountEntryPK);
    }

    public ViewCountEntry fetchByPrimaryKey(ViewCountEntryPK viewCountEntryPK) {
        return (ViewCountEntry)this.fetchByPrimaryKey((Serializable)viewCountEntryPK);
    }

    public List<ViewCountEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ViewCountEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ViewCountEntry> findAll(int start, int end, OrderByComparator<ViewCountEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ViewCountEntry> findAll(int start, int end, OrderByComparator<ViewCountEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_VIEWCOUNTENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_VIEWCOUNTENTRY;
                sql = sql.concat(" ORDER BY viewCountEntry.id.companyId ASC, viewCountEntry.id.classNameId ASC, viewCountEntry.id.classPK ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ViewCountEntry viewCountEntry : this.findAll()) {
            this.remove((BaseModel)viewCountEntry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_VIEWCOUNTENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getCompoundPKColumnNames() {
        return _compoundPKColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "viewCountEntryPK";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_VIEWCOUNTENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ViewCountEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByC_CN = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_CN", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"companyId", "classNameId"}, true);
        this._finderPathWithoutPaginationFindByC_CN = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_CN", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"companyId", "classNameId"}, true);
        this._finderPathCountByC_CN = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_CN", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"companyId", "classNameId"}, false);
        ViewCountEntryUtil.setPersistence((ViewCountEntryPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        ViewCountEntryUtil.setPersistence(null);
        this.entityCache.removeCache(ViewCountEntryImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.view.count.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.view.count.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.view.count.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

