/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.service.impl;

import com.liferay.petra.model.adapter.util.ModelAdapterUtil;
import com.liferay.portal.kernel.dao.search.SearchPaginationUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.TrashPermissionException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashEntryList;
import com.liferay.trash.model.TrashEntrySoap;
import com.liferay.trash.model.impl.TrashEntryImpl;
import com.liferay.trash.service.base.TrashEntryServiceBaseImpl;
import java.util.ArrayList;
import java.util.List;

public class TrashEntryServiceImpl
extends TrashEntryServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(TrashEntryServiceImpl.class);

    @Transactional(noRollbackFor={TrashPermissionException.class})
    public void deleteEntries(long groupId) throws PortalException {
        boolean throwTrashPermissionException = false;
        List entries = this.trashEntryPersistence.findByGroupId(groupId);
        PermissionChecker permissionChecker = this.getPermissionChecker();
        for (TrashEntry entry : entries) {
            if ((entry = this.trashEntryPersistence.fetchByPrimaryKey(entry.getEntryId())) == null) continue;
            try {
                TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entry.getClassName());
                if (!trashHandler.hasTrashPermission(permissionChecker, 0L, entry.getClassPK(), "VIEW")) continue;
                this.deleteEntry(entry);
            }
            catch (TrashPermissionException tpe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)tpe, (Throwable)tpe);
                }
                throwTrashPermissionException = true;
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        if (throwTrashPermissionException) {
            throw new TrashPermissionException(2);
        }
    }

    @Transactional(noRollbackFor={TrashPermissionException.class})
    public void deleteEntries(long[] entryIds) throws PortalException {
        boolean throwTrashPermissionException = false;
        for (long entryId : entryIds) {
            try {
                this.deleteEntry(entryId);
            }
            catch (TrashPermissionException tpe) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)tpe, (Throwable)tpe);
                }
                throwTrashPermissionException = true;
            }
        }
        if (throwTrashPermissionException) {
            throw new TrashPermissionException(2);
        }
    }

    public void deleteEntry(long entryId) throws PortalException {
        TrashEntry entry = this.trashEntryPersistence.findByPrimaryKey(entryId);
        this.deleteEntry(entry);
    }

    public void deleteEntry(String className, long classPK) throws PortalException {
        TrashEntry entry = this.trashEntryLocalService.fetchEntry(className, classPK);
        if (entry == null) {
            entry = new TrashEntryImpl();
            entry.setClassName(className);
            entry.setClassPK(classPK);
        }
        this.deleteEntry(entry);
    }

    public TrashEntryList getEntries(long groupId) throws PrincipalException {
        return this.getEntries(groupId, -1, -1, null);
    }

    public TrashEntryList getEntries(long groupId, int start, int end, OrderByComparator<TrashEntry> obc) throws PrincipalException {
        return this.getEntries(groupId, null, start, end, obc);
    }

    public List<TrashEntry> getEntries(long groupId, String className) throws PrincipalException {
        long classNameId = this.classNameLocalService.getClassNameId(className);
        List entries = this.trashEntryPersistence.findByG_C(groupId, classNameId);
        return this.filterEntries(entries);
    }

    public TrashEntryList getEntries(long groupId, String className, int start, int end, OrderByComparator<TrashEntry> obc) throws PrincipalException {
        TrashEntryList trashEntriesList = new TrashEntryList();
        int entriesCount = this.trashEntryPersistence.countByGroupId(groupId);
        boolean approximate = false;
        if (entriesCount > PropsValues.TRASH_SEARCH_LIMIT) {
            approximate = true;
        }
        trashEntriesList.setApproximate(approximate);
        List entries = null;
        if (Validator.isNotNull((String)className)) {
            long classNameId = this.classNameLocalService.getClassNameId(className);
            entries = this.trashEntryPersistence.findByG_C(groupId, classNameId, 0, end + PropsValues.TRASH_SEARCH_LIMIT, obc);
        } else {
            entries = this.trashEntryPersistence.findByGroupId(groupId, 0, end + PropsValues.TRASH_SEARCH_LIMIT, obc);
        }
        List<TrashEntry> filteredEntries = this.filterEntries(entries);
        int total = filteredEntries.size();
        if (start == -1 && end == -1) {
            start = 0;
            end = total;
        }
        int[] startAndEnd = SearchPaginationUtil.calculateStartAndEnd((int)start, (int)end, (int)total);
        start = startAndEnd[0];
        end = startAndEnd[1];
        filteredEntries = filteredEntries.subList(start, end);
        trashEntriesList.setArray(TrashEntrySoap.toSoapModels(filteredEntries));
        trashEntriesList.setCount(total);
        trashEntriesList.setOriginalTrashEntries(filteredEntries);
        return trashEntriesList;
    }

    public void moveEntry(String className, long classPK, long destinationContainerModelId, ServiceContext serviceContext) throws PortalException {
        TrashHandler trashHandler;
        PermissionChecker permissionChecker = this.getPermissionChecker();
        long scopeGroupId = 0L;
        if (serviceContext != null) {
            scopeGroupId = serviceContext.getScopeGroupId();
        }
        if (!(trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className)).hasTrashPermission(permissionChecker, scopeGroupId, destinationContainerModelId = trashHandler.getDestinationContainerModelId(classPK, destinationContainerModelId), "MOVE")) {
            throw new TrashPermissionException(3);
        }
        if (trashHandler.isInTrash(classPK) && !trashHandler.hasTrashPermission(permissionChecker, 0L, classPK, "RESTORE")) {
            throw new TrashPermissionException(4);
        }
        TrashEntry trashEntry = (TrashEntry)ModelAdapterUtil.adapt(TrashEntry.class, (Object)trashHandler.getTrashEntry(classPK));
        if (trashEntry.isTrashEntry(className, classPK)) {
            trashHandler.checkRestorableEntry((com.liferay.trash.kernel.model.TrashEntry)ModelAdapterUtil.adapt(com.liferay.trash.kernel.model.TrashEntry.class, (Object)trashEntry), destinationContainerModelId, "");
        } else {
            trashHandler.checkRestorableEntry(classPK, destinationContainerModelId, "");
        }
        trashHandler.moveTrashEntry(this.getUserId(), classPK, destinationContainerModelId, serviceContext);
    }

    public TrashEntry restoreEntry(long entryId) throws PortalException {
        return this.restoreEntry(entryId, 0L, null);
    }

    public TrashEntry restoreEntry(long entryId, long overrideClassPK, String name) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        TrashEntry entry = this.trashEntryPersistence.findByPrimaryKey(entryId);
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entry.getClassName());
        if (!trashHandler.hasTrashPermission(permissionChecker, 0L, entry.getClassPK(), "RESTORE")) {
            throw new TrashPermissionException(4);
        }
        if (overrideClassPK > 0L) {
            if (!trashHandler.hasTrashPermission(permissionChecker, 0L, overrideClassPK, "OVERWRITE")) {
                throw new TrashPermissionException(5);
            }
            trashHandler.deleteTrashEntry(overrideClassPK);
            trashHandler.checkRestorableEntry((com.liferay.trash.kernel.model.TrashEntry)ModelAdapterUtil.adapt(com.liferay.trash.kernel.model.TrashEntry.class, (Object)entry), -1L, null);
        } else if (name != null) {
            if (!trashHandler.hasTrashPermission(permissionChecker, 0L, entry.getClassPK(), "RENAME")) {
                throw new TrashPermissionException(6);
            }
            trashHandler.checkRestorableEntry((com.liferay.trash.kernel.model.TrashEntry)ModelAdapterUtil.adapt(com.liferay.trash.kernel.model.TrashEntry.class, (Object)entry), -1L, name);
            trashHandler.updateTitle(entry.getClassPK(), name);
        }
        trashHandler.restoreTrashEntry(this.getUserId(), entry.getClassPK());
        return entry;
    }

    public TrashEntry restoreEntry(String className, long classPK) throws PortalException {
        return this.restoreEntry(className, classPK, 0L, null);
    }

    public TrashEntry restoreEntry(String className, long classPK, long overrideClassPK, String name) throws PortalException {
        TrashEntry trashEntry = this.trashEntryPersistence.fetchByC_C(this.classNameLocalService.getClassNameId(className), classPK);
        if (trashEntry != null) {
            return this.restoreEntry(trashEntry.getEntryId(), overrideClassPK, name);
        }
        return null;
    }

    protected void deleteEntry(TrashEntry entry) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)entry.getClassName());
        if (!trashHandler.hasTrashPermission(permissionChecker, 0L, entry.getClassPK(), "DELETE")) {
            throw new TrashPermissionException(1);
        }
        trashHandler.deleteTrashEntry(entry.getClassPK());
    }

    protected List<TrashEntry> filterEntries(List<TrashEntry> entries) throws PrincipalException {
        ArrayList<TrashEntry> filteredEntries = new ArrayList<TrashEntry>();
        PermissionChecker permissionChecker = this.getPermissionChecker();
        for (TrashEntry entry : entries) {
            String className = entry.getClassName();
            long classPK = entry.getClassPK();
            try {
                TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
                if (!trashHandler.hasTrashPermission(permissionChecker, 0L, classPK, "VIEW")) continue;
                filteredEntries.add(entry);
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return filteredEntries;
    }
}

