/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.service.http;

import aQute.bnd.annotation.ProviderType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashEntryList;
import com.liferay.trash.model.TrashEntrySoap;
import com.liferay.trash.service.TrashEntryServiceUtil;
import java.rmi.RemoteException;
import java.util.List;

@ProviderType
public class TrashEntryServiceSoap {
    private static Log _log = LogFactoryUtil.getLog(TrashEntryServiceSoap.class);

    public static void deleteEntries(long groupId) throws RemoteException {
        try {
            TrashEntryServiceUtil.deleteEntries((long)groupId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteEntries(long[] entryIds) throws RemoteException {
        try {
            TrashEntryServiceUtil.deleteEntries((long[])entryIds);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteEntry(long entryId) throws RemoteException {
        try {
            TrashEntryServiceUtil.deleteEntry((long)entryId);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void deleteEntry(String className, long classPK) throws RemoteException {
        try {
            TrashEntryServiceUtil.deleteEntry((String)className, (long)classPK);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TrashEntryList getEntries(long groupId) throws RemoteException {
        try {
            TrashEntryList returnValue = TrashEntryServiceUtil.getEntries((long)groupId);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TrashEntryList getEntries(long groupId, int start, int end, OrderByComparator<TrashEntry> obc) throws RemoteException {
        try {
            TrashEntryList returnValue = TrashEntryServiceUtil.getEntries((long)groupId, (int)start, (int)end, obc);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TrashEntrySoap[] getEntries(long groupId, String className) throws RemoteException {
        try {
            List returnValue = TrashEntryServiceUtil.getEntries((long)groupId, (String)className);
            return TrashEntrySoap.toSoapModels((List)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TrashEntryList getEntries(long groupId, String className, int start, int end, OrderByComparator<TrashEntry> obc) throws RemoteException {
        try {
            TrashEntryList returnValue = TrashEntryServiceUtil.getEntries((long)groupId, (String)className, (int)start, (int)end, obc);
            return returnValue;
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static void moveEntry(String className, long classPK, long destinationContainerModelId, ServiceContext serviceContext) throws RemoteException {
        try {
            TrashEntryServiceUtil.moveEntry((String)className, (long)classPK, (long)destinationContainerModelId, (ServiceContext)serviceContext);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TrashEntrySoap restoreEntry(long entryId) throws RemoteException {
        try {
            TrashEntry returnValue = TrashEntryServiceUtil.restoreEntry((long)entryId);
            return TrashEntrySoap.toSoapModel((TrashEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TrashEntrySoap restoreEntry(long entryId, long overrideClassPK, String name) throws RemoteException {
        try {
            TrashEntry returnValue = TrashEntryServiceUtil.restoreEntry((long)entryId, (long)overrideClassPK, (String)name);
            return TrashEntrySoap.toSoapModel((TrashEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TrashEntrySoap restoreEntry(String className, long classPK) throws RemoteException {
        try {
            TrashEntry returnValue = TrashEntryServiceUtil.restoreEntry((String)className, (long)classPK);
            return TrashEntrySoap.toSoapModel((TrashEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public static TrashEntrySoap restoreEntry(String className, long classPK, long overrideClassPK, String name) throws RemoteException {
        try {
            TrashEntry returnValue = TrashEntryServiceUtil.restoreEntry((String)className, (long)classPK, (long)overrideClassPK, (String)name);
            return TrashEntrySoap.toSoapModel((TrashEntry)returnValue);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }
}

