/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.trash.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.model.TrashVersion;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import java.text.Format;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={TrashHelper.class})
public class TrashHelperImpl
implements TrashHelper {
    private static final String _TRASH_PREFIX = "/";
    private static final Log _log = LogFactoryUtil.getLog(TrashHelperImpl.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private TrashEntryLocalService _trashEntryLocalService;
    @Reference
    private TrashVersionLocalService _trashVersionLocalService;

    public int getMaxAge(Group group) {
        int trashEntriesMaxAge = PrefsPropsUtil.getInteger((long)group.getCompanyId(), (String)"trash.entries.max.age", (int)PropsValues.TRASH_ENTRIES_MAX_AGE);
        UnicodeProperties typeSettingsProperties = group.getParentLiveGroupTypeSettingsProperties();
        return GetterUtil.getInteger((String)typeSettingsProperties.getProperty("trashEntriesMaxAge"), (int)trashEntriesMaxAge);
    }

    public String getNewName(ThemeDisplay themeDisplay, String className, long classPK, String oldName) throws PortalException {
        TrashRenderer trashRenderer = null;
        if (Validator.isNotNull((String)className) && classPK > 0L) {
            TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
            trashRenderer = trashHandler.getTrashRenderer(classPK);
        }
        StringBundler sb = new StringBundler(3);
        sb.append("(");
        Format format = FastDateFormatFactoryUtil.getDateTime((Locale)themeDisplay.getLocale(), (TimeZone)themeDisplay.getTimeZone());
        sb.append(StringUtil.replace((String)format.format(new Date()), (char[])new char[]{'/', ':'}, (char[])new char[]{'.', '.'}));
        sb.append(")");
        if (trashRenderer != null) {
            return trashRenderer.getNewName(oldName, sb.toString());
        }
        return this._getNewName(oldName, sb.toString());
    }

    public String getOriginalTitle(String title) {
        return this._getOriginalTitle(title, "title", _TRASH_PREFIX);
    }

    public String getTrashTitle(long entryId) {
        return this._getTrashTitle(entryId, _TRASH_PREFIX);
    }

    public PortletURL getViewContentURL(HttpServletRequest request, String className, long classPK) throws PortalException {
        TrashRenderer trashRenderer;
        TrashHandler trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        if (trashHandler.isInTrashContainer(classPK)) {
            com.liferay.trash.kernel.model.TrashEntry trashEntry = trashHandler.getTrashEntry(classPK);
            className = trashEntry.getClassName();
            classPK = trashEntry.getClassPK();
            trashHandler = TrashHandlerRegistryUtil.getTrashHandler((String)className);
        }
        if ((trashRenderer = trashHandler.getTrashRenderer(classPK)) == null) {
            return null;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = PortletProviderUtil.getPortletURL((HttpServletRequest)request, (String)TrashEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        portletURL.setParameter("mvcPath", "/view_content.jsp");
        portletURL.setParameter("redirect", themeDisplay.getURLCurrent());
        TrashEntry trashEntry = this._trashEntryLocalService.getEntry(className, classPK);
        if (trashEntry.getRootEntry() != null) {
            portletURL.setParameter("className", className);
            portletURL.setParameter("classPK", String.valueOf(classPK));
        } else {
            portletURL.setParameter("trashEntryId", String.valueOf(trashEntry.getEntryId()));
        }
        portletURL.setParameter("showAssetMetadata", Boolean.TRUE.toString());
        return portletURL;
    }

    public boolean isTrashEnabled(Group group) {
        boolean companyTrashEnabled = PrefsPropsUtil.getBoolean((long)group.getCompanyId(), (String)"trash.enabled");
        if (!companyTrashEnabled) {
            return false;
        }
        UnicodeProperties typeSettingsProperties = group.getParentLiveGroupTypeSettingsProperties();
        return GetterUtil.getBoolean((String)typeSettingsProperties.getProperty("trashEnabled"), (boolean)true);
    }

    public boolean isTrashEnabled(long groupId) throws PortalException {
        return this.isTrashEnabled(this._groupLocalService.getGroup(groupId));
    }

    private String _getNewName(String oldName, String token) {
        StringBundler sb = new StringBundler(3);
        sb.append(oldName);
        sb.append(" ");
        sb.append(token);
        return sb.toString();
    }

    private String _getOriginalTitle(String title, String paramName, String prefix) {
        block6: {
            if (!this._isValidTrashTitle(title, prefix)) {
                return title;
            }
            long trashEntryId = GetterUtil.getLong((String)(title = title.substring(prefix.length())));
            if (trashEntryId <= 0L) {
                return title;
            }
            try {
                TrashEntry trashEntry = this._trashEntryLocalService.fetchEntry(trashEntryId);
                if (trashEntry == null) {
                    TrashVersion trashVersion = this._trashVersionLocalService.getTrashVersion(trashEntryId);
                    title = trashVersion.getTypeSettingsProperty(paramName);
                } else {
                    title = trashEntry.getTypeSettingsProperty(paramName);
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Object)("No trash entry or trash version exists with ID " + trashEntryId));
            }
        }
        return title;
    }

    private String _getTrashTitle(long trashEntryId, String prefix) {
        return prefix.concat(String.valueOf(trashEntryId));
    }

    private boolean _isValidTrashTitle(String title, String prefix) {
        return title.startsWith(prefix);
    }
}

