/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.google.cloud.translator.internal.upgrade.v1_0_0;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.translation.google.cloud.translator.internal.configuration.GoogleCloudTranslatorConfiguration;
import java.util.Dictionary;
import java.util.Hashtable;

public class GoogleCloudTranslatorConfigurationUpgradeProcess
extends UpgradeProcess {
    private final CompanyLocalService _companyLocalService;
    private final ConfigurationProvider _configurationProvider;
    private final GoogleCloudTranslatorConfiguration _googleCloudTranslatorConfiguration = (GoogleCloudTranslatorConfiguration)ConfigurableUtil.createConfigurable(GoogleCloudTranslatorConfiguration.class, (Dictionary)new HashMapDictionary());

    public GoogleCloudTranslatorConfigurationUpgradeProcess(CompanyLocalService companyLocalService, ConfigurationProvider configurationProvider) {
        this._companyLocalService = companyLocalService;
        this._configurationProvider = configurationProvider;
    }

    protected void doUpgrade() throws Exception {
        this._upgradeConfiguration();
    }

    private void _upgradeConfiguration() throws Exception {
        if (this._googleCloudTranslatorConfiguration.enabled()) {
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("enabled", Boolean.TRUE);
            ((Dictionary)properties).put("serviceAccountPrivateKey", this._googleCloudTranslatorConfiguration.serviceAccountPrivateKey());
            this._companyLocalService.forEachCompanyId(companyId -> this._configurationProvider.saveCompanyConfiguration(GoogleCloudTranslatorConfiguration.class, companyId.longValue(), properties));
        }
    }
}

