/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.google.cloud.translator.internal.translator;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.translate.Language;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.translation.exception.TranslatorException;
import com.liferay.translation.google.cloud.translator.internal.configuration.GoogleCloudTranslatorConfiguration;
import com.liferay.translation.translator.Translator;
import com.liferay.translation.translator.TranslatorPacket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.translation.google.cloud.translator.internal.configuration.GoogleCloudTranslatorConfiguration"}, service={Translator.class})
public class GoogleCloudTranslator
implements Translator {
    private static final Log _log = LogFactoryUtil.getLog(GoogleCloudTranslator.class);
    @Reference
    private ConfigurationProvider _configurationProvider;

    @Deprecated
    public boolean isEnabled() {
        try {
            return this.isEnabled(CompanyThreadLocal.getCompanyId());
        }
        catch (ConfigurationException configurationException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)configurationException, (Throwable)configurationException);
            }
            return false;
        }
    }

    public boolean isEnabled(long companyId) throws ConfigurationException {
        GoogleCloudTranslatorConfiguration googleCloudTranslatorCompanyConfiguration = (GoogleCloudTranslatorConfiguration)this._configurationProvider.getCompanyConfiguration(GoogleCloudTranslatorConfiguration.class, companyId);
        return googleCloudTranslatorCompanyConfiguration.enabled() && !Validator.isBlank((String)googleCloudTranslatorCompanyConfiguration.serviceAccountPrivateKey());
    }

    public TranslatorPacket translate(final TranslatorPacket translatorPacket) throws PortalException {
        if (!this.isEnabled(translatorPacket.getCompanyId())) {
            return translatorPacket;
        }
        String sourceLanguageCode = this._getLanguageCode(translatorPacket.getSourceLanguageId());
        String targetLanguageCode = this._getLanguageCode(translatorPacket.getTargetLanguageId());
        Translate translate = this._getTranslate(translatorPacket.getCompanyId());
        Set<String> supportedLanguageCodes = this._getSupportedLanguageCodes(translate.listSupportedLanguages(new Translate.LanguageListOption[0]));
        if (!supportedLanguageCodes.contains(sourceLanguageCode) || !supportedLanguageCodes.contains(targetLanguageCode)) {
            throw new TranslatorException("Translation between the selected languages is not supported");
        }
        Map fieldsMap = translatorPacket.getFieldsMap();
        List translations = translate.translate(new ArrayList(fieldsMap.values()), new Translate.TranslateOption[]{Translate.TranslateOption.sourceLanguage((String)sourceLanguageCode), Translate.TranslateOption.targetLanguage((String)targetLanguageCode)});
        final HashMap<String, String> translationFieldsMap = new HashMap<String, String>();
        Iterator iterator = translations.iterator();
        for (String key : fieldsMap.keySet()) {
            Translation translation = (Translation)iterator.next();
            translationFieldsMap.put(key, translation.getTranslatedText());
        }
        return new TranslatorPacket(){

            public long getCompanyId() {
                return translatorPacket.getCompanyId();
            }

            public Map<String, String> getFieldsMap() {
                return translationFieldsMap;
            }

            public String getSourceLanguageId() {
                return translatorPacket.getSourceLanguageId();
            }

            public String getTargetLanguageId() {
                return translatorPacket.getTargetLanguageId();
            }
        };
    }

    private String _getLanguageCode(String languageId) {
        List list = StringUtil.split((String)languageId, (char)'_');
        return (String)list.get(0);
    }

    private Set<String> _getSupportedLanguageCodes(List<Language> supportedLanguages) {
        Stream stream = supportedLanguages.stream();
        return stream.map(Language::getCode).collect(Collectors.toSet());
    }

    private Translate _getTranslate(long companyId) throws ConfigurationException {
        GoogleCloudTranslatorConfiguration googleCloudTranslatorCompanyConfiguration = (GoogleCloudTranslatorConfiguration)this._configurationProvider.getCompanyConfiguration(GoogleCloudTranslatorConfiguration.class, companyId);
        String serviceAccountPrivateKey = googleCloudTranslatorCompanyConfiguration.serviceAccountPrivateKey();
        ServiceAccountCredentials serviceAccountCredentials = null;
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(serviceAccountPrivateKey.getBytes());){
            serviceAccountCredentials = ServiceAccountCredentials.fromStream((InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SystemException("Unable to authenticate with Google Cloud", (Throwable)ioException);
        }
        TranslateOptions.DefaultTranslateFactory defaultTranslateFactory = new TranslateOptions.DefaultTranslateFactory();
        return defaultTranslateFactory.create(((TranslateOptions.Builder)TranslateOptions.newBuilder().setCredentials((Credentials)serviceAccountCredentials)).build());
    }
}

