/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.google.cloud.translator.internal.translator;

import com.google.auth.Credentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.translate.Language;
import com.google.cloud.translate.Translate;
import com.google.cloud.translate.TranslateOptions;
import com.google.cloud.translate.Translation;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.translation.exception.TranslatorException;
import com.liferay.translation.google.cloud.translator.internal.configuration.GoogleCloudTranslatorConfiguration;
import com.liferay.translation.translator.Translator;
import com.liferay.translation.translator.TranslatorPacket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(configurationPid={"com.liferay.translation.google.cloud.translator.internal.configuration.GoogleCloudTranslatorConfiguration"}, service={Translator.class})
public class GoogleCloudTranslator
implements Translator {
    private GoogleCloudTranslatorConfiguration _googleCloudTranslatorConfiguration;
    private Set<String> _supportedLanguageCodes;
    private Translate _translate;

    public boolean isEnabled() {
        return this._googleCloudTranslatorConfiguration.enabled() && !Validator.isBlank((String)this._googleCloudTranslatorConfiguration.serviceAccountPrivateKey());
    }

    public TranslatorPacket translate(final TranslatorPacket translatorPacket) throws PortalException {
        if (!this.isEnabled()) {
            return translatorPacket;
        }
        String sourceLanguageCode = this._getLanguageCode(translatorPacket.getSourceLanguageId());
        String targetLanguageCode = this._getLanguageCode(translatorPacket.getTargetLanguageId());
        if (!this._supportedLanguageCodes.contains(sourceLanguageCode) || !this._supportedLanguageCodes.contains(targetLanguageCode)) {
            throw new TranslatorException("Translation between the selected languages is not supported");
        }
        Map fieldsMap = translatorPacket.getFieldsMap();
        List translations = this._translate.translate(new ArrayList(fieldsMap.values()), new Translate.TranslateOption[]{Translate.TranslateOption.sourceLanguage((String)sourceLanguageCode), Translate.TranslateOption.targetLanguage((String)targetLanguageCode)});
        final HashMap<String, String> translationFieldsMap = new HashMap<String, String>();
        Iterator iterator = translations.iterator();
        for (String key : fieldsMap.keySet()) {
            Translation translation = (Translation)iterator.next();
            translationFieldsMap.put(key, translation.getTranslatedText());
        }
        return new TranslatorPacket(){

            public Map<String, String> getFieldsMap() {
                return translationFieldsMap;
            }

            public String getSourceLanguageId() {
                return translatorPacket.getSourceLanguageId();
            }

            public String getTargetLanguageId() {
                return translatorPacket.getTargetLanguageId();
            }
        };
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._googleCloudTranslatorConfiguration = (GoogleCloudTranslatorConfiguration)ConfigurableUtil.createConfigurable(GoogleCloudTranslatorConfiguration.class, properties);
        if (!this.isEnabled()) {
            return;
        }
        ServiceAccountCredentials serviceAccountCredentials = null;
        String serviceAccountPrivateKey = this._googleCloudTranslatorConfiguration.serviceAccountPrivateKey();
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(serviceAccountPrivateKey.getBytes());){
            serviceAccountCredentials = ServiceAccountCredentials.fromStream((InputStream)inputStream);
        }
        catch (IOException ioException) {
            throw new SystemException("Unable to authenticate with Google Cloud", (Throwable)ioException);
        }
        TranslateOptions.DefaultTranslateFactory defaultTranslateFactory = new TranslateOptions.DefaultTranslateFactory();
        this._translate = defaultTranslateFactory.create(((TranslateOptions.Builder)TranslateOptions.newBuilder().setCredentials((Credentials)serviceAccountCredentials)).build());
        List supportedLanguages = this._translate.listSupportedLanguages(new Translate.LanguageListOption[0]);
        Stream stream = supportedLanguages.stream();
        this._supportedLanguageCodes = stream.map(Language::getCode).collect(Collectors.toSet());
    }

    private String _getLanguageCode(String languageId) {
        List list = StringUtil.split((String)languageId, (char)'_');
        return (String)list.get(0);
    }
}

