/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.translation.google.cloud.translator.internal.configuration.persistence.listener;

import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListener;
import com.liferay.portal.configuration.persistence.listener.ConfigurationModelListenerException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.translation.google.cloud.translator.internal.configuration.GoogleCloudTranslatorConfiguration;
import java.util.Dictionary;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.translation.google.cloud.translator.internal.configuration.GoogleCloudTranslatorConfiguration"}, service={ConfigurationModelListener.class})
public class GoogleCloudTranslatorConfigurationModelListener
implements ConfigurationModelListener {
    @Reference(target="(bundle.symbolic.name=com.liferay.translation.google.cloud.translator)")
    private ResourceBundleLoader _resourceBundleLoader;

    public void onBeforeSave(String pid, Dictionary<String, Object> properties) throws ConfigurationModelListenerException {
        boolean enabled = GetterUtil.getBoolean((Object)properties.get("enabled"));
        String serviceAccountPrivateKey = GetterUtil.getString((Object)properties.get("serviceAccountPrivateKey"));
        if (enabled && !this._isValid(serviceAccountPrivateKey)) {
            throw new ConfigurationModelListenerException(ResourceBundleUtil.getString((ResourceBundle)this._resourceBundleLoader.loadResourceBundle(LocaleThreadLocal.getThemeDisplayLocale()), (String)"the-service-account-private-key-must-be-in-json-format"), GoogleCloudTranslatorConfiguration.class, this.getClass(), properties);
        }
    }

    private boolean _isValid(String serviceAccountPrivateKey) {
        try {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)serviceAccountPrivateKey);
            return jsonObject.length() > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

