/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.internal.transformer;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.provider.InfoItemFormProvider;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.templateparser.Transformer;
import com.liferay.template.model.TemplateEntry;
import com.liferay.template.transformer.TemplateNodeFactory;
import java.util.HashMap;
import java.util.Map;

public class TemplateDisplayTemplateTransformer {
    private final InfoItemFieldValues _infoItemFieldValues;
    private final TemplateEntry _templateEntry;
    private final TemplateNodeFactory _templateNodeFactory;

    public TemplateDisplayTemplateTransformer(TemplateEntry templateEntry, InfoItemFieldValues infoItemFieldValues, TemplateNodeFactory templateNodeFactory) {
        this._templateEntry = templateEntry;
        this._infoItemFieldValues = infoItemFieldValues;
        this._templateNodeFactory = templateNodeFactory;
    }

    public String transform(ThemeDisplay themeDisplay) throws Exception {
        if (themeDisplay == null) {
            return "";
        }
        Transformer transformer = TransformerHolder.getTransformer();
        HashMap contextObjects = HashMapBuilder.put((Object)"currentURL", (Object)themeDisplay.getURLCurrent()).put((Object)"locale", (Object)themeDisplay.getLocale()).put((Object)"themeDisplay", (Object)themeDisplay).build();
        for (InfoFieldValue infoFieldValue : this._infoItemFieldValues.getInfoFieldValues()) {
            TemplateNode templateNode;
            InfoField infoField = infoFieldValue.getInfoField();
            if (StringUtil.startsWith((String)infoField.getName(), (String)"ddmTemplate_")) continue;
            if (infoField.isRepeatable()) {
                TemplateNode siblingTemplateNode = this._templateNodeFactory.createTemplateNode(infoFieldValue, themeDisplay);
                templateNode = (TemplateNode)contextObjects.computeIfAbsent(infoField.getName(), key -> siblingTemplateNode);
                templateNode.appendSibling(siblingTemplateNode);
            } else {
                templateNode = this._templateNodeFactory.createTemplateNode(infoFieldValue, themeDisplay);
            }
            contextObjects.put(infoField.getName(), templateNode);
            contextObjects.put(infoField.getUniqueId(), templateNode);
        }
        TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((String)InfoItemFormProvider.class.getName());
        contextObjects.putAll(templateHandler.getCustomContextObjects());
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.fetchDDMTemplate((long)this._templateEntry.getDDMTemplateId());
        return transformer.transform(themeDisplay, (Map)contextObjects, ddmTemplate.getScript(), "ftl", new UnsyncStringWriter(), themeDisplay.getRequest(), themeDisplay.getResponse());
    }

    private static class TransformerHolder {
        private static final Transformer _transformer = new Transformer("", true){

            protected String getErrorTemplateId(String errorTemplatePropertyKey, String langType) {
                return "com/liferay/template/service/internal/transformer/dependencies/error.ftl";
            }
        };

        private TransformerHolder() {
        }

        public static Transformer getTransformer() {
            return _transformer;
        }
    }
}

