/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.internal.info.item.renderer;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.provider.InfoItemObjectVariationProvider;
import com.liferay.info.item.renderer.InfoItemTemplatedRenderer;
import com.liferay.info.item.renderer.template.InfoItemRendererTemplate;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.template.internal.transformer.TemplateDisplayTemplateTransformer;
import com.liferay.template.model.TemplateEntry;
import com.liferay.template.service.TemplateEntryLocalService;
import com.liferay.template.transformer.TemplateNodeFactory;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateInfoItemTemplatedRenderer<T>
implements InfoItemTemplatedRenderer<T> {
    private final String _className;
    private final DDMTemplateLocalService _ddmTemplateLocalService;
    private final InfoItemServiceRegistry _infoItemServiceRegistry;
    private final StagingGroupHelper _stagingGroupHelper;
    private final TemplateEntryLocalService _templateEntryLocalService;
    private final TemplateNodeFactory _templateNodeFactory;

    public TemplateInfoItemTemplatedRenderer(String className, DDMTemplateLocalService ddmTemplateLocalService, InfoItemServiceRegistry infoItemServiceRegistry, StagingGroupHelper stagingGroupHelper, TemplateEntryLocalService templateEntryLocalService, TemplateNodeFactory templateNodeFactory) {
        this._className = className;
        this._ddmTemplateLocalService = ddmTemplateLocalService;
        this._infoItemServiceRegistry = infoItemServiceRegistry;
        this._stagingGroupHelper = stagingGroupHelper;
        this._templateEntryLocalService = templateEntryLocalService;
        this._templateNodeFactory = templateNodeFactory;
    }

    public List<InfoItemRendererTemplate> getInfoItemRendererTemplates(String className, String classTypeKey, Locale locale) {
        if (!Objects.equals(this._className, className)) {
            return Collections.emptyList();
        }
        ArrayList<InfoItemRendererTemplate> infoItemRendererTemplates = new ArrayList<InfoItemRendererTemplate>();
        for (TemplateEntry templateEntry : this._getTemplateEntries(this._className, classTypeKey)) {
            DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchTemplate(templateEntry.getDDMTemplateId());
            infoItemRendererTemplates.add(new InfoItemRendererTemplate(ddmTemplate.getName(locale), String.valueOf(templateEntry.getTemplateEntryId())));
        }
        return infoItemRendererTemplates;
    }

    public List<InfoItemRendererTemplate> getInfoItemRendererTemplates(T t, Locale locale) {
        String infoItemFormVariationKey = "";
        InfoItemObjectVariationProvider infoItemObjectVariationProvider = (InfoItemObjectVariationProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemObjectVariationProvider.class, this._className);
        if (infoItemObjectVariationProvider != null) {
            infoItemFormVariationKey = infoItemObjectVariationProvider.getInfoItemFormVariationKey(t);
        }
        return this.getInfoItemRendererTemplates(this._className, infoItemFormVariationKey, locale);
    }

    public String getLabel(Locale locale) {
        return LanguageUtil.get((Locale)locale, (String)"templates");
    }

    public void render(T t, String templateEntryId, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return;
        }
        try {
            PrintWriter writer = httpServletResponse.getWriter();
            TemplateEntry templateEntry = this._templateEntryLocalService.fetchTemplateEntry(GetterUtil.getLong((String)templateEntryId));
            InfoItemFieldValues infoItemFieldValues = InfoItemFieldValues.builder().build();
            InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesProvider.class, templateEntry.getInfoItemClassName());
            if (infoItemFieldValuesProvider != null) {
                infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues(t);
            }
            TemplateDisplayTemplateTransformer templateDisplayTemplateTransformer = new TemplateDisplayTemplateTransformer(templateEntry, infoItemFieldValues, this._templateNodeFactory);
            ((Writer)writer).write(templateDisplayTemplateTransformer.transform(serviceContext.getThemeDisplay()));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private List<TemplateEntry> _getTemplateEntries(String infoItemClassName, String infoItemFormVariationKey) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return Collections.emptyList();
        }
        return this._templateEntryLocalService.getTemplateEntries(PortalUtil.getCurrentAndAncestorSiteGroupIds((long)this._stagingGroupHelper.getStagedPortletGroupId(serviceContext.getScopeGroupId(), "com_liferay_template_web_internal_portlet_TemplatePortlet")), infoItemClassName, infoItemFormVariationKey, -1, -1, null);
    }
}

