/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.internal.info.field.transformer;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.OptionInfoFieldType;
import com.liferay.info.type.KeyLocalizedLabelPair;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.template.info.field.transformer.BaseTemplateNodeTransformer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseSelectInfoFieldTypeTemplateNodeTransformer
extends BaseTemplateNodeTransformer {
    @Reference
    protected JSONFactory jsonFactory;

    public TemplateNode transform(InfoFieldValue<Object> infoFieldValue, ThemeDisplay themeDisplay) {
        InfoField infoField = infoFieldValue.getInfoField();
        List<Object> optionInfoFieldTypes = this.getOptionInfoFieldTypes(infoField);
        if (optionInfoFieldTypes == null) {
            optionInfoFieldTypes = Collections.emptyList();
        }
        LinkedHashMap<String, String> optionsMap = new LinkedHashMap<String, String>();
        for (OptionInfoFieldType optionInfoFieldType : optionInfoFieldTypes) {
            optionsMap.put(optionInfoFieldType.getValue(), optionInfoFieldType.getLabel(themeDisplay.getLocale()));
        }
        InfoFieldType infoFieldType = infoField.getInfoFieldType();
        JSONArray jSONArray = this.getSelectedOptionValuesJSONArray(infoFieldValue, themeDisplay.getLocale());
        String data = this.getData(optionsMap, jSONArray);
        TemplateNode templateNode = new TemplateNode(themeDisplay, infoField.getName(), data, infoFieldType.getName(), this.getAttributes());
        templateNode.appendOptionsMap(optionsMap);
        templateNode.put((Object)"key", (Object)this.getKey(jSONArray));
        templateNode.put((Object)"label", (Object)this.getLabel(optionsMap, jSONArray));
        return templateNode;
    }

    protected abstract Map<String, String> getAttributes();

    protected String getData(Map<String, String> optionsMap, JSONArray selectedOptionValuesJSONArray) {
        return this.getKey(selectedOptionValuesJSONArray);
    }

    protected abstract String getKey(JSONArray var1);

    protected abstract String getLabel(Map<String, String> var1, JSONArray var2);

    protected abstract List<OptionInfoFieldType> getOptionInfoFieldTypes(InfoField var1);

    protected JSONArray getSelectedOptionValuesJSONArray(InfoFieldValue<Object> infoFieldValue, Locale locale) {
        Object value = infoFieldValue.getValue(locale);
        if (!(value instanceof List)) {
            return this.jsonFactory.createJSONArray();
        }
        JSONArray selectedOptionValuesJSONArray = this.jsonFactory.createJSONArray();
        List keyLocalizedLabelPairs = (List)value;
        for (KeyLocalizedLabelPair keyLocalizedLabelPair : keyLocalizedLabelPairs) {
            selectedOptionValuesJSONArray.put(keyLocalizedLabelPair.getKey());
        }
        return selectedOptionValuesJSONArray;
    }
}

