/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.internal.info.item.provider;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSet;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.HTMLInfoFieldType;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.template.info.item.provider.TemplateInfoItemFieldSetProvider;
import com.liferay.template.internal.transformer.TemplateDisplayTemplateTransformer;
import com.liferay.template.model.TemplateEntry;
import com.liferay.template.service.TemplateEntryLocalService;
import com.liferay.template.transformer.TemplateNodeFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={TemplateInfoItemFieldSetProvider.class})
public class TemplateInfoItemFieldSetProviderImpl
implements TemplateInfoItemFieldSetProvider {
    private static final Log _log = LogFactoryUtil.getLog(TemplateInfoItemFieldSetProviderImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;
    @Reference
    private TemplateEntryLocalService _templateEntryLocalService;
    @Reference
    private TemplateNodeFactory _templateNodeFactory;

    public InfoFieldSet getInfoFieldSet(String infoItemClassName, String infoItemFormVariationKey) {
        return InfoFieldSet.builder().infoFieldSetEntry(consumer -> {
            for (TemplateEntry templateEntry : this._getTemplateEntries(infoItemClassName, infoItemFormVariationKey)) {
                consumer.accept(this._getInfoField(templateEntry));
            }
        }).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"templates")).name("templates").build();
    }

    public List<InfoFieldValue<Object>> getInfoFieldValues(String infoItemClassName, String infoItemFormVariationKey, Object itemObject) {
        ArrayList<InfoFieldValue<Object>> infoFieldValues = new ArrayList<InfoFieldValue<Object>>();
        for (TemplateEntry templateEntry : this._getTemplateEntries(infoItemClassName, infoItemFormVariationKey)) {
            infoFieldValues.add((InfoFieldValue<Object>)new InfoFieldValue(this._getInfoField(templateEntry), () -> InfoLocalizedValue.function(locale -> this._getValue(itemObject, (Locale)locale, templateEntry))));
        }
        return infoFieldValues;
    }

    private InfoField<?> _getInfoField(TemplateEntry templateEntry) {
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchDDMTemplate(templateEntry.getDDMTemplateId());
        return InfoField.builder().infoFieldType((InfoFieldType)HTMLInfoFieldType.INSTANCE).namespace("ddmTemplate_").name("ddmTemplate_" + templateEntry.getTemplateEntryId()).labelInfoLocalizedValue(InfoLocalizedValue.builder().defaultLocale(LocaleUtil.fromLanguageId((String)ddmTemplate.getDefaultLanguageId())).values(ddmTemplate.getNameMap()).build()).build();
    }

    private List<TemplateEntry> _getTemplateEntries(String infoItemClassName, String infoItemFormVariationKey) throws RuntimeException {
        long ddmStructureKey;
        DDMStructure ddmStructure;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return Collections.emptyList();
        }
        HashSet<Long> groupIds = new HashSet<Long>();
        Company company = this._companyLocalService.fetchCompany(serviceContext.getCompanyId());
        if (company != null) {
            groupIds.add(company.getGroupId());
        }
        if ((ddmStructure = this._ddmStructureLocalService.fetchStructure(ddmStructureKey = GetterUtil.getLong((String)infoItemFormVariationKey))) != null) {
            groupIds.add(ddmStructure.getGroupId());
        }
        groupIds.add(this._stagingGroupHelper.getStagedPortletGroupId(serviceContext.getScopeGroupId(), "com_liferay_template_web_internal_portlet_TemplatePortlet"));
        try {
            return this._templateEntryLocalService.getTemplateEntries(ArrayUtil.toLongArray(groupIds), infoItemClassName, infoItemFormVariationKey, -1, -1, null);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _getValue(Object itemObject, Locale locale, TemplateEntry templateEntry) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null || serviceContext.getThemeDisplay() == null) {
            return "";
        }
        ThemeDisplay currentThemeDisplay = serviceContext.getThemeDisplay();
        ThemeDisplay themeDisplay = null;
        try {
            themeDisplay = (ThemeDisplay)currentThemeDisplay.clone();
            themeDisplay.setLocale(locale);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            _log.error((Object)"Unable to clone theme display", (Throwable)cloneNotSupportedException);
        }
        if (themeDisplay == null) {
            return "";
        }
        InfoItemFieldValues infoItemFieldValues = InfoItemFieldValues.builder().build();
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesProvider.class, templateEntry.getInfoItemClassName());
        if (infoItemFieldValuesProvider != null) {
            infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues(itemObject);
        }
        TemplateDisplayTemplateTransformer templateDisplayTemplateTransformer = new TemplateDisplayTemplateTransformer(templateEntry, infoItemFieldValues, this._templateNodeFactory);
        try {
            String string = templateDisplayTemplateTransformer.transform(themeDisplay);
            return string;
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to transform template", (Throwable)exception);
        }
        finally {
            themeDisplay.setLocale(currentThemeDisplay.getLocale());
        }
        return "";
    }
}

