/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.internal.transformer;

import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.osgi.service.tracker.collections.map.PropertyServiceReferenceComparator;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.template.info.field.transformer.TemplateNodeTransformer;
import com.liferay.template.transformer.TemplateNodeFactory;
import java.util.Comparator;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={TemplateNodeFactory.class})
public class TemplateNodeFactoryImpl
implements TemplateNodeFactory {
    private static final String _CLASS_NAME_ANY = "<ANY>";
    private ServiceTrackerMap<String, TemplateNodeTransformer> _serviceTrackerMap;

    public TemplateNode createTemplateNode(InfoFieldValue<Object> infoFieldValue, ThemeDisplay themeDisplay) {
        InfoField infoField = infoFieldValue.getInfoField();
        InfoFieldType infoFieldType = infoField.getInfoFieldType();
        Class<?> infoFieldTypeClass = infoFieldType.getClass();
        TemplateNodeTransformer templateNodeTransformer = this._getTemplateNodeTransformer(infoFieldTypeClass.getName());
        return templateNodeTransformer.transform(infoFieldValue, themeDisplay);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, TemplateNodeTransformer.class, null, (serviceReference, emitter) -> {
            try {
                List classNames = StringUtil.asList((Object)serviceReference.getProperty("info.field.type.class.name"));
                for (String className : classNames) {
                    emitter.emit((Object)className);
                }
                if (classNames.isEmpty()) {
                    emitter.emit((Object)_CLASS_NAME_ANY);
                }
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        }, (Comparator)new PropertyServiceReferenceComparator("service.ranking"));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }

    private TemplateNodeTransformer _getTemplateNodeTransformer(String className) {
        TemplateNodeTransformer templateNodeTransformer = (TemplateNodeTransformer)this._serviceTrackerMap.getService((Object)className);
        if (templateNodeTransformer != null) {
            return templateNodeTransformer;
        }
        return (TemplateNodeTransformer)this._serviceTrackerMap.getService((Object)_CLASS_NAME_ANY);
    }
}

