/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.template.model.impl;

import com.liferay.template.model.TemplateEntry;
import com.liferay.template.service.TemplateEntryLocalServiceUtil;

/**
 * The extended model base implementation for the TemplateEntry service. Represents a row in the &quot;TemplateEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link TemplateEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see TemplateEntryImpl
 * @see TemplateEntry
 * @generated
 */
public abstract class TemplateEntryBaseImpl
	extends TemplateEntryModelImpl implements TemplateEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a template entry model instance should use the <code>TemplateEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			TemplateEntryLocalServiceUtil.addTemplateEntry(this);
		}
		else {
			TemplateEntryLocalServiceUtil.updateTemplateEntry(this);
		}
	}

}