/**
 * SPDX-FileCopyrightText: (c) 2024 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.template.internal.info.field.transformer;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.template.info.field.transformer.TemplateNodeTransformer;

import java.util.Map;

import org.osgi.service.component.annotations.Component;

/**
 * @author Lourdes Fernández Besada
 */
@Component(
	property = "info.field.type.class.name=com.liferay.info.field.type.PicklistSelectInfoFieldType",
	service = TemplateNodeTransformer.class
)
public class PicklistSelectInfoFieldTypeTemplateNodeTransformer
	extends SelectInfoFieldTypeTemplateNodeTransformer {

	@Override
	protected String getData(
		Map<String, String> optionsMap,
		JSONArray selectedOptionValuesJSONArray) {

		return getLabel(optionsMap, selectedOptionValuesJSONArray);
	}

}