/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.internal.exportimport.staged.model.repository;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryHelper;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.template.model.TemplateEntry;
import com.liferay.template.service.TemplateEntryLocalService;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.template.model.TemplateEntry"}, service={StagedModelRepository.class})
public class TemplateEntryStagedModelRepository
implements StagedModelRepository<TemplateEntry> {
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private StagedModelRepositoryHelper _stagedModelRepositoryHelper;
    @Reference
    private TemplateEntryLocalService _templateEntryLocalService;

    public TemplateEntry addStagedModel(PortletDataContext portletDataContext, TemplateEntry templateEntry) throws PortalException {
        long userId = portletDataContext.getUserId(templateEntry.getUserUuid());
        Map ddmTemplateIds = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class);
        long ddmTemplateId = MapUtil.getLong((Map)ddmTemplateIds, (long)templateEntry.getDDMTemplateId(), (long)templateEntry.getDDMTemplateId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)templateEntry);
        if (portletDataContext.isDataStrategyMirror()) {
            serviceContext.setUuid(templateEntry.getUuid());
        }
        return this._templateEntryLocalService.addTemplateEntry(templateEntry.getExternalReferenceCode(), userId, templateEntry.getGroupId(), ddmTemplateId, templateEntry.getInfoItemClassName(), templateEntry.getInfoItemFormVariationKey(), serviceContext);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        TemplateEntry templateEntry = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (templateEntry != null) {
            this.deleteStagedModel(templateEntry);
        }
    }

    public void deleteStagedModel(TemplateEntry templateEntry) throws PortalException {
        this._ddmTemplateLocalService.deleteTemplate(templateEntry.getDDMTemplateId());
        this._templateEntryLocalService.deleteTemplateEntry(templateEntry);
    }

    public void deleteStagedModels(PortletDataContext portletDataContext) throws PortalException {
    }

    public TemplateEntry fetchMissingReference(String uuid, long groupId) {
        return (TemplateEntry)this._stagedModelRepositoryHelper.fetchMissingReference(uuid, groupId, (StagedModelRepository)this);
    }

    public TemplateEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._templateEntryLocalService.fetchTemplateEntryByUuidAndGroupId(uuid, groupId);
    }

    public List<TemplateEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._templateEntryLocalService.getTemplateEntriesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(PortletDataContext portletDataContext) {
        return this._templateEntryLocalService.getExportActionableDynamicQuery(portletDataContext);
    }

    public TemplateEntry getStagedModel(long templateEntryId) throws PortalException {
        return this._templateEntryLocalService.getTemplateEntry(templateEntryId);
    }

    public TemplateEntry saveStagedModel(TemplateEntry templateEntry) throws PortalException {
        return this._templateEntryLocalService.updateTemplateEntry(templateEntry);
    }

    public TemplateEntry updateStagedModel(PortletDataContext portletDataContext, TemplateEntry templateEntry) throws PortalException {
        return this._templateEntryLocalService.updateTemplateEntry(templateEntry.getTemplateEntryId());
    }
}

