/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.template.model.TemplateEntry;
import com.liferay.template.service.base.TemplateEntryLocalServiceBaseImpl;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.template.model.TemplateEntry"}, service={AopService.class})
public class TemplateEntryLocalServiceImpl
extends TemplateEntryLocalServiceBaseImpl {
    @Reference
    private UserLocalService _userLocalService;

    public TemplateEntry addTemplateEntry(long userId, long groupId, long ddmTemplateId, String infoItemClassName, String infoItemFormVariationKey, ServiceContext serviceContext) throws PortalException {
        TemplateEntry templateEntry = this.templateEntryPersistence.create(this.counterLocalService.increment());
        templateEntry.setUuid(serviceContext.getUuid());
        templateEntry.setGroupId(groupId);
        User user = this._userLocalService.getUser(userId);
        templateEntry.setCompanyId(user.getCompanyId());
        templateEntry.setUserId(user.getUserId());
        templateEntry.setUserName(user.getFullName());
        templateEntry.setDDMTemplateId(ddmTemplateId);
        templateEntry.setInfoItemClassName(infoItemClassName);
        templateEntry.setInfoItemFormVariationKey(infoItemFormVariationKey);
        return (TemplateEntry)this.templateEntryPersistence.update((BaseModel)templateEntry);
    }

    @Override
    public TemplateEntry deleteTemplateEntry(long templateEntryId) throws PortalException {
        return this.templateEntryPersistence.remove(templateEntryId);
    }

    public TemplateEntry fetchTemplateEntryByDDMTemplateId(long ddmTemplateId) {
        return this.templateEntryPersistence.fetchByDDMTemplateId(ddmTemplateId);
    }

    public List<TemplateEntry> getTemplateEntries(long groupId, int start, int end, OrderByComparator<TemplateEntry> orderByComparator) {
        return this.templateEntryPersistence.findByGroupId(groupId, start, end, orderByComparator);
    }

    public List<TemplateEntry> getTemplateEntries(long groupId, String infoItemClassName, String infoItemFormVariationKey, int start, int end, OrderByComparator<TemplateEntry> orderByComparator) {
        return this.templateEntryPersistence.findByG_IICN_IIFVK(groupId, infoItemClassName, infoItemFormVariationKey, start, end, orderByComparator);
    }

    public List<TemplateEntry> getTemplateEntries(long[] groupIds) {
        return this.templateEntryPersistence.findByGroupId(groupIds);
    }

    public int getTemplateEntriesCount(long groupId) {
        return this.templateEntryPersistence.countByGroupId(groupId);
    }

    public TemplateEntry updateTemplateEntry(long templateEntryId) throws PortalException {
        TemplateEntry templateEntry = this.templateEntryPersistence.findByPrimaryKey(templateEntryId);
        return (TemplateEntry)this.templateEntryPersistence.update((BaseModel)templateEntry);
    }
}

