/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.internal.transformer;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.provider.InfoItemFormProvider;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.template.TemplateHandler;
import com.liferay.portal.kernel.template.TemplateHandlerRegistryUtil;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.templateparser.Transformer;
import com.liferay.template.model.TemplateEntry;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class TemplateDisplayTemplateTransformer {
    private final InfoItemFieldValues _infoItemFieldValues;
    private final TemplateEntry _templateEntry;

    public TemplateDisplayTemplateTransformer(TemplateEntry templateEntry, InfoItemFieldValues infoItemFieldValues) {
        this._templateEntry = templateEntry;
        this._infoItemFieldValues = infoItemFieldValues;
    }

    public String transform(Locale locale) throws Exception {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return "";
        }
        ThemeDisplay themeDisplay = serviceContext.getThemeDisplay();
        if (themeDisplay == null) {
            return "";
        }
        Transformer transformer = TransformerHolder.getTransformer();
        HashMap contextObjects = HashMapBuilder.put((Object)"currentURL", (Object)themeDisplay.getURLCurrent()).put((Object)"locale", (Object)themeDisplay.getLocale()).put((Object)"themeDisplay", (Object)themeDisplay).build();
        for (InfoFieldValue infoFieldValue : this._infoItemFieldValues.getInfoFieldValues()) {
            InfoField infoField = infoFieldValue.getInfoField();
            if (StringUtil.startsWith((String)infoField.getName(), (String)"ddmTemplate_")) continue;
            TemplateNode templateNode = new TemplateNode(themeDisplay, infoField.getName(), String.valueOf(infoFieldValue.getValue(locale)), "", new HashMap());
            contextObjects.put(infoField.getName(), templateNode);
        }
        TemplateHandler templateHandler = TemplateHandlerRegistryUtil.getTemplateHandler((String)InfoItemFormProvider.class.getName());
        contextObjects.putAll(templateHandler.getCustomContextObjects());
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.fetchDDMTemplate((long)this._templateEntry.getDDMTemplateId());
        return transformer.transform(themeDisplay, (Map)contextObjects, ddmTemplate.getScript(), "ftl", new UnsyncStringWriter(), themeDisplay.getRequest(), themeDisplay.getResponse());
    }

    private static class TransformerHolder {
        private static final Transformer _transformer = new Transformer("", true){

            protected String getErrorTemplateId(String errorTemplatePropertyKey, String langType) {
                return "com/liferay/template/service/internal/transformer/dependencies/error.ftl";
            }
        };

        private TransformerHolder() {
        }

        public static Transformer getTransformer() {
            return _transformer;
        }
    }
}

