/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.internal.model.listener;

import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.renderer.InfoItemRenderer;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.GroupModel;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.template.internal.info.item.renderer.TemplateEntryInfoItemRenderer;
import com.liferay.template.model.TemplateEntry;
import com.liferay.template.service.TemplateEntryLocalService;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class, PortalInstanceLifecycleListener.class})
public class TemplateEntryModelListener
extends BaseModelListener<TemplateEntry>
implements PortalInstanceLifecycleListener {
    private BundleContext _bundleContext;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    private final Map<Long, Map<Long, ServiceRegistration<?>>> _serviceRegistrations = Collections.synchronizedMap(new LinkedHashMap());
    @Reference
    private TemplateEntryLocalService _templateEntryLocalService;

    public void onAfterCreate(TemplateEntry templateEntry) throws ModelListenerException {
        Map serviceRegistrations = this._serviceRegistrations.computeIfAbsent(templateEntry.getCompanyId(), key -> new HashMap());
        serviceRegistrations.put(templateEntry.getTemplateEntryId(), this._bundleContext.registerService(InfoItemRenderer.class, new TemplateEntryInfoItemRenderer(this._infoItemServiceTracker, templateEntry), (Dictionary)HashMapDictionaryBuilder.put((Object)"item.class.name", (Object)templateEntry.getInfoItemClassName()).build()));
    }

    public void onBeforeRemove(TemplateEntry templateEntry) throws ModelListenerException {
        ServiceRegistration<?> serviceRegistration;
        Map<Long, ServiceRegistration<?>> serviceRegistrations = this._serviceRegistrations.get(templateEntry.getCompanyId());
        if (MapUtil.isNotEmpty(serviceRegistrations) && (serviceRegistration = serviceRegistrations.remove(templateEntry.getTemplateEntryId())) != null) {
            serviceRegistration.unregister();
        }
    }

    public void portalInstanceRegistered(Company company) {
        HashMap<Long, ServiceRegistration> serviceRegistrations = new HashMap<Long, ServiceRegistration>();
        List companyGroups = this._groupLocalService.getCompanyGroups(company.getCompanyId(), -1, -1);
        List templateEntries = this._templateEntryLocalService.getTemplateEntries(ListUtil.toLongArray((List)companyGroups, GroupModel::getGroupId));
        for (TemplateEntry templateEntry : templateEntries) {
            serviceRegistrations.put(templateEntry.getTemplateEntryId(), this._bundleContext.registerService(InfoItemRenderer.class, new TemplateEntryInfoItemRenderer(this._infoItemServiceTracker, templateEntry), (Dictionary)HashMapDictionaryBuilder.put((Object)"item.class.name", (Object)templateEntry.getInfoItemClassName()).build()));
        }
        if (MapUtil.isNotEmpty(serviceRegistrations)) {
            this._serviceRegistrations.put(company.getCompanyId(), serviceRegistrations);
        }
    }

    public void portalInstanceUnregistered(Company company) {
        this._unregisterCompanyTemplateEntries(company.getCompanyId());
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
    }

    @Deactivate
    protected void deactivate() {
        this._companyLocalService.forEachCompanyId(this::_unregisterCompanyTemplateEntries);
    }

    private void _unregisterCompanyTemplateEntries(long companyId) {
        Map<Long, ServiceRegistration<?>> serviceRegistrations = this._serviceRegistrations.remove(companyId);
        if (serviceRegistrations == null) {
            return;
        }
        for (Map.Entry<Long, ServiceRegistration<?>> entry : serviceRegistrations.entrySet()) {
            ServiceRegistration<?> serviceRegistration = entry.getValue();
            if (serviceRegistration == null) continue;
            serviceRegistration.unregister();
        }
    }
}

