/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.internal.info.item.renderer;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.item.renderer.InfoItemRenderer;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.template.internal.transformer.TemplateDisplayTemplateTransformer;
import com.liferay.template.model.TemplateEntry;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TemplateEntryInfoItemRenderer<T>
implements InfoItemRenderer<T> {
    private final InfoItemServiceTracker _infoItemServiceTracker;
    private final TemplateEntry _templateEntry;

    public TemplateEntryInfoItemRenderer(InfoItemServiceTracker infoItemServiceTracker, TemplateEntry templateEntry) {
        this._infoItemServiceTracker = infoItemServiceTracker;
        this._templateEntry = templateEntry;
    }

    public String getKey() {
        return "ddmTemplate_" + this._templateEntry.getTemplateEntryId();
    }

    public String getLabel(Locale locale) {
        DDMTemplate ddmTemplate = DDMTemplateLocalServiceUtil.fetchDDMTemplate((long)this._templateEntry.getDDMTemplateId());
        return ddmTemplate.getName(locale);
    }

    public boolean isAvailable() {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        return serviceContext != null && serviceContext.getScopeGroupId() == this._templateEntry.getGroupId();
    }

    public void render(T t, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            PrintWriter writer = httpServletResponse.getWriter();
            InfoItemFieldValues infoItemFieldValues = InfoItemFieldValues.builder().build();
            InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, this._templateEntry.getInfoItemClassName());
            if (infoItemFieldValuesProvider != null) {
                infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues(t);
            }
            TemplateDisplayTemplateTransformer templateDisplayTemplateTransformer = new TemplateDisplayTemplateTransformer(this._templateEntry, infoItemFieldValues);
            String content = templateDisplayTemplateTransformer.transform(LocaleThreadLocal.getThemeDisplayLocale());
            ((Writer)writer).write(content);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

