/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.internal.info.item.provider;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldSet;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.field.type.InfoFieldType;
import com.liferay.info.field.type.TextInfoFieldType;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemServiceTracker;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.info.localized.InfoLocalizedValue;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.template.info.item.provider.TemplateInfoItemFieldSetProvider;
import com.liferay.template.internal.transformer.TemplateDisplayTemplateTransformer;
import com.liferay.template.model.TemplateEntry;
import com.liferay.template.service.TemplateEntryLocalService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={TemplateInfoItemFieldSetProvider.class})
public class TemplateInfoItemFieldSetProviderImpl
implements TemplateInfoItemFieldSetProvider {
    private static final Log _log = LogFactoryUtil.getLog(TemplateInfoItemFieldSetProviderImpl.class);
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private InfoItemServiceTracker _infoItemServiceTracker;
    @Reference
    private StagingGroupHelper _stagingGroupHelper;
    @Reference
    private TemplateEntryLocalService _templateEntryLocalService;

    public InfoFieldSet getInfoFieldSet(String infoItemClassName, String infoItemFormVariationKey) {
        return InfoFieldSet.builder().infoFieldSetEntry(consumer -> {
            for (TemplateEntry templateEntry : this._getTemplateEntries(infoItemClassName, infoItemFormVariationKey)) {
                consumer.accept(this._getInfoField(templateEntry));
            }
        }).labelInfoLocalizedValue(InfoLocalizedValue.localize(this.getClass(), (String)"templates")).name("templates").build();
    }

    public List<InfoFieldValue<Object>> getInfoFieldValues(String infoItemClassName, String infoItemFormVariationKey, Object itemObject) {
        ArrayList<InfoFieldValue<Object>> infoFieldValues = new ArrayList<InfoFieldValue<Object>>();
        for (TemplateEntry templateEntry : this._getTemplateEntries(infoItemClassName, infoItemFormVariationKey)) {
            infoFieldValues.add(this._getInfoFieldValue(templateEntry, itemObject));
        }
        return infoFieldValues;
    }

    private InfoField<?> _getInfoField(TemplateEntry templateEntry) {
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchDDMTemplate(templateEntry.getDDMTemplateId());
        return InfoField.builder().infoFieldType((InfoFieldType)TextInfoFieldType.INSTANCE).name("ddmTemplate_" + templateEntry.getTemplateEntryId()).labelInfoLocalizedValue(InfoLocalizedValue.builder().value(LocaleUtil.getDefault(), (Object)ddmTemplate.getName(LocaleUtil.getDefault())).defaultLocale(LocaleUtil.getDefault()).build()).build();
    }

    private InfoFieldValue<Object> _getInfoFieldValue(TemplateEntry templateEntry, Object itemObject) {
        if (templateEntry == null) {
            return null;
        }
        return new InfoFieldValue(this._getInfoField(templateEntry), () -> {
            InfoItemFieldValues infoItemFieldValues = InfoItemFieldValues.builder().build();
            InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceTracker.getFirstInfoItemService(InfoItemFieldValuesProvider.class, templateEntry.getInfoItemClassName());
            if (infoItemFieldValuesProvider != null) {
                infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues(itemObject);
            }
            TemplateDisplayTemplateTransformer templateDisplayTemplateTransformer = new TemplateDisplayTemplateTransformer(templateEntry, infoItemFieldValues);
            try {
                return templateDisplayTemplateTransformer.transform(LocaleUtil.getDefault());
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to transform template", (Throwable)exception);
                return "";
            }
        });
    }

    private List<TemplateEntry> _getTemplateEntries(String infoItemClassName, String infoItemFormVariationKey) throws RuntimeException {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            return Collections.emptyList();
        }
        try {
            Group liveGroup;
            long groupId = serviceContext.getScopeGroupId();
            if (!this._stagingGroupHelper.isStagedPortlet(groupId, "com_liferay_template_web_internal_portlet_TemplatePortlet") && (liveGroup = this._stagingGroupHelper.fetchLiveGroup(groupId)) != null) {
                groupId = liveGroup.getGroupId();
            }
            return this._templateEntryLocalService.getTemplateEntries(groupId, infoItemClassName, infoItemFormVariationKey, -1, -1, null);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return Collections.emptyList();
        }
    }
}

