/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.template.internal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.template.model.TemplateEntry;
import com.liferay.template.service.TemplateEntryLocalService;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class TemplateEntryStagedModelDataHandler
extends BaseStagedModelDataHandler<TemplateEntry> {
    public static final String[] CLASS_NAMES = new String[]{TemplateEntry.class.getName()};
    @Reference
    private DDMTemplateLocalService _ddmTemplateLocalService;
    @Reference
    private Portal _portal;
    @Reference(target="(model.class.name=com.liferay.template.model.TemplateEntry)")
    private StagedModelRepository<TemplateEntry> _stagedModelRepository;
    @Reference
    private TemplateEntryLocalService _templateEntryLocalService;

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._stagedModelRepository.deleteStagedModel(uuid, groupId, className, extraData);
    }

    public void deleteStagedModel(TemplateEntry templateEntry) throws PortalException {
        this._stagedModelRepository.deleteStagedModel((StagedModel)templateEntry);
    }

    public TemplateEntry fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return (TemplateEntry)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(uuid, groupId);
    }

    public List<TemplateEntry> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._stagedModelRepository.fetchStagedModelsByUuidAndCompanyId(uuid, companyId);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(TemplateEntry templateEntry) {
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchDDMTemplate(templateEntry.getDDMTemplateId());
        return ddmTemplate.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, TemplateEntry templateEntry) throws Exception {
        Element entryElement = portletDataContext.getExportDataElement((ClassedModel)templateEntry);
        portletDataContext.addClassedModel(entryElement, ExportImportPathUtil.getModelPath((StagedModel)templateEntry), (ClassedModel)templateEntry);
        DDMTemplate ddmTemplate = this._ddmTemplateLocalService.fetchDDMTemplate(templateEntry.getDDMTemplateId());
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)templateEntry, (StagedModel)ddmTemplate, (String)"parent");
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long templateEntryId) throws Exception {
        TemplateEntry existingTemplateEntry = (TemplateEntry)this.fetchMissingReference(uuid, groupId);
        if (existingTemplateEntry == null) {
            return;
        }
        Map templateEntryIds = portletDataContext.getNewPrimaryKeysMap(TemplateEntry.class);
        templateEntryIds.put(templateEntryId, existingTemplateEntry.getTemplateEntryId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, TemplateEntry templateEntry) throws Exception {
        TemplateEntry importedTemplateEntry = (TemplateEntry)templateEntry.clone();
        importedTemplateEntry.setGroupId(portletDataContext.getScopeGroupId());
        TemplateEntry existingTemplateEntry = (TemplateEntry)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(templateEntry.getUuid(), portletDataContext.getScopeGroupId());
        if (existingTemplateEntry == null || !portletDataContext.isDataStrategyMirror()) {
            importedTemplateEntry = (TemplateEntry)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedTemplateEntry);
        } else {
            importedTemplateEntry.setMvccVersion(existingTemplateEntry.getMvccVersion());
            importedTemplateEntry.setTemplateEntryId(existingTemplateEntry.getTemplateEntryId());
            importedTemplateEntry = (TemplateEntry)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedTemplateEntry);
        }
        portletDataContext.importClassedModel((ClassedModel)templateEntry, (ClassedModel)importedTemplateEntry);
    }
}

