/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.service.io.delta;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;

public class ByteChannelReader {
    private ByteBuffer _byteBuffer;
    private boolean _eof;
    private final ReadableByteChannel _readableByteChannel;

    public ByteChannelReader(ReadableByteChannel readableByteChannel) throws IOException {
        this(readableByteChannel, 1024);
    }

    public ByteChannelReader(ReadableByteChannel readableByteChannel, int bufferLength) throws IOException {
        this._readableByteChannel = readableByteChannel;
        this._byteBuffer = ByteBuffer.allocate(bufferLength);
        this._eof = this._readableByteChannel.read(this._byteBuffer) == -1;
        this._byteBuffer.flip();
    }

    public void ensureData(int length) throws IOException {
        if (this._byteBuffer.remaining() < length) {
            this.read(length);
            if (this._eof || this._byteBuffer.remaining() < length) {
                throw new IOException("Unexpected EOF");
            }
        }
    }

    public byte get() {
        return this._byteBuffer.get();
    }

    public byte get(int offset) {
        return this._byteBuffer.get(this._byteBuffer.position() + offset);
    }

    public ByteBuffer getBuffer() {
        return this._byteBuffer;
    }

    public boolean hasRemaining() {
        return this._byteBuffer.hasRemaining();
    }

    public boolean isSeekable() {
        return this._readableByteChannel instanceof SeekableByteChannel;
    }

    public void maybeRead(int length) throws IOException {
        if (!this._eof && this._byteBuffer.remaining() < length) {
            this.read(length);
        }
    }

    public void position(int position) throws IOException {
        if (!this.isSeekable()) {
            throw new IOException("Byte channel is not seekable");
        }
        SeekableByteChannel seekableByteChannel = (SeekableByteChannel)this._readableByteChannel;
        seekableByteChannel.position(position);
        this._byteBuffer.clear();
        this._byteBuffer.flip();
    }

    public void read(int length) throws IOException {
        if (this._eof) {
            return;
        }
        this._byteBuffer.compact();
        while (this._byteBuffer.position() < length) {
            int bytesRead = this._readableByteChannel.read(this._byteBuffer);
            if (bytesRead != -1) continue;
            this._eof = true;
            break;
        }
        this._byteBuffer.flip();
    }

    public int remaining() {
        return this._byteBuffer.remaining();
    }

    public void resizeBuffer(int minBufferLength) {
        if (this._byteBuffer.capacity() >= minBufferLength) {
            return;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(minBufferLength);
        newBuffer.put(this._byteBuffer);
        newBuffer.flip();
        this._byteBuffer = newBuffer;
    }

    public int skip(int length) {
        length = Math.min(this._byteBuffer.remaining(), length);
        this._byteBuffer.position(this._byteBuffer.position() + length);
        return length;
    }
}

