/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.upgrade.v1_0_2;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.document.library.sync.service.DLSyncEventLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.sync.internal.configuration.SyncServiceConfigurationValues;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;

public class UpgradeSyncDLObject
extends UpgradeProcess {
    private final CounterLocalService _counterLocalService;
    private final DLSyncEventLocalService _dlSyncEventLocalService;
    private final GroupLocalService _groupLocalService;

    public UpgradeSyncDLObject(CounterLocalService counterLocalService, DLSyncEventLocalService dlSyncEventLocalService, GroupLocalService groupLocalService) {
        this._counterLocalService = counterLocalService;
        this._dlSyncEventLocalService = dlSyncEventLocalService;
        this._groupLocalService = groupLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            ActionableDynamicQuery actionableDynamicQuery = this._groupLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> {
                Property classNameId = PropertyFactoryUtil.forName((String)"classNameId");
                Property siteProperty = PropertyFactoryUtil.forName((String)"site");
                dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)classNameId.eq((Object)PortalUtil.getClassNameId(User.class)), (Criterion)siteProperty.eq((Object)true)));
            });
            actionableDynamicQuery.setPerformActionMethod(group -> {
                if (group.isStaged()) {
                    return;
                }
                try {
                    this._verifyDLFileEntriesAndFolders(group.getGroupId());
                    this._verifyLocks(group.getGroupId());
                    this._verifyMacPackages(group.getGroupId());
                }
                catch (Exception exception) {
                    throw new PortalException((Throwable)exception);
                }
            });
            actionableDynamicQuery.performActions();
            this._dlSyncEventLocalService.deleteDLSyncEvents();
        }
    }

    private void _verifyDLFileEntriesAndFolders(long groupId) throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select DLFolder.companyId, DLFolder.userId, ", "DLFolder.userName, DLFolder.createDate, ", "DLFolder.modifiedDate, DLFolder.repositoryId, ", "DLFolder.parentFolderId as parentFolderId, ", "DLFolder.treePath, DLFolder.name, '' as extension, '' as ", "mimeType, DLFolder.description, '' as changeLog, '' as ", "version, 0 as versionId, 0 as size_, '", "folder", "' as type, DLFolder.folderId as typePK, DLFolder.uuid_ ", "as typeUuid, DLFolder.status from DLFolder where ", "DLFolder.repositoryId = ", groupId, " union all select DLFileVersion.companyId, ", "DLFileVersion.userId, DLFileVersion.userName, ", "DLFileVersion.createDate, DLFileVersion.modifiedDate, ", "DLFileVersion.repositoryId, DLFileVersion.folderId as ", "parentFolderId, DLFileVersion.treePath, ", "DLFileVersion.title as name, DLFileVersion.extension, ", "DLFileVersion.mimeType, DLFileVersion.description, ", "DLFileVersion.changeLog, DLFileVersion.version, ", "DLFileVersion.fileVersionId as versionId, ", "DLFileVersion.size_ as size_, '", "file", "' as type, DLFileVersion.fileEntryId as typePK, ", "DLFileEntry.uuid_ as typeUuid, DLFileVersion.status from ", "DLFileEntry, DLFileVersion where ", "DLFileEntry.repositoryId = ", groupId, " and DLFileEntry.fileEntryId = DLFileVersion.fileEntryId ", "and DLFileEntry.version = DLFileVersion.version union ", "all select DLFileVersion.companyId, ", "DLFileVersion.userId, DLFileVersion.userName, ", "DLFileVersion.createDate, DLFileVersion.modifiedDate, ", "DLFileVersion.repositoryId, DLFileVersion.folderId as ", "parentFolderId, DLFileVersion.treePath, ", "DLFileVersion.title as name, DLFileVersion.extension, ", "DLFileVersion.mimeType, DLFileVersion.description, ", "DLFileVersion.changeLog, DLFileVersion.version, ", "DLFileVersion.fileVersionId as versionId, ", "DLFileVersion.size_ as size_, '", "privateWorkingCopy", "' as type, DLFileVersion.fileEntryId as typePK, ", "DLFileEntry.uuid_ as typeUuid, DLFileVersion.status from ", "DLFileEntry, DLFileVersion where ", "DLFileEntry.repositoryId = ", groupId, " and DLFileEntry.fileEntryId = DLFileVersion.fileEntryId ", "and DLFileVersion.version = '", "PWC", "'"}));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"insert into SyncDLObject (syncDLObjectId, companyId, ", "userId, userName, createTime, modifiedTime, ", "repositoryId, parentFolderId, treePath, name, ", "extension, mimeType, description, changeLog, ", "version, versionId, size_, event, type_, typePK, ", "typeUuid) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ", "?, ?, ?, ?, ?, ?, ?, ?, ?, ?)"}));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                Timestamp createDate = resultSet.getTimestamp("createDate");
                Timestamp modifiedDate = resultSet.getTimestamp("modifiedDate");
                int status = resultSet.getInt("status");
                String event = "";
                event = status == 8 ? "trash" : "add";
                preparedStatement2.setLong(1, this._counterLocalService.increment());
                preparedStatement2.setLong(2, resultSet.getLong("companyId"));
                preparedStatement2.setLong(3, resultSet.getLong("userId"));
                preparedStatement2.setString(4, resultSet.getString("userName"));
                preparedStatement2.setLong(5, createDate.getTime());
                preparedStatement2.setLong(6, modifiedDate.getTime());
                preparedStatement2.setLong(7, groupId);
                preparedStatement2.setLong(8, resultSet.getLong("parentFolderId"));
                preparedStatement2.setString(9, resultSet.getString("treePath"));
                preparedStatement2.setString(10, resultSet.getString("name"));
                preparedStatement2.setString(11, resultSet.getString("extension"));
                preparedStatement2.setString(12, resultSet.getString("mimeType"));
                preparedStatement2.setString(13, resultSet.getString("description"));
                preparedStatement2.setString(14, resultSet.getString("changeLog"));
                preparedStatement2.setString(15, resultSet.getString("version"));
                preparedStatement2.setLong(16, resultSet.getLong("versionId"));
                preparedStatement2.setLong(17, resultSet.getLong("size_"));
                preparedStatement2.setString(18, event);
                preparedStatement2.setString(19, resultSet.getString("type"));
                preparedStatement2.setLong(20, resultSet.getLong("typePK"));
                preparedStatement2.setString(21, resultSet.getString("typeUuid"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _verifyLocks(long groupId) throws Exception {
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select Lock_.expirationDate, Lock_.userId, ", "Lock_.userName, DLFileVersion.fileEntryId from ", "DLFileVersion, Lock_ where DLFileVersion.version = '", "PWC", "' and CAST_TEXT(DLFileVersion.fileEntryId) = ", "Lock_.key_"})));
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((Object[])new Object[]{"update SyncDLObject set lockExpirationDate = ?, ", "lockUserId = ?, lockUserName = ? where typePK = ? ", "and repositoryId = ", groupId}));
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                preparedStatement2.setTimestamp(1, resultSet.getTimestamp("expirationDate"));
                preparedStatement2.setLong(2, resultSet.getLong("userId"));
                preparedStatement2.setString(3, resultSet.getString("userName"));
                preparedStatement2.setLong(4, resultSet.getLong("fileEntryId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }

    private void _verifyMacPackages(long groupId) throws Exception {
        String[] fileNames = SyncServiceConfigurationValues.SYNC_MAC_PACKAGE_METADATA_FILE_NAMES;
        StringBundler sb = new StringBundler(fileNames.length * 4 + 5);
        sb.append("select DLFolder.folderId, DLFolder.name from DLFolder, ");
        sb.append("DLFileEntry where DLFolder.repositoryId = ");
        sb.append(groupId);
        sb.append(" and DLFileEntry.folderId = DLFolder.folderId and ");
        sb.append("DLFileEntry.title in (");
        for (int i = 0; i < fileNames.length; ++i) {
            sb.append("'");
            sb.append(fileNames[i]);
            sb.append("'");
            if (i == fileNames.length - 1) continue;
            sb.append(',');
        }
        sb.append(")");
        try (PreparedStatement preparedStatement1 = this.connection.prepareStatement(sb.toString());
             PreparedStatement preparedStatement2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update SyncDLObject set extraSettings = ? where typePK = ?");
             ResultSet resultSet = preparedStatement1.executeQuery();){
            while (resultSet.next()) {
                String name = resultSet.getString("name");
                if (!ArrayUtil.contains((Object[])SyncServiceConfigurationValues.SYNC_MAC_PACKAGE_FOLDER_EXTENSIONS, (Object)FileUtil.getExtension((String)name))) continue;
                JSONObject extraSettingsJSONObject = JSONUtil.put((String)"macPackage", (Object)true);
                preparedStatement2.setString(1, extraSettingsJSONObject.toString());
                preparedStatement2.setLong(2, resultSet.getLong("folderId"));
                preparedStatement2.addBatch();
            }
            preparedStatement2.executeBatch();
        }
    }
}

