/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.configurator;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.sync.internal.configuration.SyncServiceConfigurationValues;
import com.liferay.sync.util.SyncHelper;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class SyncConfigurator
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(SyncConfigurator.class);
    private volatile BundleContext _bundleContext;
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _dlSyncEventProcessorServiceRegistration;
    @Reference
    private SyncHelper _syncHelper;
    private ServiceRegistration<Destination> _syncMaintenanceProcessorServiceRegistration;

    public void portalInstanceRegistered(Company company) throws Exception {
        boolean lanEnabled = PrefsPropsUtil.getBoolean((long)company.getCompanyId(), (String)"sync.lan.enabled", (boolean)SyncServiceConfigurationValues.SYNC_LAN_ENABLED);
        if (lanEnabled) {
            try {
                this._syncHelper.enableLanSync(company.getCompanyId());
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._dlSyncEventProcessorServiceRegistration = this._registerMessageListener("liferay/document_library_sync_event_processor");
        this._syncMaintenanceProcessorServiceRegistration = this._registerMessageListener("liferay/sync_maintenance_processor");
    }

    @Deactivate
    protected void deactivate() {
        Destination destination;
        if (this._dlSyncEventProcessorServiceRegistration != null) {
            destination = (Destination)this._bundleContext.getService(this._dlSyncEventProcessorServiceRegistration.getReference());
            this._dlSyncEventProcessorServiceRegistration.unregister();
            destination.destroy();
        }
        if (this._syncMaintenanceProcessorServiceRegistration != null) {
            destination = (Destination)this._bundleContext.getService(this._syncMaintenanceProcessorServiceRegistration.getReference());
            this._syncMaintenanceProcessorServiceRegistration.unregister();
            destination.destroy();
        }
        this._bundleContext = null;
    }

    private ServiceRegistration<Destination> _registerMessageListener(String destinationName) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("serial", destinationName);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary destinationProperties = HashMapDictionaryBuilder.put((Object)"destination.name", (Object)destination.getName()).build();
        return this._bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)destinationProperties);
    }
}

