/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.sync.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.model.SyncDLObjectModel;
import com.liferay.sync.model.SyncDLObjectSoap;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the SyncDLObject service. Represents a row in the &quot;SyncDLObject&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>SyncDLObjectModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link SyncDLObjectImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see SyncDLObjectImpl
 * @generated
 */
@JSON(strict = true)
public class SyncDLObjectModelImpl
	extends BaseModelImpl<SyncDLObject> implements SyncDLObjectModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a sync dl object model instance should use the <code>SyncDLObject</code> interface instead.
	 */
	public static final String TABLE_NAME = "SyncDLObject";

	public static final Object[][] TABLE_COLUMNS = {
		{"syncDLObjectId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createTime", Types.BIGINT}, {"modifiedTime", Types.BIGINT},
		{"repositoryId", Types.BIGINT}, {"parentFolderId", Types.BIGINT},
		{"treePath", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"extension", Types.VARCHAR}, {"mimeType", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"changeLog", Types.VARCHAR},
		{"extraSettings", Types.CLOB}, {"version", Types.VARCHAR},
		{"versionId", Types.BIGINT}, {"size_", Types.BIGINT},
		{"checksum", Types.VARCHAR}, {"event", Types.VARCHAR},
		{"lanTokenKey", Types.VARCHAR},
		{"lastPermissionChangeDate", Types.TIMESTAMP},
		{"lockExpirationDate", Types.TIMESTAMP}, {"lockUserId", Types.BIGINT},
		{"lockUserName", Types.VARCHAR}, {"type_", Types.VARCHAR},
		{"typePK", Types.BIGINT}, {"typeUuid", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("syncDLObjectId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createTime", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("modifiedTime", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("repositoryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("parentFolderId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("treePath", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("extension", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("mimeType", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("changeLog", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("extraSettings", Types.CLOB);
		TABLE_COLUMNS_MAP.put("version", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("versionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("size_", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("checksum", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("event", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lanTokenKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("lastPermissionChangeDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lockExpirationDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("lockUserId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("lockUserName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("typePK", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("typeUuid", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table SyncDLObject (syncDLObjectId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createTime LONG,modifiedTime LONG,repositoryId LONG,parentFolderId LONG,treePath STRING null,name VARCHAR(255) null,extension VARCHAR(75) null,mimeType VARCHAR(75) null,description STRING null,changeLog VARCHAR(75) null,extraSettings TEXT null,version VARCHAR(75) null,versionId LONG,size_ LONG,checksum VARCHAR(75) null,event VARCHAR(75) null,lanTokenKey VARCHAR(75) null,lastPermissionChangeDate DATE null,lockExpirationDate DATE null,lockUserId LONG,lockUserName VARCHAR(75) null,type_ VARCHAR(75) null,typePK LONG,typeUuid VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table SyncDLObject";

	public static final String ORDER_BY_JPQL =
		" ORDER BY syncDLObject.modifiedTime ASC, syncDLObject.repositoryId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY SyncDLObject.modifiedTime ASC, SyncDLObject.repositoryId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long EVENT_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MODIFIEDTIME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long PARENTFOLDERID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long REPOSITORYID_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TREEPATH_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPE_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long TYPEPK_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long VERSION_COLUMN_BITMASK = 128L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static SyncDLObject toModel(SyncDLObjectSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		SyncDLObject model = new SyncDLObjectImpl();

		model.setSyncDLObjectId(soapModel.getSyncDLObjectId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateTime(soapModel.getCreateTime());
		model.setModifiedTime(soapModel.getModifiedTime());
		model.setRepositoryId(soapModel.getRepositoryId());
		model.setParentFolderId(soapModel.getParentFolderId());
		model.setTreePath(soapModel.getTreePath());
		model.setName(soapModel.getName());
		model.setExtension(soapModel.getExtension());
		model.setMimeType(soapModel.getMimeType());
		model.setDescription(soapModel.getDescription());
		model.setChangeLog(soapModel.getChangeLog());
		model.setExtraSettings(soapModel.getExtraSettings());
		model.setVersion(soapModel.getVersion());
		model.setVersionId(soapModel.getVersionId());
		model.setSize(soapModel.getSize());
		model.setChecksum(soapModel.getChecksum());
		model.setEvent(soapModel.getEvent());
		model.setLanTokenKey(soapModel.getLanTokenKey());
		model.setLastPermissionChangeDate(
			soapModel.getLastPermissionChangeDate());
		model.setLockExpirationDate(soapModel.getLockExpirationDate());
		model.setLockUserId(soapModel.getLockUserId());
		model.setLockUserName(soapModel.getLockUserName());
		model.setType(soapModel.getType());
		model.setTypePK(soapModel.getTypePK());
		model.setTypeUuid(soapModel.getTypeUuid());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<SyncDLObject> toModels(SyncDLObjectSoap[] soapModels) {
		if (soapModels == null) {
			return null;
		}

		List<SyncDLObject> models = new ArrayList<SyncDLObject>(
			soapModels.length);

		for (SyncDLObjectSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public SyncDLObjectModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _syncDLObjectId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setSyncDLObjectId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _syncDLObjectId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return SyncDLObject.class;
	}

	@Override
	public String getModelClassName() {
		return SyncDLObject.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<SyncDLObject, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<SyncDLObject, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SyncDLObject, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((SyncDLObject)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<SyncDLObject, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<SyncDLObject, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(SyncDLObject)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<SyncDLObject, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<SyncDLObject, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<SyncDLObject, Object>>
		_attributeGetterFunctions;

	static {
		Map<String, Function<SyncDLObject, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<SyncDLObject, Object>>();

		attributeGetterFunctions.put(
			"syncDLObjectId", SyncDLObject::getSyncDLObjectId);
		attributeGetterFunctions.put("companyId", SyncDLObject::getCompanyId);
		attributeGetterFunctions.put("userId", SyncDLObject::getUserId);
		attributeGetterFunctions.put("userName", SyncDLObject::getUserName);
		attributeGetterFunctions.put("createTime", SyncDLObject::getCreateTime);
		attributeGetterFunctions.put(
			"modifiedTime", SyncDLObject::getModifiedTime);
		attributeGetterFunctions.put(
			"repositoryId", SyncDLObject::getRepositoryId);
		attributeGetterFunctions.put(
			"parentFolderId", SyncDLObject::getParentFolderId);
		attributeGetterFunctions.put("treePath", SyncDLObject::getTreePath);
		attributeGetterFunctions.put("name", SyncDLObject::getName);
		attributeGetterFunctions.put("extension", SyncDLObject::getExtension);
		attributeGetterFunctions.put("mimeType", SyncDLObject::getMimeType);
		attributeGetterFunctions.put(
			"description", SyncDLObject::getDescription);
		attributeGetterFunctions.put("changeLog", SyncDLObject::getChangeLog);
		attributeGetterFunctions.put(
			"extraSettings", SyncDLObject::getExtraSettings);
		attributeGetterFunctions.put("version", SyncDLObject::getVersion);
		attributeGetterFunctions.put("versionId", SyncDLObject::getVersionId);
		attributeGetterFunctions.put("size", SyncDLObject::getSize);
		attributeGetterFunctions.put("checksum", SyncDLObject::getChecksum);
		attributeGetterFunctions.put("event", SyncDLObject::getEvent);
		attributeGetterFunctions.put(
			"lanTokenKey", SyncDLObject::getLanTokenKey);
		attributeGetterFunctions.put(
			"lastPermissionChangeDate",
			SyncDLObject::getLastPermissionChangeDate);
		attributeGetterFunctions.put(
			"lockExpirationDate", SyncDLObject::getLockExpirationDate);
		attributeGetterFunctions.put("lockUserId", SyncDLObject::getLockUserId);
		attributeGetterFunctions.put(
			"lockUserName", SyncDLObject::getLockUserName);
		attributeGetterFunctions.put("type", SyncDLObject::getType);
		attributeGetterFunctions.put("typePK", SyncDLObject::getTypePK);
		attributeGetterFunctions.put("typeUuid", SyncDLObject::getTypeUuid);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
	}

	private static final Map<String, BiConsumer<SyncDLObject, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<SyncDLObject, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<SyncDLObject, ?>>();

		attributeSetterBiConsumers.put(
			"syncDLObjectId",
			(BiConsumer<SyncDLObject, Long>)SyncDLObject::setSyncDLObjectId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<SyncDLObject, Long>)SyncDLObject::setCompanyId);
		attributeSetterBiConsumers.put(
			"userId", (BiConsumer<SyncDLObject, Long>)SyncDLObject::setUserId);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setUserName);
		attributeSetterBiConsumers.put(
			"createTime",
			(BiConsumer<SyncDLObject, Long>)SyncDLObject::setCreateTime);
		attributeSetterBiConsumers.put(
			"modifiedTime",
			(BiConsumer<SyncDLObject, Long>)SyncDLObject::setModifiedTime);
		attributeSetterBiConsumers.put(
			"repositoryId",
			(BiConsumer<SyncDLObject, Long>)SyncDLObject::setRepositoryId);
		attributeSetterBiConsumers.put(
			"parentFolderId",
			(BiConsumer<SyncDLObject, Long>)SyncDLObject::setParentFolderId);
		attributeSetterBiConsumers.put(
			"treePath",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setTreePath);
		attributeSetterBiConsumers.put(
			"name", (BiConsumer<SyncDLObject, String>)SyncDLObject::setName);
		attributeSetterBiConsumers.put(
			"extension",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setExtension);
		attributeSetterBiConsumers.put(
			"mimeType",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setMimeType);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setDescription);
		attributeSetterBiConsumers.put(
			"changeLog",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setChangeLog);
		attributeSetterBiConsumers.put(
			"extraSettings",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setExtraSettings);
		attributeSetterBiConsumers.put(
			"version",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setVersion);
		attributeSetterBiConsumers.put(
			"versionId",
			(BiConsumer<SyncDLObject, Long>)SyncDLObject::setVersionId);
		attributeSetterBiConsumers.put(
			"size", (BiConsumer<SyncDLObject, Long>)SyncDLObject::setSize);
		attributeSetterBiConsumers.put(
			"checksum",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setChecksum);
		attributeSetterBiConsumers.put(
			"event", (BiConsumer<SyncDLObject, String>)SyncDLObject::setEvent);
		attributeSetterBiConsumers.put(
			"lanTokenKey",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setLanTokenKey);
		attributeSetterBiConsumers.put(
			"lastPermissionChangeDate",
			(BiConsumer<SyncDLObject, Date>)
				SyncDLObject::setLastPermissionChangeDate);
		attributeSetterBiConsumers.put(
			"lockExpirationDate",
			(BiConsumer<SyncDLObject, Date>)
				SyncDLObject::setLockExpirationDate);
		attributeSetterBiConsumers.put(
			"lockUserId",
			(BiConsumer<SyncDLObject, Long>)SyncDLObject::setLockUserId);
		attributeSetterBiConsumers.put(
			"lockUserName",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setLockUserName);
		attributeSetterBiConsumers.put(
			"type", (BiConsumer<SyncDLObject, String>)SyncDLObject::setType);
		attributeSetterBiConsumers.put(
			"typePK", (BiConsumer<SyncDLObject, Long>)SyncDLObject::setTypePK);
		attributeSetterBiConsumers.put(
			"typeUuid",
			(BiConsumer<SyncDLObject, String>)SyncDLObject::setTypeUuid);

		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getSyncDLObjectId() {
		return _syncDLObjectId;
	}

	@Override
	public void setSyncDLObjectId(long syncDLObjectId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_syncDLObjectId = syncDLObjectId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public long getCreateTime() {
		return _createTime;
	}

	@Override
	public void setCreateTime(long createTime) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createTime = createTime;
	}

	@JSON
	@Override
	public long getModifiedTime() {
		return _modifiedTime;
	}

	@Override
	public void setModifiedTime(long modifiedTime) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedTime = modifiedTime;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalModifiedTime() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("modifiedTime"));
	}

	@JSON
	@Override
	public long getRepositoryId() {
		return _repositoryId;
	}

	@Override
	public void setRepositoryId(long repositoryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_repositoryId = repositoryId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalRepositoryId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("repositoryId"));
	}

	@JSON
	@Override
	public long getParentFolderId() {
		return _parentFolderId;
	}

	@Override
	public void setParentFolderId(long parentFolderId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_parentFolderId = parentFolderId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalParentFolderId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("parentFolderId"));
	}

	@JSON(include = false)
	@Override
	public String getTreePath() {
		if (_treePath == null) {
			return "";
		}
		else {
			return _treePath;
		}
	}

	@Override
	public void setTreePath(String treePath) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_treePath = treePath;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalTreePath() {
		return getColumnOriginalValue("treePath");
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@JSON
	@Override
	public String getExtension() {
		if (_extension == null) {
			return "";
		}
		else {
			return _extension;
		}
	}

	@Override
	public void setExtension(String extension) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_extension = extension;
	}

	@JSON
	@Override
	public String getMimeType() {
		if (_mimeType == null) {
			return "";
		}
		else {
			return _mimeType;
		}
	}

	@Override
	public void setMimeType(String mimeType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mimeType = mimeType;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getChangeLog() {
		if (_changeLog == null) {
			return "";
		}
		else {
			return _changeLog;
		}
	}

	@Override
	public void setChangeLog(String changeLog) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_changeLog = changeLog;
	}

	@JSON
	@Override
	public String getExtraSettings() {
		if (_extraSettings == null) {
			return "";
		}
		else {
			return _extraSettings;
		}
	}

	@Override
	public void setExtraSettings(String extraSettings) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_extraSettings = extraSettings;
	}

	@JSON
	@Override
	public String getVersion() {
		if (_version == null) {
			return "";
		}
		else {
			return _version;
		}
	}

	@Override
	public void setVersion(String version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalVersion() {
		return getColumnOriginalValue("version");
	}

	@JSON
	@Override
	public long getVersionId() {
		return _versionId;
	}

	@Override
	public void setVersionId(long versionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_versionId = versionId;
	}

	@JSON
	@Override
	public long getSize() {
		return _size;
	}

	@Override
	public void setSize(long size) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_size = size;
	}

	@JSON
	@Override
	public String getChecksum() {
		if (_checksum == null) {
			return "";
		}
		else {
			return _checksum;
		}
	}

	@Override
	public void setChecksum(String checksum) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_checksum = checksum;
	}

	@JSON
	@Override
	public String getEvent() {
		if (_event == null) {
			return "";
		}
		else {
			return _event;
		}
	}

	@Override
	public void setEvent(String event) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_event = event;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalEvent() {
		return getColumnOriginalValue("event");
	}

	@JSON
	@Override
	public String getLanTokenKey() {
		if (_lanTokenKey == null) {
			return "";
		}
		else {
			return _lanTokenKey;
		}
	}

	@Override
	public void setLanTokenKey(String lanTokenKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lanTokenKey = lanTokenKey;
	}

	@JSON(include = false)
	@Override
	public Date getLastPermissionChangeDate() {
		return _lastPermissionChangeDate;
	}

	@Override
	public void setLastPermissionChangeDate(Date lastPermissionChangeDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lastPermissionChangeDate = lastPermissionChangeDate;
	}

	@JSON
	@Override
	public Date getLockExpirationDate() {
		return _lockExpirationDate;
	}

	@Override
	public void setLockExpirationDate(Date lockExpirationDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lockExpirationDate = lockExpirationDate;
	}

	@JSON
	@Override
	public long getLockUserId() {
		return _lockUserId;
	}

	@Override
	public void setLockUserId(long lockUserId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lockUserId = lockUserId;
	}

	@Override
	public String getLockUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getLockUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setLockUserUuid(String lockUserUuid) {
	}

	@JSON
	@Override
	public String getLockUserName() {
		if (_lockUserName == null) {
			return "";
		}
		else {
			return _lockUserName;
		}
	}

	@Override
	public void setLockUserName(String lockUserName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_lockUserName = lockUserName;
	}

	@JSON
	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalType() {
		return getColumnOriginalValue("type_");
	}

	@JSON
	@Override
	public long getTypePK() {
		return _typePK;
	}

	@Override
	public void setTypePK(long typePK) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_typePK = typePK;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalTypePK() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("typePK"));
	}

	@JSON
	@Override
	public String getTypeUuid() {
		if (_typeUuid == null) {
			return "";
		}
		else {
			return _typeUuid;
		}
	}

	@Override
	public void setTypeUuid(String typeUuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_typeUuid = typeUuid;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), SyncDLObject.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public SyncDLObject toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, SyncDLObject>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		SyncDLObjectImpl syncDLObjectImpl = new SyncDLObjectImpl();

		syncDLObjectImpl.setSyncDLObjectId(getSyncDLObjectId());
		syncDLObjectImpl.setCompanyId(getCompanyId());
		syncDLObjectImpl.setUserId(getUserId());
		syncDLObjectImpl.setUserName(getUserName());
		syncDLObjectImpl.setCreateTime(getCreateTime());
		syncDLObjectImpl.setModifiedTime(getModifiedTime());
		syncDLObjectImpl.setRepositoryId(getRepositoryId());
		syncDLObjectImpl.setParentFolderId(getParentFolderId());
		syncDLObjectImpl.setTreePath(getTreePath());
		syncDLObjectImpl.setName(getName());
		syncDLObjectImpl.setExtension(getExtension());
		syncDLObjectImpl.setMimeType(getMimeType());
		syncDLObjectImpl.setDescription(getDescription());
		syncDLObjectImpl.setChangeLog(getChangeLog());
		syncDLObjectImpl.setExtraSettings(getExtraSettings());
		syncDLObjectImpl.setVersion(getVersion());
		syncDLObjectImpl.setVersionId(getVersionId());
		syncDLObjectImpl.setSize(getSize());
		syncDLObjectImpl.setChecksum(getChecksum());
		syncDLObjectImpl.setEvent(getEvent());
		syncDLObjectImpl.setLanTokenKey(getLanTokenKey());
		syncDLObjectImpl.setLastPermissionChangeDate(
			getLastPermissionChangeDate());
		syncDLObjectImpl.setLockExpirationDate(getLockExpirationDate());
		syncDLObjectImpl.setLockUserId(getLockUserId());
		syncDLObjectImpl.setLockUserName(getLockUserName());
		syncDLObjectImpl.setType(getType());
		syncDLObjectImpl.setTypePK(getTypePK());
		syncDLObjectImpl.setTypeUuid(getTypeUuid());

		syncDLObjectImpl.resetOriginalValues();

		return syncDLObjectImpl;
	}

	@Override
	public int compareTo(SyncDLObject syncDLObject) {
		int value = 0;

		if (getModifiedTime() < syncDLObject.getModifiedTime()) {
			value = -1;
		}
		else if (getModifiedTime() > syncDLObject.getModifiedTime()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		if (getRepositoryId() < syncDLObject.getRepositoryId()) {
			value = -1;
		}
		else if (getRepositoryId() > syncDLObject.getRepositoryId()) {
			value = 1;
		}
		else {
			value = 0;
		}

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof SyncDLObject)) {
			return false;
		}

		SyncDLObject syncDLObject = (SyncDLObject)object;

		long primaryKey = syncDLObject.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<SyncDLObject> toCacheModel() {
		SyncDLObjectCacheModel syncDLObjectCacheModel =
			new SyncDLObjectCacheModel();

		syncDLObjectCacheModel.syncDLObjectId = getSyncDLObjectId();

		syncDLObjectCacheModel.companyId = getCompanyId();

		syncDLObjectCacheModel.userId = getUserId();

		syncDLObjectCacheModel.userName = getUserName();

		String userName = syncDLObjectCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			syncDLObjectCacheModel.userName = null;
		}

		syncDLObjectCacheModel.createTime = getCreateTime();

		syncDLObjectCacheModel.modifiedTime = getModifiedTime();

		syncDLObjectCacheModel.repositoryId = getRepositoryId();

		syncDLObjectCacheModel.parentFolderId = getParentFolderId();

		syncDLObjectCacheModel.treePath = getTreePath();

		String treePath = syncDLObjectCacheModel.treePath;

		if ((treePath != null) && (treePath.length() == 0)) {
			syncDLObjectCacheModel.treePath = null;
		}

		syncDLObjectCacheModel.name = getName();

		String name = syncDLObjectCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			syncDLObjectCacheModel.name = null;
		}

		syncDLObjectCacheModel.extension = getExtension();

		String extension = syncDLObjectCacheModel.extension;

		if ((extension != null) && (extension.length() == 0)) {
			syncDLObjectCacheModel.extension = null;
		}

		syncDLObjectCacheModel.mimeType = getMimeType();

		String mimeType = syncDLObjectCacheModel.mimeType;

		if ((mimeType != null) && (mimeType.length() == 0)) {
			syncDLObjectCacheModel.mimeType = null;
		}

		syncDLObjectCacheModel.description = getDescription();

		String description = syncDLObjectCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			syncDLObjectCacheModel.description = null;
		}

		syncDLObjectCacheModel.changeLog = getChangeLog();

		String changeLog = syncDLObjectCacheModel.changeLog;

		if ((changeLog != null) && (changeLog.length() == 0)) {
			syncDLObjectCacheModel.changeLog = null;
		}

		syncDLObjectCacheModel.extraSettings = getExtraSettings();

		String extraSettings = syncDLObjectCacheModel.extraSettings;

		if ((extraSettings != null) && (extraSettings.length() == 0)) {
			syncDLObjectCacheModel.extraSettings = null;
		}

		syncDLObjectCacheModel.version = getVersion();

		String version = syncDLObjectCacheModel.version;

		if ((version != null) && (version.length() == 0)) {
			syncDLObjectCacheModel.version = null;
		}

		syncDLObjectCacheModel.versionId = getVersionId();

		syncDLObjectCacheModel.size = getSize();

		syncDLObjectCacheModel.checksum = getChecksum();

		String checksum = syncDLObjectCacheModel.checksum;

		if ((checksum != null) && (checksum.length() == 0)) {
			syncDLObjectCacheModel.checksum = null;
		}

		syncDLObjectCacheModel.event = getEvent();

		String event = syncDLObjectCacheModel.event;

		if ((event != null) && (event.length() == 0)) {
			syncDLObjectCacheModel.event = null;
		}

		syncDLObjectCacheModel.lanTokenKey = getLanTokenKey();

		String lanTokenKey = syncDLObjectCacheModel.lanTokenKey;

		if ((lanTokenKey != null) && (lanTokenKey.length() == 0)) {
			syncDLObjectCacheModel.lanTokenKey = null;
		}

		Date lastPermissionChangeDate = getLastPermissionChangeDate();

		if (lastPermissionChangeDate != null) {
			syncDLObjectCacheModel.lastPermissionChangeDate =
				lastPermissionChangeDate.getTime();
		}
		else {
			syncDLObjectCacheModel.lastPermissionChangeDate = Long.MIN_VALUE;
		}

		Date lockExpirationDate = getLockExpirationDate();

		if (lockExpirationDate != null) {
			syncDLObjectCacheModel.lockExpirationDate =
				lockExpirationDate.getTime();
		}
		else {
			syncDLObjectCacheModel.lockExpirationDate = Long.MIN_VALUE;
		}

		syncDLObjectCacheModel.lockUserId = getLockUserId();

		syncDLObjectCacheModel.lockUserName = getLockUserName();

		String lockUserName = syncDLObjectCacheModel.lockUserName;

		if ((lockUserName != null) && (lockUserName.length() == 0)) {
			syncDLObjectCacheModel.lockUserName = null;
		}

		syncDLObjectCacheModel.type = getType();

		String type = syncDLObjectCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			syncDLObjectCacheModel.type = null;
		}

		syncDLObjectCacheModel.typePK = getTypePK();

		syncDLObjectCacheModel.typeUuid = getTypeUuid();

		String typeUuid = syncDLObjectCacheModel.typeUuid;

		if ((typeUuid != null) && (typeUuid.length() == 0)) {
			syncDLObjectCacheModel.typeUuid = null;
		}

		return syncDLObjectCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<SyncDLObject, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<SyncDLObject, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SyncDLObject, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((SyncDLObject)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<SyncDLObject, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<SyncDLObject, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<SyncDLObject, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((SyncDLObject)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, SyncDLObject>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					SyncDLObject.class, ModelWrapper.class);

	}

	private long _syncDLObjectId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private long _createTime;
	private long _modifiedTime;
	private long _repositoryId;
	private long _parentFolderId;
	private String _treePath;
	private String _name;
	private String _extension;
	private String _mimeType;
	private String _description;
	private String _changeLog;
	private String _extraSettings;
	private String _version;
	private long _versionId;
	private long _size;
	private String _checksum;
	private String _event;
	private String _lanTokenKey;
	private Date _lastPermissionChangeDate;
	private Date _lockExpirationDate;
	private long _lockUserId;
	private String _lockUserName;
	private String _type;
	private long _typePK;
	private String _typeUuid;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<SyncDLObject, Object> function = _attributeGetterFunctions.get(
			columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((SyncDLObject)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("syncDLObjectId", _syncDLObjectId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createTime", _createTime);
		_columnOriginalValues.put("modifiedTime", _modifiedTime);
		_columnOriginalValues.put("repositoryId", _repositoryId);
		_columnOriginalValues.put("parentFolderId", _parentFolderId);
		_columnOriginalValues.put("treePath", _treePath);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("extension", _extension);
		_columnOriginalValues.put("mimeType", _mimeType);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("changeLog", _changeLog);
		_columnOriginalValues.put("extraSettings", _extraSettings);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("versionId", _versionId);
		_columnOriginalValues.put("size_", _size);
		_columnOriginalValues.put("checksum", _checksum);
		_columnOriginalValues.put("event", _event);
		_columnOriginalValues.put("lanTokenKey", _lanTokenKey);
		_columnOriginalValues.put(
			"lastPermissionChangeDate", _lastPermissionChangeDate);
		_columnOriginalValues.put("lockExpirationDate", _lockExpirationDate);
		_columnOriginalValues.put("lockUserId", _lockUserId);
		_columnOriginalValues.put("lockUserName", _lockUserName);
		_columnOriginalValues.put("type_", _type);
		_columnOriginalValues.put("typePK", _typePK);
		_columnOriginalValues.put("typeUuid", _typeUuid);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("size_", "size");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("syncDLObjectId", 1L);

		columnBitmasks.put("companyId", 2L);

		columnBitmasks.put("userId", 4L);

		columnBitmasks.put("userName", 8L);

		columnBitmasks.put("createTime", 16L);

		columnBitmasks.put("modifiedTime", 32L);

		columnBitmasks.put("repositoryId", 64L);

		columnBitmasks.put("parentFolderId", 128L);

		columnBitmasks.put("treePath", 256L);

		columnBitmasks.put("name", 512L);

		columnBitmasks.put("extension", 1024L);

		columnBitmasks.put("mimeType", 2048L);

		columnBitmasks.put("description", 4096L);

		columnBitmasks.put("changeLog", 8192L);

		columnBitmasks.put("extraSettings", 16384L);

		columnBitmasks.put("version", 32768L);

		columnBitmasks.put("versionId", 65536L);

		columnBitmasks.put("size_", 131072L);

		columnBitmasks.put("checksum", 262144L);

		columnBitmasks.put("event", 524288L);

		columnBitmasks.put("lanTokenKey", 1048576L);

		columnBitmasks.put("lastPermissionChangeDate", 2097152L);

		columnBitmasks.put("lockExpirationDate", 4194304L);

		columnBitmasks.put("lockUserId", 8388608L);

		columnBitmasks.put("lockUserName", 16777216L);

		columnBitmasks.put("type_", 33554432L);

		columnBitmasks.put("typePK", 67108864L);

		columnBitmasks.put("typeUuid", 134217728L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private SyncDLObject _escapedModel;

}