/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.sync.internal.model.listener;

import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.sync.model.SyncDLObject;
import com.liferay.sync.service.SyncDLObjectLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class CompanyModelListener
extends BaseModelListener<Company> {
    @Reference
    private SyncDLObjectLocalService _syncDLObjectLocalService;

    public void onAfterRemove(Company company) throws ModelListenerException {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            this._deleteSyncDLObject(company);
            return null;
        });
    }

    private void _deleteSyncDLObject(Company company) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._syncDLObjectLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)company.getCompanyId())));
        actionableDynamicQuery.setPerformActionMethod(SyncDLObject2 -> this._syncDLObjectLocalService.deleteSyncDLObject((SyncDLObject)SyncDLObject2));
        actionableDynamicQuery.performActions();
    }
}

